<?php $this->load->view('schedule/mpdf_css') ?>
<body>
    <div class="pdf-page-header margin">
        <?php echo nl2br($HEADER_TEMPLATE['config_value']); ?>
    </div>
    <div class="page-content container">
        <center><div  class="pdf-title margin">SCHEDULE (<?php echo date('m-Y'); ?>) </div></center>
        <table class="pdf-header-table margin f-s">
            <thead>
                <tr>
                    <th class="pdf-header-th a-l"> Meeting Time: 11 to 7 pm</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <?php
                    $schedule_date = new DateTime($schedule_date);
                    ?>
                    <th class="pdf-tbody-th a-l b-t" colspan="2">
                        <?php
                        $month = $schedule_date->format('F');
                        $year = $schedule_date->format('Y');
                        echo $month . ' : ' . $year
                        ?>
                    </th>
                </tr>
            </tbody>
        </table>
        <table class="pdf-content-table margin f-s">
            <thead>
                <tr>
                    <th class="pdf-content a-l">Date</th>
                    <th class="pdf-content a-l">Day</th>
                    <th class="pdf-content a-l">Description</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $course_data = $all_course_data;
                foreach ($all_schedule_data as $schedule_data) {
                    $schedule_date = new DateTime($schedule_data['schedule_date']);
                    $schedule_from_time = $schedule_data['schedule_from_time'];
                    $time_in_12_hour_format_for_schedule_from_time = date("g:i a", strtotime($schedule_from_time));
                    $schedule_to_time = ($schedule_data['schedule_to_time']);
                    $time_in_12_hour_format_for_schedule_to_time = date("g:i a", strtotime($schedule_to_time));
                    ?>
                    <tr>
                        <td class="pdf-content a-l">
                            <?php
                            $number = $schedule_date->format('j');
                            echo $number
                            ?><sup><?php echo ordinal($number); ?></sup><?php ?>
                        </td>
                        <td class="pdf-content a-l">
                            <?php echo $schedule_date->format('l'); ?>
                            <?php echo $time_in_12_hour_format_for_schedule_from_time; ?><?php echo ' to ' ?>
                            <?php echo $time_in_12_hour_format_for_schedule_to_time; ?>
                        </td>
                        <td class="pdf-content a-l"> 
                            <?php
                            $detail = '';
                            if ($all_course_data[$schedule_data['schedule_course_id']]['course_description'] != '') {
                                $detail = '(' . $all_course_data[$schedule_data['schedule_course_id']]['course_description'] . ')';
                            }
                            echo $all_course_data[$schedule_data['schedule_course_id']]['course_title'] . $detail;
                            ?>
                        </td>
                    </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    <div class="pdf-page-footer margin">
        <?php echo nl2br($FOOTER_TEMPLATE['config_value']); ?>
    </div>
<pagebreak />
<div class="pdf-page-header margin">
    <?php echo nl2br($HEADER_TEMPLATE['config_value']); ?>
</div>
<div class="pdf-page-back margin">
    <?php echo nl2br($BACK_TEMPLATE['config_value']); ?>
</div>
</body>