<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_enrollment_model extends CI_Model {

    function save_enrollment($student_enrollment) {
        $student_enrollment['enrollment_created_by'] = get_from_session('ccm_user_id');
        $this->db->insert('enrollment', $student_enrollment);
        return $this->db->insert_id();
    }

    function save_enrollment_course($student_enrollment_course) {
        $this->db->insert('enrollment_course', $student_enrollment_course);
        return $this->db->insert_id();
    }

    function get_discount($no_of_course) {
        $sql = "SELECT * FROM package where (no_of_course + no_of_free_course)='" . $no_of_course . "' AND (validity>=CURDATE() OR validity = '1970-01-01')";
        $recs = $this->db->query($sql);
        return $recs->row_array();
    }

    function get_enrollment_details($student_id, $from_date, $to_date, $validity_date) {
        $this->db->select('e.enrollment_id ,DATE(e.enrollment_created_date) AS enrollment_created_date,DATE(e.enrollment_validity_date) AS enrollment_validity_date,e.student_id,e.sub_total,sum(p.payment_amount) as payment_amount,e.due_amounts,e.discount,e.enrollment_yearly_membership,e.additional_discount_percentage,e.additional_discount_amount');
        $this->db->from('enrollment as e');
        $this->db->join('payment p', 'e.enrollment_id=p.enrollment_id', 'left');
        $this->db->where('e.student_id', $student_id);
        $this->db->where('e.is_delete', ISDELETEYES);
        if ($from_date != '') {
            $this->db->where('enrollment_created_date >="' . $from_date . ' 00:00:00"');
        }
        if ($to_date != '') {
            $this->db->where('enrollment_created_date <="' . $to_date . ' 23:59:59"');
        }
        if ($validity_date != '') {
            $this->db->where('enrollment_validity_date', $validity_date);
        }
        $this->db->group_by('e.enrollment_id,p.student_id');
        $this->db->order_by('e.enrollment_created_date', 'desc');
        return $this->db->get()->result_array();
    }

    function get_enrollment_course_details($enrollment_id) {
        $this->db->select('c.course_title,c.course_id,c.course_fees,ec.enrollment_course_amount,ec.enrollment_course_id');
        $this->db->from('course AS c');
        $this->db->join('enrollment_course AS ec', 'ec.course_id=c.course_id');
        $this->db->join('enrollment AS e', 'e.enrollment_id=ec.enrollment_id');
        $this->db->where('e.enrollment_id', $enrollment_id);
        return $this->db->get()->result_array();
    }

    function get_attendance($enrollment_id,$course_id,$student_id)
    {
        $this->db->select('sa.*');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id = sa.attendance_schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);
        $this->db->where('sa.attendance_student_id',$student_id);
        return $this->db->get()->row_array();
    }

    function get_enrollment_detail_by_id($enrollment_id) {
        $this->db->select('e.enrollment_id,DATE(e.enrollment_created_date) AS enrollment_created_date,DATE(e.enrollment_validity_date) AS enrollment_validity_date,e.sub_total,e.enrollment_yearly_membership,sum(p.payment_amount) as payment_amount,e.due_amounts,e.discount,'
                . 'e.additional_discount_percentage,e.additional_discount_amount,e.total_discount,e.payable_amount,e.enrollment_discount_note');
        $this->db->from('enrollment AS e');
        $this->db->join('payment AS p', 'p.enrollment_id=e.enrollment_id', 'left');
        $this->db->where('e.enrollment_id', $enrollment_id);
        $this->db->group_by('e.enrollment_id');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function enrollment_course_detail_by_id($enrollment_id) {
        $this->db->select('enrollment_id,course_id,enrollment_course_id,enrollment_course_name,enrollment_course_amount');
        $this->db->from('enrollment_course');
        $this->db->where('enrollment_id', $enrollment_id);
        return $this->db->get()->result_array();
    }

    function update_enrollment($enrollment_data, $enrollment_id) {
        $enrollment_data['enrollment_updated_date'] = date('Y-m-d h:i:s');
        $enrollment_data['enrollment_updated_by'] = get_from_session('ccm_user_id');
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->update('enrollment', $enrollment_data);
    }

    function delete_old_enrollment_course($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->delete('enrollment_course');
    }

    function get_enrollment_validity($package_validity_no) {
        $this->db->where('(no_of_course + no_of_free_course)=', $package_validity_no);
        $this->db->where('validity >=', 'CURDATE()', FALSE);
        return $this->db->get('package')->row_array();
    }

    function check_enrollment_payment_exist($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        return $this->db->get('payment')->result_array();
    }

    function delete_enrollment_course($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->delete('enrollment_course');
    }

    function delete_enrollment($enrollment_id, $enrollment_data) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->update('enrollment', $enrollment_data);
    }

    function get_all_enrollment_details() {
        $resc = $this->db->get('enrollment');
        return $resc->result_array();
    }

    function calculate_student_course_revenue($enrollment_id) {
        $this->db->select('count(ec.enrollment_course_id) as no_of_courses,sum(enrollment_course_amount)/count(ec.enrollment_course_id) as average_amount');
        $this->db->from('enrollment AS e');
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        $this->db->where('e.enrollment_id', $enrollment_id);
        return $this->db->get()->row_array();
    }

    function check_enrollment_exist($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->where('is_delete', ISDELETEYES);
        $result = $this->db->get('enrollment');
        return $result->result_array();
    }

    function get_enrollment_details_by_id($course_id, $student_id) {
        $this->db->where('ec.course_id', $course_id);
        $this->db->where('e.student_id', $student_id);
        $this->db->join('enrollment_course as ec', 'ec.enrollment_id = e.enrollment_id');
        $this->db->order_by('e.enrollment_created_date');
        return $this->db->get('enrollment as e')->result_array();
    }

    function chceck_enrollment_course($student_id,$course_id,$enrollment_id) {

        $this->db->select('ec.enrollment_course_name');
        $this->db->from('enrollment e');
        $this->db->join('enrollment_course as ec', 'ec.enrollment_id = e.enrollment_id');
        $this->db->where('e.student_id',$student_id);
        $this->db->where('ec.course_id',$course_id);
        if($enrollment_id != '')
        {
            $this->db->where('e.enrollment_id !=',$enrollment_id);
        }
        $res = $this->db->get();
        return $res->row_array();

    }
    // function get_enrolled_student($course_id) {
        
    //     $this->db->select('s.*,s.student_id,si.student_interest_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts,ec.enrollment_course_id,e.enrollment_id');
    //     $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
    //     $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
    //     $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
    //     $this->db->select("2 AS status");
    //     $this->db->from('enrollment e');
    //     $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
    //     $this->db->join('student_master s','s.student_id=e.student_id');
    //     $this->db->join('student_interest si','si.student_id=s.student_id','left');
    //     $this->db->where('e.is_delete',ISDELETEYES);
    //     $this->db->where('ec.course_id',$course_id);
    //     //$this->db->where('si.enrollment_course_id !=',0);
    //     //$this->db->where('si.status !=',1);
    //     //$this->db->where('si.course_id',$course_id);
    //     // $this->db->where('e.enrollment_id IN( SELECT MAX(enrollment_id) FROM enrollment GROUP BY student_id )');
    //     //$this->db->group_by('e.student_id',' DESC');
    //     $this->db->order_by('ec.enrollment_course_id');
    //     $res = $this->db->get();
    //     return $res->result_array();
    // }

    // function get_enrolled_student($course_id) {
        
    //     $this->db->select('e.*,s.*,s.student_id,si.student_interest_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts,ec.enrollment_course_id,e.enrollment_id');
    //     $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
    //     $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
    //     $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');        
    //     $this->db->select("2 AS status");
    //     $this->db->from('enrollment e');
    //     $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
    //     $this->db->join('student_master s','s.student_id=e.student_id');
    //     $this->db->join('student_interest si','si.student_id=s.student_id','left');
    //     $this->db->where('e.is_delete',ISDELETEYES);
    //     $this->db->where('ec.course_id',$course_id);  
    //     $this->db->group_by('e.student_id',' DESC');
    //     $res = $this->db->get();
    //     return $res->result_array();
    // }

    function get_enrolled_student($course_id,$status) {
        
        $this->db->select('s.*,s.student_id,si.student_interest_id,si.course_id,si.next,si.status,si.food_type,count(e.enrollment_id) AS total_enrollment,sum(e.due_amounts) AS due_amounts,ec.enrollment_course_id,e.enrollment_id,e.*,'.$status.' as status_type');
        $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
        $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
        $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');        
        $this->db->select("2 AS status");
        $this->db->from('enrollment e');
        $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->join('student_interest si','si.student_id=s.student_id','left');
        $this->db->where('e.is_delete',ISDELETEYES);
        $this->db->where('ec.course_id',$course_id);  
        //$this->db->where('e.enrollment_id IN (SELECT COALESCE(MAX(enrollment_id),0) FROM enrollment GROUP BY student_id)');
        $this->db->where('e.enrollment_id IN (SELECT COALESCE(MAX(enrollment.enrollment_id),0) FROM enrollment JOIN enrollment_course ON enrollment_course.enrollment_id=enrollment.enrollment_id WHERE enrollment.enrollment_id = e.enrollment_id  GROUP BY student_id)');
        $this->db->group_by('e.student_id',' DESC');
        $res = $this->db->get();
        return $res->result_array();
    }


    function get_enrolled_student_count($course_id) {
        
        $this->db->select('s.student_id');        
        $this->db->from('enrollment e');
        $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->join('student_interest si','si.student_id=s.student_id','left');
        $this->db->where('e.is_delete',ISDELETEYES);
        $this->db->where('ec.course_id',$course_id);  
        $this->db->group_by('e.student_id',' DESC');
        $res = $this->db->get();
        return $res->result_array();
    }

    function enrollment_data($enrollment_id)
    {
        $this->db->select('e.enrollment_id,ec.*,c.course_duration,s.student_id,s.student_first_name,s.student_last_name');
        $this->db->from('enrollment e');
        $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->join('course c','c.course_id=ec.course_id');
        $this->db->where('e.is_delete',ISDELETEYES);
        $this->db->where('e.enrollment_id',$enrollment_id);
        $this->db->order_by('e.enrollment_id','ASC');
        return $this->db->get()->result_array();
    }
    function update_interest($course_id,$student_id,$enrollment_course_id)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('enrollment_course_id',$enrollment_course_id);
        $res = $this->db->get()->result_array();

        if(!empty($res))
        {
            $this->db->where('student_id', $student_id);
            $this->db->where('course_id',$course_id);
            $this->db->set('status', 0);
            $this->db->set('enrollment_course_id', 0);
            $this->db->update('student_interest');
        }
       
    }
    function delete_interest($course_id,$student_id,$enrollment_course_id)
    {      
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id',$course_id);
        $this->db->where('enrollment_course_id',$enrollment_course_id);
        $this->db->delete('student_interest');
    }
    function delete_enrolled_intrest($course_id,$student_id,$enrollment_course_id)
    {        
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id', $course_id);
        $this->db->where('enrollment_course_id', $enrollment_course_id);
        $this->db->delete('student_interest');
    }

}

/**
 * EOF: ./application/models/Courses_model.php
 */
