<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment_model extends CI_Model {

    function get_payment_details($student_id) {
        $sql = 'SELECT e.enrollment_id, e.student_id, e.enrollment_yearly_membership, e.student_id, e.sub_total, e.discount, e.due_amounts, e.total_discount, '
                . '    e.enrollment_created_date, e.enrollment_validity_date, e.enrollment_id  '
                . ' FROM enrollment AS e ' 
                . ' LEFT JOIN enrollment_course ec ON e.enrollment_id=ec.enrollment_id '
                . ' WHERE e.student_id=\'' . $student_id . '\''
                . ' AND e.is_delete=\'' . ISDELETEYES . '\''
                . ' GROUP BY e.enrollment_id ORDER BY e.enrollment_created_date DESC';
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    function get_payment_amount($student_id) {
        $sql = "select e.enrollment_id ,e.student_id,sum(p.payment_amount) as paid_amount from enrollment as e
                left join payment p on e.enrollment_id=p.enrollment_id and e.student_id= p.student_id 
                where e.student_id='" . $student_id . "' group by e.enrollment_id,p.student_id";
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    function get_by_student_id($student_id) {
        $this->db->select('student_first_name,student_middle_name,student_last_name');
        $this->db->where('student_id', $student_id);
        $this->db->from('student_master');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function create($payment_data) {
        $this->db->insert('payment', $payment_data);
        return $this->db->insert_id();
    }

    function update_payment_mode($payment_update_data)
    {
        $this->db->set('payment_mode',$payment_update_data['payment_mode']);
        $this->db->where('payment_id',$payment_update_data['payment_id']);
        $this->db->update('payment');
    }

    function update_payment($payment_update_data)
    {
        $this->db->set('payment_amount',$payment_update_data['payment_amount']);
        $this->db->set('payment_mode',$payment_update_data['payment_mode']);
        $this->db->set('payment_reference_number',$payment_update_data['payment_reference_number']);
        $this->db->set('payment_remarks',$payment_update_data['payment_remarks']);
        $this->db->where('payment_id',$payment_update_data['payment_id']);
        $this->db->update('payment');
    }

    function update_due_amount($student_id, $enrollment_id, $amount) {
        $sql = "UPDATE `enrollment` SET `due_amounts` = `due_amounts` - $amount WHERE `enrollment_id` = $enrollment_id AND `student_id` = $student_id";
        $this->db->query($sql);
    }

    function update_enrollment_due_amount($enrollment_id) {

        $this->db->select('sum(payment_amount) as payment_amount');
        $this->db->from('payment');
        $this->db->where('enrollment_id',$enrollment_id);
        $res = $this->db->get()->row_array();

        $sql = "UPDATE `enrollment` SET `due_amounts` = `payable_amount` - ".$res['payment_amount']." WHERE `enrollment_id` = ".$enrollment_id;
        $this->db->query($sql);
    }

    function get_payments($enrollment_id, $student_id) {
        $this->db->select('DATE_FORMAT(p.payment_date, "%d-%m-%Y") AS payment_date, p.enrollment_id, p.student_id, ROUND(p.payment_amount) AS payment_amount ,p.payment_mode,p.payment_reference_number,p.payment_remarks,p.payment_id');
        $this->db->from('payment AS p');
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->where('student_id', $student_id);
        $this->db->order_by('p.payment_date','ASC');
        return $this->db->get()->result_array();
    }

    function update_enrollment_payment($enrollment_payment_data, $enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->update('payment', $enrollment_payment_data);
    }

    function delete_payment_by_id($payment_id) {
        $this->db->where('payment_id', $payment_id);
        $this->db->delete('payment');
    }

    function get_payment_by_payment_id($payment_id) {
        $this->db->select('*');
        $this->db->from('payment');
        $this->db->where('payment_id', $payment_id);
        return $this->db->get()->row_array();
    }

    function get_bill_pdf_data_by_payment_id($payment_id) {
        $this->db->select('p.*,s.*,e.sub_total,e.total_discount,e.payable_amount,e.due_amounts');
        $this->db->select('(SELECT GROUP_CONCAT(enrollment_course_name) FROM enrollment_course WHERE enrollment_id=p.enrollment_id) as courses');
        $this->db->from('payment p');
        $this->db->join('enrollment e','e.enrollment_id=p.enrollment_id');
        $this->db->join('student_master AS s', 's.student_id=p.student_id');
        $this->db->where('p.payment_id', $payment_id);
        return $this->db->get()->row_array();
    }

    function update_due_amount_for_delete($enrollment_id, $student_id, $amount) {
        $sql = "UPDATE `enrollment` SET `due_amounts` = `due_amounts` + $amount WHERE `enrollment_id` = $enrollment_id AND `student_id` = $student_id";
        $this->db->query($sql);
    }

    function get_all_payment_of_enrollment($enrollment_id,$payment_id,$payment_date)
    {
        $this->db->select('p.*');
        $this->db->from('payment p');
        $this->db->join('enrollment e','e.enrollment_id=p.enrollment_id');
        $this->db->where('p.enrollment_id',$enrollment_id);
        //$this->db->where('p.payment_id',$payment_id);
        $this->db->where('p.payment_date <=',$payment_date);
        $this->db->order_by('p.payment_date','ASC');
        return $this->db->get()->result_array();
    }

    function get_all_payment_sum_of_enrollment($enrollment_id)
    {
        $this->db->select('sum(payment_amount) as payment_amount');
        $this->db->from('payment p');
        $this->db->join('enrollment e','e.enrollment_id=p.enrollment_id');
        $this->db->where('p.enrollment_id',$enrollment_id);        
        return $this->db->get()->row_array();
    }

    function get_last_invoice_no($year,$month)
    {
        $this->db->select('MAX(invoice_no) as invoice_no');
        $this->db->from('payment p');
        $this->db->where('YEAR(payment_date)',$year);
        $this->db->where('MONTH(payment_date)',$month);
        return $this->db->get()->row_array();
    }

    function get_payment_detail($payment_id)
    {
        $this->db->select('p.*,DATE_FORMAT(p.payment_date, "%d-%m-%Y") AS payment_date');
        $this->db->from('payment p');
        $this->db->where('p.payment_id =',$payment_id);
        $res = $this->db->get()->row_array();
        return $res;
    }

}

/**
 * EOF: ./application/models/Payment_model.php
 */
    