<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Courses_model extends CI_Model {

    function create($courses) {
        $courses['course_created_date'] = date('Y-m-d h:i:s');
        $this->db->insert('course', $courses);
        return $this->db->insert_id();
    }

//     function get_all_type() {
// //        $this->db->order_by('course_id');
//         $this->db->order_by('course_title', 'asc');
//         return $this->db->get('course')->result_array();
//     }

    function get_all_type() {

        $this->db->select('c.*');
        $this->db->from('course c');
        $this->db->order_by('c.course_title', 'asc');
        return $this->db->get()->result_array();
    }

    function is_course_exist() {
        $this->db->where('course_is_selling', YES);
        $this->db->where('course_is_active', YES);
        $this->db->order_by('course_title', 'asc');
        return $this->db->get('course')->result_array();
    }

    function get_by_courses_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->from('course');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function update_courses($courses_id, $courses) {
        $courses['course_updated_date'] = date('Y-m-d h:i:s');
        $this->db->where('course_id', $courses_id);
        $this->db->update('course', $courses);
    }

    function delete_course_by_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->delete('course');
    }

    function get_exists_course_details($courses_title) {
        $this->db->where('course_title', $courses_title);
        return $this->db->get('course')->row_array();
    }

    function get_enrollment_details($course_id, $from_date, $to_date) {
        $this->db->select(' DATE_FORMAT(e.enrollment_created_date, "%d-%m-%Y") AS enrollment_date,c.course_title,c.course_id,
                    e.student_id,sm.student_first_name,sm.student_middle_name,e.sub_total,e.enrollment_id,
                    sm.student_last_name,sm.student_interestedin_email,sm.student_interestedin_message,ec.enrollment_course_amount,c.course_duration, sm.student_mobile,sm.discontinue');
        $this->db->from('course AS c');
        $this->db->join('enrollment_course AS ec', 'c.course_id=ec.course_id');
        $this->db->join('enrollment AS e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master AS sm', 'e.student_id=sm.student_id');
        $this->db->where('c.course_id', $course_id);
        if ($from_date != '' && $to_date != '') {
            $this->db->where('enrollment_created_date >="' . $from_date . ' 00:00:00"');
            $this->db->where('enrollment_created_date <="' . $to_date . ' 23:59:59"');
        }
        return $this->db->get()->result_array();
    }

    function get_enrollment_course_details($student_id) {
        $this->db->select('count(ec.enrollment_id) as no_of_course,e.enrollment_id');
        $this->db->from('enrollment_course as ec');
        $this->db->join(' enrollment as e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master as sm', 'e.student_id=sm.student_id');
        $this->db->where('sm.student_id', $student_id);
        $this->db->group_by('ec.enrollment_id');
        return $this->db->get()->row_array();
    }

    function get_enrollment_by_course_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->from('enrollment_course');
        $rec = $this->db->get();
        return $rec->result_array();
    }
    
    function get_schedule_by_course_id($courses_id) {
        $this->db->where('schedule_course_id', $courses_id);
        $this->db->from('schedule');
        $rec = $this->db->get();
        return $rec->result_array();
    }
    
    function get_interest_by_course_id($courses_id) {
        $this->db->where('si.course_id', $courses_id);
        $this->db->where('sm.is_delete', ISDELETEYES);
        $this->db->from('student_interest AS si');
        $this->db->join('student_master AS sm', 'si.student_id=sm.student_id');
        $rec = $this->db->get();
        return $rec->result_array();
    }

    function get_total_waiting_student($course_id,$status) {

        $this->db->select('count(si.student_interest_id) AS total_waiting');
        $this->db->from('student_interest si');
        $this->db->join('student_master s','s.student_id=si.student_id');       
        $this->db->where('si.course_id',$course_id);
        $this->db->where('si.status',$status);
        $this->db->where('s.is_delete', ISDELETEYES);
        $this->db->where('si.enrollment_course_id',0);
        $res = $this->db->get()->row_array();
        return $res;
    }

    function get_all_groups()
    {
        $this->db->select('g.*');
        $this->db->select('(SELECT count(id) as total_courses FROM tbl_group_course WHERE group_id=g.id) as total_courses');
        $this->db->from('tbl_group g');
        $res = $this->db->get();
        return $res->result_array();
    }

    function get_group_courses($id)
    {
        $date = date('d-m-Y');
        $this->db->select('gc.id,gc.course_id,c.course_title,c.course_fees');
        //$this->db->select('CURDATE(d-m-Y) as created_date');
        $this->db->select("DATE_FORMAT(CURDATE(), '%d-%m-%Y') as created_date");
        
        $this->db->from('tbl_group_course gc');
        $this->db->join('course c','c.course_id=gc.course_id');
        $this->db->where('gc.group_id',$id);
        $res = $this->db->get()->result_array();
        return $res;
    }

    function save_group($data)
    {
        $this->db->insert('tbl_group',$data);
        return $this->db->insert_id();
    }

    function update_group($data)
    {
        $this->db->set('group_name',$data['group_name']);
        $this->db->where('id',$data['group_id']);
        $this->db->update('tbl_group');
    }

    function save_group_courses($data,$group_id)
    {
        if($group_id != '')
        {
            $this->db->where('group_id',$group_id);
            $this->db->delete('tbl_group_course');
        }
        $this->db->insert_batch('tbl_group_course',$data);
    }

    function check_group_name($group_name,$group_id)
    {
        $this->db->select('g.*');
        $this->db->from('tbl_group g');
        $this->db->where('g.group_name',$group_name);
        if($group_id != '')
        {
            $this->db->where('id !=',$group_id);
        }
        $res = $this->db->get()->result_array();
        return $res;
    }

    function delete_group($group_id)
    {
        $this->db->where('id',$group_id);
        $this->db->delete('tbl_group');

        $this->db->where('group_id',$group_id);
        $this->db->delete('tbl_group_course');
    }

    function delete_group_course($group_course_id)
    {
        $this->db->where('id',$group_course_id);
        $this->db->delete('tbl_group_course');
    }

    function get_group_detail_from_id($group_id)
    {
        $this->db->select('g.*');
        $this->db->from('tbl_group g');
        $this->db->where('id',$group_id);
        $res = $this->db->get()->row_array();
        return $res;
    }
}

/**
 * EOF: ./application/models/Courses_model.php
 */
