<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Call_log_model extends CI_Model {
    
    function get_call_log_by_student_id($student_id)
    {
        $this->db->select('cl.*');
        $this->db->select('(SELECT course_title FROM course WHERE course_id=cl.course_id) as course_title');        
        $this->db->where('cl.student_id', $student_id);
        $this->db->from('call_log cl');
        $this->db->order_by('cl.call_date','ASC');
        return $this->db->get()->result_array();
    }

    function delete_call_log($call_log_id)
    {
        $this->db->where('call_log_id', $call_log_id);
        $this->db->delete('call_log');
    }

    function get_last_call_date($student_id)
    {
        $this->db->select('call_date,note,course.course_title');
        $this->db->from('call_log');
        $this->db->join('course','course.course_id=call_log.course_id');
        $this->db->where('student_id',$student_id);
        $this->db->order_by("call_date DESC,call_log_id DESC");        
        $this->db->limit('1');
        return $this->db->get()->row_array();
    }

    function save_call_log($call_log)
    {
         $this->db->insert_batch('call_log', $call_log);
    }

    function get_call_status($course_id,$schedule_date,$list_type)
    {
        $this->db->select('*,DATE_FORMAT(done_date, "%d-%m-%Y")');
        $this->db->from('call_status');
        $this->db->where('schedule_date',$schedule_date);
        $this->db->where('course_id',$course_id);
        $this->db->where('list_type',$list_type);
        return $this->db->get()->row_array();
    }

    function delete_call_status($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('call_status');
    }

    function add_call_status($add)
    {
        $this->db->insert('call_status', $add);
        return $this->db->insert_id();
    } 

    function get_reminder_data($date)
    {
        $this->db->select('cl.*,DATE_FORMAT(call_date, "%d-%m-%Y") as call_date,DATE_FORMAT(reminder_date, "%d-%m-%Y") as reminder_date,s.student_first_name,s.student_middle_name,s.student_last_name');
        $this->db->select('(SELECT course_title FROM course WHERE course_id=cl.course_id) as course_title');
        $this->db->from('call_log cl');
        $this->db->join('student_master s','s.student_id=cl.student_id');
        $this->db->where("IF(cl.reminder_date < '".$date."' , cl.follow_up = 0, cl.reminder_date = '".$date."')");
        $this->db->where('cl.reminder_date != ','0000-00-00');
        $this->db->where('s.is_delete', ISDELETEYES);
        $this->db->order_by('cl.reminder_date','ASC');
        return $this->db->get()->result_array();
    }

    function get_all_call_logs($student_id)
    {
        $this->db->select('cl.*,DATE_FORMAT(call_date, "%d-%m-%Y") as call_date,DATE_FORMAT(reminder_date, "%d-%m-%Y") as reminder_date,c.course_title');
        $this->db->from('call_log cl');
        $this->db->join('course c','c.course_id=cl.course_id');
        $this->db->where('cl.student_id',$student_id);
        return $this->db->get()->result_array();
    }

    function set_student_follow_up($call_log_id,$status)
    {
        $this->db->where('call_log_id', $call_log_id);
        $this->db->set('follow_up', $status);
        $this->db->update('call_log');
    }

    function get_total_reminder()
    {
        $this->db->select('count(cl.call_log_id) as total_reminder');
        $this->db->from('call_log cl');
        $this->db->join('student_master s','s.student_id=cl.student_id');
        $this->db->where('cl.reminder_date <= ',date('Y-m-d'));
        $this->db->where('cl.reminder_date != ','0000-00-00');
        $this->db->where('cl.follow_up = ', 0);
        $this->db->where('s.is_delete', ISDELETEYES);
        return $this->db->get()->row_array();
    }
}
