<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Packages extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('packages_model');
        check_authenticated();
    }

    function view_packages() {
        $result = $this->packages_model->get_all_data();
        echo json_encode($result);
    }

    function save_packages() {
        $packages_data = $this->input->post('packages_form_data');
        foreach ($packages_data as $pd) {
            $pd['validity'] = to_database_format($pd['validity']);
            $pd['created_date'] = date('Y-m-d H:i:s');
            $pd['created_by'] = get_from_session('ccm_user_id');
            $sumpack = $pd['no_of_course'] + $pd['no_of_free_course'];
            // $cnt = $this->packages_model->check_sum($sumpack);
            $result = $this->packages_model->check_sum($sumpack);
            if (!empty($result)) {
                echo json_encode(array('success' => false, 'message' => 'Package Already Exist'));
                return;
            } else {
                $this->packages_model->insert_packages($pd);
            }
        }
        echo json_encode(array('success' => true, 'message' => 'Package saved succefully'));
    }

    function get_by_id($pid) {
        $pack = $this->packages_model->get_by_id($pid);
        $validity_date = new DateTime($pack['validity']);
        $pack['validity'] = $validity_date->format('d-m-Y');
        echo json_encode($pack);
    }

    function update() {
        $package_id = $this->input->post('package_id');
        $data['no_of_course'] = $this->input->post('no_of_course');
        $data['no_of_free_course'] = $this->input->post('no_of_free_course');
        $data['validity'] = to_database_format($this->input->post('validity'));
        $data['package_validity_duration'] = $this->input->post('package_validity_duration');
        $data['package_validity_no'] = $this->input->post('package_validity_no');
        $data['updated_date'] = date('Y-m-d H:i:s');
        $data['updated_by'] = get_from_session('ccm_user_id');
        $sumpack = $data['no_of_course'] + $data['no_of_free_course'];
        $pack = $this->packages_model->get_by_id($package_id);
        if ($data['no_of_free_course'] != $pack['no_of_free_course'] || $data['no_of_course'] != $pack['no_of_course']) {
            $result = $this->packages_model->check_sum($sumpack, "Edit", $package_id);
            if (!empty($result)) {
                echo json_encode(array('success' => false, 'message' => 'Package Already Exist'));
                return;
            }
        }
        $this->packages_model->update_packages($data, $package_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Package Update succefully'));
    }

    function delete_packages() {
        $package_id = $this->input->post('package_id');
        $this->packages_model->delete_packages_by_id($package_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Package Deleted succefully'));
    }

}
