var coursesListTemplate = Handlebars.compile($('#courses_list_template').html());
var coursesTableTemplate = Handlebars.compile($('#courses_table_template').html());
var coursesFormTemlate = Handlebars.compile($('#courses_form_temlate').html());
var coursesActionButtonsTemplate = Handlebars.compile($("#courses_action_buttons_template").html());
var viewEnrollmentStudent = Handlebars.compile($("#view_enrollment_student_template").html());
var enrollmentCourse = Handlebars.compile($("#enrollment_course_template").html());
var showCoursePaymentsBtnTemplate = Handlebars.compile($('#show_course_payment_btn_template').html());
var Courses = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
Courses.Router = Backbone.Router.extend({
    routes: {
        'courses/list': 'renderList',
        'courses/:id': 'renderCoursesDetail'
    },
    renderList: function () {
        Courses.listview.listPage();
    },
    renderCoursesDetail: function (coursesId) {
        Courses.listview.coursesDetail(coursesId);
    }
});
Courses.listView = Backbone.View.extend({
    el: 'div#main_container',
    events: {
        'click #new_courses_btn': 'newCourses',
        'click #save_courses_btn': 'saveCourses',
        'click #update_courses_btn': 'saveCourses'
    },
    listPage: function () {
        this.$el.html(coursesListTemplate);
        $('#courses_table_container').html(coursesTableTemplate);
        this.loadCourses();
    },
    loadCourses: function () {
        var courseDurationRenderer = function (data, type, full, meta) {
            return data + ' - Days';
        };
        var coursesActionRenderer = function (data, type, full, meta) {
            return coursesActionButtonsTemplate({"course_id": data});
        };
        var coursesIsActiveRenderer = function (data, type, full, meta) {
            return data == GLOBAL_YES ? 'Yes' : 'No';
        };
        var coursesIsSellingRenderer = function (data, type, full, meta) {
            return data == GLOBAL_YES ? 'Yes' : 'No';
        };
        var courseFeesRenderer = function (data, type, full, meta) {
            return Math.round(data);
        };
        courcesDataTable = $('#courses_data_table').DataTable({
            ajax: {url: 'courses/get_all_courses', dataSrc: "", type: "post"},
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            pageLength: 25,
            columns: [
                {data: 'course_id'},
                {data: 'course_title'},
                {data: 'course_description'},
                {data: 'course_duration', 'render': courseDurationRenderer},
                {data: 'course_fees', className: "text-right", 'render': courseFeesRenderer},
                {data: 'course_is_active', 'render': coursesIsActiveRenderer},
                {data: 'course_is_selling', 'render': coursesIsSellingRenderer},
                {
                    "className": '',
                    "orderable": false,
                    "data": 'course_id',
                    "render": coursesActionRenderer
                }
            ],
            "columnDefs": [{
                        "searchable": false,
                        "orderable": false,
                        "targets": 0,
                        "defaultcontent": "-"
                        
                }],
            "order": [[1, 'asc']],
        });
       courcesDataTable.on('order.dt search.dt', function () {
            courcesDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
        $('#courses_data_table tbody').on('click', 'tr', function () {
            currentActiveRowForCourse = this;
        });
    },
    newCourses: function () {
        var parseData = {
            "YES": GLOBAL_YES,
            "NO": GLOBAL_NO
        };
        $('#courses_form_container').html(coursesFormTemlate({"courses_data": parseData}));
        $('#save_courses_btn').show();
    },
    saveCourses: function () {
        var coursesFormData = $('#add_edit_courses_from').serializeFormJSON();
        if ($('#courses_title').val() == '') {
            showError('Please Enter Course Title');
            $('#courses_title').focus();
            return false;
        }
        if (!$.isNumeric($('#courses_duration').val())) {
            $('#courses_duration').val("");
            $('#courses_duration').focus();
            showError("Enter Numeric Value Only In Duration");
            return false;
        }
        if ($('#courses_duration').val() == '' || $('#courses_duration').val() == 0) {
            showError('Please Enter Course Duration');
            $('#courses_duration').focus();
            return false;
        }
        if (!$.isNumeric($('#courses_fees').val())) {
            $('#courses_fees').val("");
            $('#courses_fees').focus();
            showError("Enter Numeric Value Only In Fees");
            return false;
        }
        if ($('#courses_fees').val() == '') {
            showError('Please Enter Fees');
            $('#courses_fees').focus();
            return false;
        }
        var url = coursesFormData.course_id == '' ? 'save' : 'update';
        $.ajax({
            type: 'POST',
            url: 'courses/' + url + '_courses',
            data: coursesFormData,
            success: function (data) {
                var parseData = JSON.parse(data);
                var courseData = parseData.course_data;
                if (parseData.success === false) {
                    showError(parseData.message);
                    return false;
                }
                if (courseData['course_is_active'] == GLOBAL_NO || courseData['course_is_selling'] == GLOBAL_NO) {
                    delete allCourseData[courseData.course_id];
                } else {
                    allCourseData[courseData.course_id] = courseData;
                }
                showSuccess(parseData.message);
                $('#courses_form_container').html('');
                courcesDataTable.ajax.reload();
            }
        });
    },
    editCourses: function (courseId) {
        $('#courses_title').focus();
        document.body.scrollTop = 2;
        $('#edit_courses_btn_' + courseId).hide();
        $('#spinner_edit_courses_btn_' + courseId).show();
        $.ajax({
            type: 'POST',
            url: 'courses/get_by_courses_id',
            data: {"course_id": courseId},
            success: function (response) {
                var parseData = JSON.parse(response);
                parseData.YES = GLOBAL_YES;
                parseData.NO = GLOBAL_NO;
                $('#edit_courses_btn_' + courseId).show();
                $('#spinner_edit_courses_btn_' + courseId).hide();
                $('#courses_form_container').html(coursesFormTemlate({"courses_data": parseData}));
                $("input[name=courses_is_active][value=" + parseData.course_is_active + "]").attr('checked', 'checked');
                $("input[name=courses_is_selling][value=" + parseData.course_is_selling + "]").attr('checked', 'checked');
                $('#update_courses_btn').show();
            }
        });
    },
    coursesDetail: function (courseId) {
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'courses/get_by_courses_id',
            data: {'course_id': courseId},
            success: function (data) {
                var courseData = JSON.parse(data);
                var courseTitle = courseData.course_title;
                that.$el.html(enrollmentCourse({'course_id': courseId, 'course_title': courseTitle}));
                $('#enrollment_course_table_container').html(viewEnrollmentStudent({'course_id': courseId}));
                $('.date_picker').datetimepicker({
                    'format': 'dd-mm-yyyy'
                });
                that.loadEnrollmentCourseData(courseId, '', '');
            }
        });
    },
    loadEnrollmentCourseData: function (courseId, fromDate, toDate) {
        var sturentMasterFullNameRenderer = function (data, type, full, meta) {
            return full.student_first_name + ' ' + full.student_middle_name + ' ' + full.student_last_name;
        };
        var showPaymentsRenderer = function (data, type, full, meta) {
            return showCoursePaymentsBtnTemplate({'course_id': data, 'enrollment_id': full.enrollment_id});
        };
        var studentCourseAmountRenderer = function (data, type, full, meta) {
            return full.paid_amount;

        };
        var totalAttended = 0;
        var totalNotAttended = 0;
        studentEnrollmentCourseDataTable = $('#student_enrollment_course_data_table').DataTable({
            ajax: {url: 'courses/get_enrollment_details', async: false, dataSrc: "", type: "post", data: {'course_id': courseId, 'from_date': fromDate, 'to_date': toDate}},
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            pageLength: 25,
            columns: [
                {data: 'null', 'render': showPaymentsRenderer, "width": "10px"},
                {data: 'studentName', 'render': sturentMasterFullNameRenderer},
                {data: 'student_mobile'},
                {data: 'enrollment_date'},
                {data: 'course_amount', 'render': studentCourseAmountRenderer, className: "text-right"}
            ],
            "createdRow": function (row, data, dataIndex) {
                if (data['has_remaining_attendance'] == 'yes') {
                    $(row).css("background-color", "#F4E2E2");
                    totalNotAttended++;
                } else {
                    totalAttended++;
                }
            }
        });
        //$('#total_number_of_case_for_loan_commission_report').html(studentEnrollmentCourseDataTable.page.info().recordsTotal);
        $('#total_enrollment').html(studentEnrollmentCourseDataTable.page.info().recordsTotal);
        $('#total_attendance').html(totalAttended);
        $('#remaining_attedance').html(totalNotAttended);
    },
    searchStudents: function (courseId) {
        //alert(courseId);
        var fromDate = $('#from_date').val();
        var toDate = $('#to_date').val();
        studentEnrollmentCourseDataTable.destroy();
        $('#search_enroll_student_btn').hide();
        $('#spinner_search_enroll_student_btn').show();
        this.loadEnrollmentCourseData(courseId, fromDate, toDate);
        $('#search_enroll_student_btn').show();
        $('#spinner_search_enroll_student_btn').hide();
    },
    studentPaymentDetails: function (obj) {
        var tr = obj.parents('tr');
        var row = studentEnrollmentCourseDataTable.row(tr);
        var that = this;
        var detailsIconLink = tr.find('.show-payment-details-control');
        if (row.child.isShown()) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
            detailsIconLink.removeClass('fa-minus').addClass('fa-plus');
        } else {
            // Open this row
            row.child(that.formatPayment(row.data())).show();
            tr.addClass('shown');
            detailsIconLink.removeClass('fa-plus').addClass('fa-minus');
        }

    },
    formatPayment: function (payment_details) {
        // `d` is the original data object for the row
        if (payment_details != undefined) {
            return childPaymentTableTemplate({'payments': payment_details.payment_details});
        }
        return "";
    },
    deleteCourse: function (CourseId) {
        getConfirm(function (result) {
            if (result === false) {
                return false;
            }
            $.ajax({
                type: 'post',
                url: 'courses/delete_course',
                data: {
                    "course_id": CourseId
                },
                success: function (data) {
                    var parseData = JSON.parse(data);
                    if (parseData.success == false) {
                        showError(parseData.message);
                        return false;
                    }
                    showSuccess(parseData.message);
                    courcesDataTable.row(currentActiveRowForCourse).remove().draw(false);
                }
            });
        });
    }
});