<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Call_log_model extends CI_Model {

    function get_call_log_by_student_id($student_id)
    {
        $this->db->select('cl.*,c.course_title');
        $this->db->join('course c','c.course_id = cl.course_id');
        $this->db->where('cl.student_id', $student_id);
        $this->db->from('call_log cl');
        $this->db->order_by('cl.call_date','ASC');
        return $this->db->get()->result_array();
    }

    function delete_call_log($call_log_id)
    {
        $this->db->where('call_log_id', $call_log_id);
        $this->db->delete('call_log');
    }

    function get_last_call_date($student_id)
    {
        $this->db->select('call_date,note,course.course_title');
        $this->db->from('call_log');
        $this->db->join('course','course.course_id=call_log.course_id');
        $this->db->where('student_id',$student_id);
        $this->db->order_by("call_date DESC,call_log_id DESC");        
        $this->db->limit('1');
        return $this->db->get()->row_array();
    }

    function save_call_log($call_log)
    {
         $this->db->insert_batch('call_log', $call_log);
    }

    

}
