<?php

function to_database_format($date_to_be_converted) {
    if ($date_to_be_converted == '') {
        return '0000-00-00';
    }
    return date(PHP_DATEFORMAT_MYSQL, strtotime($date_to_be_converted));
}

function to_DD_MM_YYYY($date_to_be_converted) {
    if ($date_to_be_converted == '') {
        return '00-00-0000';
    }
    return date(PHP_DATEFORMAT_DDhMMhYYYY, strtotime($date_to_be_converted));
}

function generate_array_for_id_object($result_set, $index_field) {
    $main_array = array();
    foreach ($result_set as $record) {
        $main_array[$record[$index_field]] = $record;
    }
    return $main_array;
}

function ordinal($i) {
    $l = substr($i, -1);
    $s = substr($i, -2, -1);
    return (($l == 1 && $s == 1) || ($l == 2 && $s == 1) || ($l == 3 && $s == 1) || $l > 3 || $l == 0 ? 'th' : ($l == 3 ? 'rd' : ($l == 2 ? 'nd' : 'st')));
}

function add_commas($input) {
    if (strlen($input) <= 2) {
        return $input;
    }
    $length = substr($input, 0, strlen($input) - 2);
    $formatted_input = add_commas($length) . "," . substr($input, -2);
    return $formatted_input;
}

function format_in_indian_style($num) {
    if ($num === 0) {
        return '0';
    }
    if ($num === '') {
        return '';
    }
    $pos = strpos((string) $num, ".");
    if ($pos === false) {
        $decimalpart = "00";
    } else {
        $decimalpart = substr($num . '00', $pos + 1, 2);
        $num = substr($num, 0, $pos);
    }

    if (strlen($num) > 3) {
        $last3digits = substr($num, -3);
        $numexceptlastdigits = substr($num, 0, -3);
        $formatted = add_commas($numexceptlastdigits);
        $stringtoreturn = $formatted . "," . $last3digits;
    } elseif (strlen($num) <= 3) {
        $stringtoreturn = $num;
    }

    if (substr($stringtoreturn, 0, 2) == "-,") {
        $stringtoreturn = "-" . substr($stringtoreturn, 2);
    }

    return $stringtoreturn;
}

function convert_number_to_words($number) {
    $no = floor($number);
    $point = round($number - $no, 2) * 100;
    $hundred = null;
    $digits_1 = strlen($no);
    $i = 0;
    $str = array();
    $words = array('0' => '', '1' => 'One', '2' => 'Two',
        '3' => 'Three', '4' => 'Four', '5' => 'Five', '6' => 'Six',
        '7' => 'Seven', '8' => 'Eight', '9' => 'Nine',
        '10' => 'Ten', '11' => 'Eleven', '12' => 'Twelve',
        '13' => 'Thirteen', '14' => 'Fourteen',
        '15' => 'Fifteen', '16' => 'Sixteen', '17' => 'Seventeen',
        '18' => 'Eighteen', '19' => 'Nineteen', '20' => 'Twenty',
        '30' => 'Thirty', '40' => 'Forty', '50' => 'Fifty',
        '60' => 'Sixty', '70' => 'Seventy',
        '80' => 'Eighty', '90' => 'Ninety');
    $digits = array('', 'Hundred', 'Thousand', 'Lakh', 'Crore');
    while ($i < $digits_1) {
        $divider = ($i == 2) ? 10 : 100;
        $number = floor($no % $divider);
        $no = floor($no / $divider);
        $i += ($divider == 10) ? 1 : 2;
        if ($number) {
            $plural = (($counter = count($str)) && $number > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            $str [] = ($number < 21) ? $words[$number] .
                    " " . $digits[$counter] . $plural . " " . $hundred :
                    $words[floor($number / 10) * 10]
                    . " " . $words[$number % 10] . " "
                    . $digits[$counter] . $plural . " " . $hundred;
        } else
            $str[] = null;
    }
    $str = array_reverse($str);
    $result = implode('', $str);
//  $points = ($point) ?
//     ".".$words[$point / 10] . " " . 
//          $words[$point = $point % 10] : '';
    $points = ($point) ? $words[$point / 10] . " " . $words[$point = $point % 10] . " Paise" : '';
    return $result . "Rupees  " . $points . " Only";
}
