<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_enrollment extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('student_enrollment_model');
        $this->load->model('student_master_model');
        $this->load->model('attendance_model');
        $this->load->model('courses_model');
        $this->load->model('payment_model');
        $this->load->model('config_model');
        $this->load->model('interest_model');
        check_authenticated();
    }

    function get_all_courses() {
        $courses = $this->courses_model->is_course_exist();
        echo json_encode($courses);
    }

    function get_course_amount() {
        $course_id = $this->input->post('course_id');
        $courses = $this->courses_model->get_by_courses_id($course_id);
        echo json_encode($courses);
    }

    function save_enrollment() {
        $student_enrollment = $this->_get_student_enrollment_from_post();
        $enrollment_id = $this->student_enrollment_model->save_enrollment($student_enrollment);
        $student_enrollment_payment = $this->_get_student_enrollment_payment_from_post($enrollment_id);
        if ($student_enrollment_payment['payment_amount'] != 0) {
            $payment_id = $this->payment_model->create($student_enrollment_payment);
        }
        $enrollment_course_data = $this->input->post('enrollment_course_data');
        $enroll_interest_course_id = $this->input->post('enroll_interest_course_id');
        $enroll_interest_status = $this->input->post('enroll_interest_status');
        $student_enrollment_course = $this->_save_student_enrollment_course($enrollment_id, $enrollment_course_data, $student_enrollment['student_id'],$enroll_interest_course_id,$enroll_interest_status);
        echo json_encode(array('success' => TRUE, 'message' => 'Student Enrollment Saved Successflly'));
    }

    function _save_student_enrollment_course($enrollment_id, $enrollment_course_data, $student_id,$enroll_interest_course_id,$enroll_interest_status,$update=0) {
        foreach ($enrollment_course_data as $course_data) {
            $course_details = array(
                'enrollment_id' => $enrollment_id,
                'course_id' => $course_data['enrollment_course_name'],
                'enrollment_course_name' => $this->_get_course_name($course_data['enrollment_course_name']),
                'enrollment_course_amount' => $course_data['enrollment_course_amount']
            );
            //$this->interest_model->delete_student_interest_enrolled_data($this->input->post('student_enrollment_id'), $course_data['enrollment_course_name']);
            $enrollment_course_id = $this->student_enrollment_model->save_enrollment_course($course_details);

            if($enroll_interest_course_id == $course_details['course_id'] && $enroll_interest_status == 1)
            {
                $intrest['status'] = 1;
            }
            else
            {
                $intrest['status'] = 0;
            }

            $intrest['course_id'] = $course_details['course_id'];
            $intrest['student_id'] = $student_id;
            $intrest['enrollment_course_id'] = $enrollment_course_id; 

            $this->interest_model->confirm_student_to_course($intrest,$update);
        }
    }
    
    function validate_enrollment() {

        $student_enrollment = $this->_get_student_enrollment_from_post();
        $enrollment_course_data = $this->input->post('enrollment_course_data');
        $enrollment_id = $this->input->post('enrollment_id');

        $found = 0;
        $repeated = array();

        foreach ($enrollment_course_data as $value) {

            $student_id = $student_enrollment['student_id'];
            $course_id = $value['enrollment_course_name'];
            $result = $this->student_enrollment_model->chceck_enrollment_course($student_id,$course_id,$enrollment_id);

            if(!empty($result))
            {
                $found = 1;
                $repeated[] = $result['enrollment_course_name'];
            }            
        }

        $repeated_course = implode(',', $repeated);        
        if($found == 1)
        {
            $message = 'This Student Already Enrolled in '.$repeated_course.' Enroll Again?';
            echo json_encode(array('success' => 0, 'message' => $message));
        }
        else
        {
            echo json_encode(array('success' => 1));
        }
        
    }

    function _get_course_name($course_id) {
        $course_name = $this->courses_model->get_by_courses_id($course_id);
        return $course_name['course_title'];
    }

    function get_discount() {
        $no_of_course = $this->input->post('no_of_course');
        $discount = $this->student_enrollment_model->get_discount($no_of_course);
        echo json_encode($discount);
    }

    function get_discount_by_yearly_membership() {
        $discount = $this->config_model->get_config_value('YEARLY_MEMBER');
        echo json_encode($discount);
    }

    function _get_date_from_post($param_name){
        $param_value = $this->input->post($param_name);
        return $param_value != '' ? to_database_format($param_value) : '';
    }
    
    function get_enrollment_details() {
        $student_id = $this->input->post('student_id');
        $from_date = $this->_get_date_from_post('from_date');
        $to_date = $this->_get_date_from_post('to_date');
        $validity_date = $this->_get_date_from_post('validity_date');        

        $course_data = array();
        $enrollment_details = $this->student_enrollment_model->get_enrollment_details($student_id, $from_date, $to_date, $validity_date);
        foreach ($enrollment_details as $enrollment_data) {
            if ($enrollment_data['payment_amount'] == '') {
                $enrollment_data['payment_amount'] = 0;
            }
            $enrollment_id = $enrollment_data['enrollment_id'];
            $enrollment_data['course_name'] = $this->student_enrollment_model->get_enrollment_course_details($enrollment_id);            
            $enrollment_data['payment_details'] = $this->payment_model->get_payments($enrollment_id, $student_id);

            if(!empty($enrollment_data['course_name']))
            {
                foreach ($enrollment_data['course_name'] as $key => &$value) {

                    $result = $this->student_enrollment_model->get_attendance($enrollment_id,$value['course_id'],$student_id);
                    if(!empty($result))
                    {
                        $value['attend_day'] = date_format(date_create($result['attendance_date']),'d-m-Y');
                    }
                    else
                    {
                        $value['attend_day'] = '-';
                    }

                }
            }

            array_push($course_data, $enrollment_data);
        }
        
        echo json_encode($course_data);
    }

    function get_by_enrollment_id() {
        $enrollment_id = $this->input->post('enrollment_id');
        $student_id = $this->input->post('student_id');
        $data['enrollment_detail'] = $this->student_enrollment_model->get_enrollment_detail_by_id($enrollment_id);
        $data['enrollment_course_detail'] = $this->student_enrollment_model->enrollment_course_detail_by_id($enrollment_id);
        $student_data = $this->student_master_model->get_by_student_id($student_id);
        $data['student_name'] = $student_data;
        echo json_encode($data);
    }

    function update_enrollment() {
        $enrollment_id = $this->input->post('enrollment_id');
        $student_enrollment = $this->_get_student_enrollment_from_post();
        $this->student_enrollment_model->update_enrollment($student_enrollment, $enrollment_id);
        $enrollment_course_data = $this->input->post('enrollment_course_data');        
        $enroll_interest_course_id = $this->input->post('enroll_interest_course_id');
        $enroll_interest_status = $this->input->post('enroll_interest_status');        
        $course_detail = $this->student_enrollment_model->get_enrollment_course_details($enrollment_id);
        if(!empty($course_detail))        {
            foreach ($course_detail as $key => $value) {
                $this->student_enrollment_model->delete_enrolled_intrest($value['course_id'],$student_enrollment['student_id'],$value['enrollment_course_id']);
            }
        }
        $this->student_enrollment_model->delete_old_enrollment_course($enrollment_id);
        $student_enrollment_course = $this->_save_student_enrollment_course($enrollment_id, $enrollment_course_data,$student_enrollment['student_id'],$enroll_interest_course_id,$enroll_interest_status,$update=1);
        echo json_encode(array('success' => TRUE, 'message' => 'Student Enrollment Updated Successflly'));
    }

    function get_student_name() {
        $student_id = $this->input->post('student_id');
        $student_data = $this->student_master_model->get_by_student_id($student_id);

        $course_id = $this->input->post('course_id');
        if($course_id != 0)
        {            
            $course_detail = $this->courses_model->get_by_courses_id($course_id);
            $student_data['course_detail']=$course_detail;
        }
        echo json_encode($student_data);
    }

    function get_enrollment_validity() {
        $package_validity_no = $this->input->post('enrollment_validity');
        $enrollment_validity_data = $this->student_enrollment_model->get_enrollment_validity($package_validity_no);
        echo json_encode($enrollment_validity_data);
    }

    function get_enrollment_course_for_yearly_membership() {
        $enrollment_course_data = $this->input->post('course_data');
        $course_detail = explode(',', $enrollment_course_data);
        $enrollment_data = array();
        foreach ($course_detail as $course_id) {
            $enrollment_course_details = $this->courses_model->get_by_courses_id($course_id);
            array_push($enrollment_data, $enrollment_course_details);
        }
        echo json_encode($enrollment_data);
    }

    function _get_student_enrollment_from_post() {
        $student_enrollment_date = new DateTime($this->input->post('student_enrollment_date'));
        $new_student_enrollment_date = $student_enrollment_date->format('Y-m-d');
        $student_enrollment_validity = new DateTime($this->input->post('student_enrollment_validity'));
        $new_student_enrollment_validity = $student_enrollment_validity->format('Y-m-d');
        $package_details = $this->input->post('Package_details');
        if ($package_details == '') {
            $package_details = json_encode([]);
        } else {
            $package_details = json_encode($package_details);
        }
        $enrollment_details = array(
            'enrollment_created_date' => $new_student_enrollment_date,
            'enrollment_validity_date' => $new_student_enrollment_validity,
            'enrollment_yearly_membership' => $this->input->post('yearly_membership_is_active'),
            'sub_total' => $this->input->post('sub_total'),
            'discount' => $this->input->post('payment_discount'),
            'due_amounts' => $this->input->post('due_amount'),
            'student_id' => $this->input->post('student_enrollment_id'),
            'additional_discount_percentage' => $this->input->post('additional_discount_percentage'),
            'additional_discount_amount' => $this->input->post('additional_discount_amount'),
            'total_discount' => $this->input->post('total_discount'),
            'payable_amount' => $this->input->post('payable_amount'),
            'is_package_applied' => $this->input->post('is_package_applied'),
            'package_details' => $package_details,
            'no_of_courses' => $this->input->post('no_of_courses'),
            'average_amount' => $this->input->post('average_amount'),
            'enrollment_discount_note' => $this->input->post('enrollment_discount_note')
        );
        return $enrollment_details;
    }

    function _get_student_enrollment_payment_from_post($enrollment_id) {
        $advance_payment_date = new DateTime($this->input->post('advance_payment_date'));
        $new_advance_payment_date = $advance_payment_date->format('Y-m-d');
        $payment_details = array(
            'enrollment_id' => $enrollment_id,
            'student_id' => $this->input->post('student_enrollment_id'),
            'payment_amount' => $this->input->post('total_advance'),
            'payment_date' => $new_advance_payment_date,
            'payment_mode' => $this->input->post('enrollment_payment_mode'),
            'payment_reference_number' => $this->input->post('enrollment_reference_number'),
            'payment_remarks' => $this->input->post('enrollment_payment_remark'),
        );
        return $payment_details;
    }

    function delete_enrollment() {
        $enrollment_id = $this->input->post('enrollment_id');
        //$enrollment_id = 4;

        $enrollment_data = $this->student_enrollment_model->enrollment_data($enrollment_id);

        $payment_exist = $this->student_enrollment_model->check_enrollment_payment_exist($enrollment_id);
        if (!empty($payment_exist)) {
            echo json_encode(array('success' => FALSE, 'message' => 'Payment Already Exist For This Enrollment'));
            return;
        }
        $result = $this->student_enrollment_model->delete_enrollment_course($enrollment_id);
        if ($this->db->affected_rows($result) > 0) {
            $data = array('is_delete' => ISDELETENO, 'enrollment_updated_date' => date('Y-m-d h:i:s'), 'enrollment_updated_by' => get_from_session('ccm_user_id'));
            $this->student_enrollment_model->delete_enrollment($enrollment_id, $data);
            foreach ($enrollment_data as $key => $value) {
                $this->student_enrollment_model->update_interest($value['course_id'],$value['student_id'],$value['enrollment_course_id']);
            }
            echo json_encode(array('success' => TRUE, 'message' => 'Delete Enrollment Successfully'));
        }
    }

    function calculate_revenue_script() {
        $enrollment_details = $this->student_enrollment_model->get_all_enrollment_details();
        foreach ($enrollment_details as $enrollment_data) {
            $revenue = $this->student_enrollment_model->calculate_student_course_revenue($enrollment_data['enrollment_id']);
            $enrollment_data_array = array();
            $enrollment_data_array['no_of_courses'] = $revenue['no_of_courses'];
            $enrollment_data_array['average_amount'] = round($revenue['average_amount'], 2);
            $this->student_enrollment_model->update_enrollment($enrollment_data_array, $enrollment_data['enrollment_id']);
        }
        echo 'Success';
    }

    function view_attendance() {
        $enrollment_id = $this->input->post('enrollment_id');
        $course_id = $this->input->post('course_id');
        $attendance_data = $this->attendance_model->get_attendance_details_by_id($enrollment_id, $course_id);
        echo json_encode($attendance_data);
    }

    function quick_enroll_student_to_course() {
     
        $config = $this->config_model->get_all_data();      

        foreach ($config as $key => $value) {

            if($value['config_key'] == PACKAGE_VALIDITY_DURATION)
            {
                $val = $value['config_value'];                                
                $val = json_decode($val);                
                $validity_no = $val[0]->package_validity_no;
                $validity_duration = $val[0]->package_validity_duration;               
            }            
        }

        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $attendance = $this->input->post('attendance');   
        $status = $this->input->post('status');

        $this->load->model('courses_model');
        $course_detail = $this->courses_model->get_by_courses_id($course_id);

        $student_enrollment_date = new DateTime(date('Y-m-d'));
        $new_student_enrollment_date = $student_enrollment_date->format('Y-m-d');

        $validityDate = date('Y-m-d', strtotime("+".$validity_no." ".$validity_duration."", strtotime(date('Y-m-d'))));

        $student_enrollment_validity = new DateTime($validityDate);
        $new_student_enrollment_validity = $student_enrollment_validity->format('Y-m-d');
        
        $package_details = json_encode([]);
       
        $enrollment_details = array(
            'enrollment_created_date' => $new_student_enrollment_date,
            'enrollment_validity_date' => $new_student_enrollment_validity,
            'enrollment_yearly_membership' => 2,
            'sub_total' => $course_detail['course_fees'],
            'discount' => '',
            'due_amounts' => '',
            'student_id' => $student_id,
            'additional_discount_percentage' => '',
            'additional_discount_amount' => '',
            'total_discount' => '',
            'payable_amount' => $course_detail['course_fees'],
            'is_package_applied' => 0,
            'package_details' => $package_details,
            'no_of_courses' => 1,
            'average_amount' => $course_detail['course_fees'],
            'enrollment_discount_note' => ''
        );

        $this->load->model('student_enrollment_model');
        $enrollment_id = $this->student_enrollment_model->save_enrollment($enrollment_details);

        $course_details = array(
            'enrollment_id' => $enrollment_id,
            'course_id' => $course_detail['course_id'],
            'enrollment_course_name' => $course_detail['course_title'],
            'enrollment_course_amount' => $course_detail['course_fees']
        );

        $enrollment_course_id = $this->student_enrollment_model->save_enrollment_course($course_details);
        //$this->interest_model->delete_student_interest_enrolled_data($student_id, $course_id);

        $intrest['course_id'] = $course_id;
        $intrest['student_id'] = $student_id;
        $intrest['enrollment_course_id'] = $enrollment_course_id;

        // if($status == 1 || $status == 2)
        // {
        //     $intrest['status'] = 1;
        // }
        // else
        // {
        //     $intrest['status'] = 0;
        // }

        $intrest['status'] = $status;     

        $this->interest_model->confirm_student_to_course($intrest,0);        

        $advance_payment_date = new DateTime(date('Y-m-d'));
        $new_advance_payment_date = $advance_payment_date->format('Y-m-d');
        $payment_details = array(
            'enrollment_id' => $enrollment_id,
            'student_id' => $student_id,
            'payment_amount' => $course_detail['course_fees'],
            'payment_date' => $new_advance_payment_date,
            'payment_mode' => 'Cash',
            'payment_reference_number' => '',
            'payment_remarks' => '',
        );

        if ($payment_details['payment_amount'] != 0) {
            $payment_id = $this->payment_model->create($payment_details);
        }       
        
        echo json_encode(array('success' => true, 'message' => 'Student Enrolled','enrollment_id'=>$enrollment_id,'enrollment_validity_date'=>$new_student_enrollment_validity));
    }

}

/**
 * EOF: ./application/controllers/student_master.php
 */