<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Login extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('login_model');
    }

    function index($msg = '') {
        if (is_authenticated()) {
            header("Location:" . base_url() . "main");
        }
        $data['message'] = $msg;
        $this->load->view('login', $data);
    }

    function check() {
        is_post();

        $username = trim($this->input->post('username'));
        $password = trim($this->input->post('password'));

        if ($username == '') {
            $this->index('Username cannot be empty.');
            return;
        }
        if ($password == '') {
            $this->index('Password cannot be empty.');
            return;
        }
        $this->load->model('login_model');
        $user = $this->login_model->get_by_username($username);
        if (!$user) {
            $this->index('Invalid Username');
            return;
        }
        if (md5($password) != $user['password']) {
            $this->index('Invalid Password');
            return;
        }
        $user['ccm_user_id'] = $user['user_id'];
        unset($user['user_id']);
        unset($user['password']);
        $this->session->set_userdata($user);
        $data['ip_address'] = $_SERVER["REMOTE_ADDR"];
        $data['subject'] = "Login Notification";
        send_login_email($data, TO_EMAIL);
        header("Location:" . base_url() . "main");
    }

    function change_password($msg = '') {
        check_authenticated();
        $data['message'] = $msg;
        $this->load->view('change_password', $data);
    }

    function check_change_password() {
        check_authenticated();
        is_post();

        if (!$this->_validate_change_password()) {
            return;
        }

        $current_password = trim($this->input->post('current_password'));
        $new_password = trim($this->input->post('new_password'));

        $user = $this->login_model->get_by_username(get_from_session('username'));
        if (md5($current_password) != $user['password']) {
            $this->change_password('Current Password is invalid.');
            return;
        }
        $user_id = get_from_session('ccm_user_id');
        $new_password_md5 = md5($new_password);
        $this->login_model->update_password($user_id, $new_password_md5);
        $this->change_password("Password updated successfully");
        $this->session->sess_destroy();
        header("Location:" . base_url() . "login");
    }

    function _validate_change_password() {
        $current_password = trim($this->input->post('current_password'));
        $new_password = trim($this->input->post('new_password'));
        if ($current_password == '') {
            $this->change_password('Current Password cannot be empty.');
            return false;
        }
        if ($new_password == '') {
            $this->change_password('New Password cannot be empty.');
            return false;
        }
		$confirm_new_password = trim($this->input->post('confirm_new_password'));
        if ($confirm_new_password == '') {
            $this->change_password('Confirm New Password cannot be empty.');
            return false;
        }
        if ($new_password != $confirm_new_password) {
            $this->change_password('New Password and Confirm New Password does not match.');
            return false;
        }
        return true;
    }

    function logout($msg = '') {
        $this->session->sess_destroy();
        header("Location:" . base_url() . "login");
    }

}

/*
 * EOF: ./application/controllers/Login.php
 */
