<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Interest extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('interest_model');
        $this->load->model('student_master_model');
        $this->load->model('Student_enrollment_model');
        $this->load->model('attendance_model');
    }

    function get_student_interest_data() {
        $student_id = $this->input->post('student_id');
        $data['student_data'] = $this->student_master_model->get_by_student_id($student_id);
        $data['student_interest_course_data'] = $this->interest_model->get_student_interest_data_by_student_id($student_id);
        echo json_encode($data);
    }

    function save_student_interest() {
        $student_id = $this->input->post('student_id');
        $this->interest_model->delete_student_interest_old_data($student_id);
        $student_interest_course_data = $this->_get_from_post_student_interest_data();

        if (empty($student_interest_course_data)) {
            echo json_encode(array('success' => TRUE, 'message' => 'Student Interest Saved Successflly'));
            return;
        }        

        foreach ($student_interest_course_data as $value) {
            $this->interest_model->insert_interest_student_course($value);
        }

        //$this->interest_model->insert_student_interest_course($student_interest_course_data);
        echo json_encode(array('success' => TRUE, 'message' => 'Student Interest Saved Successflly','data'=>$student_interest_course_data));
    }

    function _get_from_post_student_interest_data() {
        $interest_course_data = $this->input->post('interest_course_data');
        if (empty($interest_course_data)) {
            return;
        }
        foreach ($interest_course_data as &$course_data) {
            $course_data['created_date'] = date('Y-m-d h:i:s');
        }
        return $interest_course_data;
    }

    function get_student_interested_data() {
        $course_id = $this->input->post('course_id');
        $status = $this->input->post('status');       

        $result = array();

        if($status == 2)
        {
            $res = $this->Student_enrollment_model->get_enrolled_student($course_id);
            $result = array();            
            foreach ($res as $row) {
                $select = $this->interest_model->check_intrest($course_id,$row['student_id']);                
                if(empty($select))
                {
                    $result[]=$row;
                }
                else
                {  
                   if($select['status'] == 0)
                   {
                        $result[]=$row;
                   }
                }
            }
        }
        else
        {
            $result = $this->interest_model->get_student_interested_data_by_course_id($course_id,$status);
        }       
        echo json_encode($result);
    }

    function get_detail_for_confirm() {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');        
        $result = $this->interest_model->get_detail_for_confirm($student_id,$course_id);
        echo json_encode($result);
    }

    function confirm_student_to_course() {


        $data['student_id'] = $this->input->post('student_id');
        $data['course_id'] = $this->input->post('course_id');
        $data['checkbox'] = $this->input->post('checkbox');
        $data['food_type'] = $this->input->post('food_type');
        $data['enrollment_course_id'] = $this->input->post('enrollment_course_id');
        $data['languageData'] =json_encode($this->input->post('languageData'));

        if($data['checkbox'] == 0)
        {
            $data['languageData'] = '';
        }
        $this->student_master_model->update_language($data['student_id'],$data['languageData']);

        $res['student_id'] = $data['student_id'];
        $res['course_id'] = $data['course_id'];
        $res['food_type'] = $data['food_type'];
        $res['enrollment_course_id'] = $data['enrollment_course_id'];
        $res['status'] = CONFIRM;
        $this->interest_model->confirm_student_to_course($res,0);
        echo json_encode(array('success' => true, 'message' => 'Student Confirmed'));
    }

    function reset_to_waiting() {

        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $this->interest_model->reset_student_to_waiting($student_id,$course_id);
        echo json_encode(array('success' => true, 'message' => 'Student is moved to Waiting List'));
    }

    function reset_confirm_list() {

        $course_id = $this->input->post('course_id');
        $this->interest_model->reset_confirm_list($course_id);
        echo json_encode(array('success' => true, 'message' => 'Reset Successfully'));
    }

    function remove_student_from_course() {

        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $res = $this->interest_model->remove_student_from_course($student_id,$course_id);
        if($res==true)
        {
            echo json_encode(array('success' => true, 'message' => 'Student Removed'));
        }
        else
        {
            echo json_encode(array('success' => false, 'message' => 'Enrollment exist'));
        }
        
    }    
    
    function set_interest_to_next_class()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $this->interest_model->set_interest_to_next_class($student_id,$course_id);
        echo json_encode(array('success' => true, 'message' => 'Added To Next'));
    }
    function remove_interest_from_next_class()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $this->interest_model->remove_interest_from_next_class($student_id,$course_id);
        echo json_encode(array('success' => true, 'message' => 'Removed From Next'));
    }



}

/*
 * EOF: ./application/controllers/Login.php
 */
