<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_master_model extends CI_Model {

    function create($student) {
        $student['student_created_date'] = date('Y-m-d h:i:s');
        $this->db->insert('student_master', $student);
        return $this->db->insert_id();
    }

    /**
     * get student info by student data
     * @param type $student
     * @return type
     */
    function get_student_info($student) {
        $this->db->where('student_mobile', $student['student_mobile']);
        if ($student['student_id'] != '') {
            $this->db->where('student_id !=' . $student['student_id']);
        }
        $this->db->where('is_delete !=' . ISDELETENO);
        $recs = $this->db->get('student_master');
        return $recs->result_array();
    }

    // function get_all_student($search_data,$continue=0) {
    //     $this->db->select('student_master.*, count(e.enrollment_id) AS total_enrollment, sum(e.due_amounts) AS due_amounts');    

    //     if ($search_data['address'] != '') {
    //         $this->db->like('student_address', $search_data['address']);
    //     }
    //     if ($search_data['reference'] != '') {
    //         $this->db->where('student_reference', $search_data['reference']);
    //     }
    //     if ($search_data['gender'] != '') {
    //         $this->db->where('student_gender', $search_data['gender']);
    //     }
    //     if ($search_data['group_tag'] != '') {
    //         $this->db->like('student_group_tag', $search_data['group_tag']);
    //     }
    //     $this->db->where('student_master.is_delete', ISDELETEYES);
    //     if($continue == 1)
    //     {
    //         $this->db->where('student_master.discontinue', 0);
    //     }
    //     $this->db->join('enrollment as e', 'student_master.student_id=e.student_id AND e.is_delete='.ISDELETEYES.'', 'left');
    //     $this->db->group_by('student_master.student_id');
    //     $this->db->order_by('student_id', 'desc');
    //     $resc = $this->db->get('student_master');
    //     return $resc->result_array();
    // }


    // function get_all_student() {
    //     $this->db->select('student_master.*, count(e.enrollment_id) AS total_enrollment, sum(e.due_amounts) AS due_amounts');        
    //     $this->db->join('enrollment as e', 'student_master.student_id=e.student_id AND e.is_delete='.ISDELETEYES.'', 'left');
    //     $this->db->group_by('student_master.student_id');
    //     $this->db->order_by('student_id', 'desc');
    //     $resc = $this->db->get('student_master');
    //     return $resc->result_array();
    // }


    // function get_all_student() {

    //     $this->db->select('s.student_id,s.student_first_name,s.student_middle_name,s.student_last_name,s.student_gender,s.student_mobile,s.student_interestedin_email,s.student_interestedin_message,s.student_registration_date,s.discontinue,s.student_photo, count(e.enrollment_id) AS total_enrollment, sum(e.due_amounts) AS due_amounts');        
    //     $this->db->from('student_master s');        
    //     $this->db->join('enrollment e', 'e.student_id=s.student_id AND e.is_delete='.ISDELETEYES.'', 'left');
    //     $this->db->group_by('s.student_id');
    //     $this->db->order_by('s.student_id', 'desc');
    //     $resc = $this->db->get();
    //     return $resc->result_array();
    // }

    function get_all_student($search_data,$continue=0) {
         $this->db->select('s.student_id,s.student_first_name,s.student_middle_name,s.student_last_name,s.student_gender,s.student_mobile,s.student_interestedin_email,s.student_interestedin_message,s.student_registration_date,s.discontinue,s.student_photo, count(e.enrollment_id) AS total_enrollment, sum(e.due_amounts) AS due_amounts');    
        $this->db->from('student_master s');
        if ($search_data['address'] != '') {
            $this->db->like('s.student_address', $search_data['address']);
        }
        if ($search_data['reference'] != '') {
            $this->db->where('s.student_reference', $search_data['reference']);
        }
        if ($search_data['gender'] != '') {
            $this->db->where('s.student_gender', $search_data['gender']);
        }
        if ($search_data['group_tag'] != '') {
            $this->db->like('s.student_group_tag', $search_data['group_tag']);
        }
        $this->db->where('s.is_delete', ISDELETEYES);
        if($continue == 1)
        {
            $this->db->where('s.discontinue', 0);
        }
        $this->db->join('enrollment as e', 's.student_id=e.student_id AND e.is_delete='.ISDELETEYES.'', 'left');
        $this->db->group_by('s.student_id');
        $this->db->order_by('s.student_id', 'desc');
        $resc = $this->db->get();
        return $resc->result_array();
    }

    function get_by_student_id($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->from('student_master');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function update_student($student_id, $student) {
        $student['student_updated_date'] = date('Y-m-d h:i:s');
        $this->db->where('student_id', $student_id);
        $this->db->update('student_master', $student);
    }

    function update_image($student_id, $image_name) {
        $this->db->where('student_id', $student_id);
        $this->db->set('student_photo', $image_name);
        $this->db->update('student_master');
    }

    function delete_image($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->set('student_photo', '');
        $this->db->update('student_master');
    }

    function get_by_student_id_for_email_and_sms($student_id,$schedule_id) {
        $this->db->select('sm.*,ec.enrollment_course_name,s.schedule_date,s.schedule_from_time,s.schedule_to_time');
        $this->db->from('student_master as sm');
        $this->db->join('enrollment as e', 'sm.student_id=e.student_id');
        $this->db->join('enrollment_course as ec', 'e.enrollment_id=ec.enrollment_id');
        $this->db->join('schedule as s', 'ec.course_id=s.schedule_course_id');
        $this->db->where('s.schedule_id', $schedule_id);
        $this->db->where('sm.student_id', $student_id);
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function discontinue_student_from_attendance($student_id, $student_data) {
        $this->db->where('student_id', $student_id);
        $this->db->update('student_master', $student_data);
    }

    function delete_student($studentId, $student_data) {
        $this->db->where('student_id', $studentId);
        $this->db->update('student_master', $student_data);
    }

    function get_student_distinct_group_tags(){
        $this->db->select('DISTINCT(student_group_tag)');
        $this->db->where("student_group_tag != ''");
        $resc = $this->db->get('student_master');
        return $resc->result_array();
    }

    function update_language($student_id,$languageData)
    {
        $this->db->where('student_id', $student_id);
        $this->db->set('lang_preference', $languageData);
        $this->db->update('student_master');
    }

    function checkArea($area)
    {
        $this->db->select('*');
        $this->db->from('area');
        $this->db->where('area_name',$area);
        $res = $this->db->get();
        return $res->result_array();        
    }
    function addArea($area)
    {        
        $area_array['area_name'] = $area;        
        $this->db->insert('area', $area_array);
    }
    function get_area()
    {
        $this->db->select('id,area_name');
        $this->db->from('area');
        return $this->db->get()->result_array();
    }
    function get_ref_counter($value,$course_id)
    {
        $this->db->select('count(s.student_reference) as total_count');
        $this->db->from('student_master s');               
        if($course_id != '')
        {
            $this->db->join('enrollment e','e.student_id=s.student_id');
            $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id'); 
            $this->db->where('ec.course_id',$course_id);
        }
        $this->db->where('s.student_reference',$value);
        $res = $this->db->get();
        return $res->row_array();
    }
    function get_student_for_message_mail($sending_type) {
        $this->db->select('GROUP_CONCAT(student_id) as student_id');
        $this->db->from('student_master');
        $this->db->where('discontinue',0);
        $this->db->where('is_delete',0);
        if($sending_type == 'email')
        {
            $this->db->where('student_email !=', '');
            //$this->db->where('student_interestedin_email',1);
        }
        else
        {
            $this->db->where('student_mobile !=', '');
            //$this->db->where('student_interestedin_message',1);
        }
        return $this->db->get()->row_array();

    } 
}

/**
 * EOF: ./application/models/Courses_model.php
 */
