<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Call_log extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('call_log_model');
        $this->load->model('interest_model');
        $this->load->model('student_master_model');        
    }
    function get_call_log_by_student_id()
    {
        $student_id = $this->input->post('student_id');
        $call_log = $this->call_log_model->get_call_log_by_student_id($student_id);
        $c=1;
        $call_logs = array();
        foreach ($call_log as $row) {
            $log = $row;
            $log['sr_no'] = $c;
            $date = new DateTime($log['call_date']);
            $log['call_date']= $date->format('d-m-Y');

            if($log['reminder_date'] != '0000-00-00')
            {
                $date1 = new DateTime($log['reminder_date']);
                $log['reminder_date']= $date1->format('d-m-Y');
            }
            else
            {
                $log['reminder_date']= '';
            }

            if($log['course_title'] == '')            
            {
                $log['course_title'] = 'N/A';
            }

            $call_logs[] = $log;
            $c++;
        }
        echo json_encode($call_logs);
    }
    function delete_call_log()
    {
        $call_log_id = $this->input->post('call_log_id');
        $student_id = $this->input->post('student_id');
        
        $this->call_log_model->delete_call_log($call_log_id);
        $last_call_date = $this->call_log_model->get_last_call_date($student_id);
        $total_reminder = $this->call_log_model->get_total_reminder()['total_reminder'];
        if(empty($last_call_date))
        {
            $last_call_date['call_date'] = '';
        }
        else
        {
            $last_call_date['call_date'] = date_format(date_create($last_call_date['call_date']),'d-m-Y');
            $last_call_date['call_date'] = '<span class="red_color"> '.$last_call_date['call_date'] .'</span><br>'.$last_call_date['note'].'<br> <span class="red_color"> '.$last_call_date['course_title'].'</span>';
        }
        echo json_encode(array('success' => true, 'message' => 'Call Log Deleted','last_call_date' => $last_call_date['call_date'],'total_reminder'=>$total_reminder));
    }
    function add_call_log()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');

        $call_log_date = $this->input->post('call_log_date');
        $call_log_note = $this->input->post('call_log_note');
        $call_log_reminder_date = $this->input->post('call_log_reminder_date');
        $call_log_course = $this->input->post('call_log_course');

        foreach ($call_log_date as $key => $row) {

            $date = new DateTime($row);
            $call_date = $date->format('Y-m-d');
            $reminder_date = '';
            if($call_log_reminder_date[$key] != '')
            {
                $reminder_date = new DateTime($call_log_reminder_date[$key]);
                $reminder_date = $reminder_date->format('Y-m-d');
            }

            $call_log[] = array(
                                'student_id' => $student_id,
                                'course_id' => $call_log_course[$key],
                                'call_date' => $call_date,
                                'note' => $call_log_note[$key],
                                'reminder_date' => $reminder_date
                            );
           
        }

        $this->call_log_model->save_call_log($call_log);

        $last_call_date = $this->call_log_model->get_last_call_date($student_id);

        $total_reminder = $this->call_log_model->get_total_reminder()['total_reminder'];

        if(empty($last_call_date))
        {
            $last_call_date['call_date'] = '';
        }
        else
        {
            $last_call_date['call_date'] = date_format(date_create($last_call_date['call_date']),'d-m-Y');
            $last_call_date['call_date'] = '<span class="red_color"> '.$last_call_date['call_date'] .'</span><br>'.$last_call_date['note'].'<br> <span class="red_color"> '.$last_call_date['course_title'].'</span>';
        }

        echo json_encode(array('success' => true, 'message' => 'Call Log Added','last_call_date' => $last_call_date['call_date'],'total_reminder'=>$total_reminder));
    }
    function get_call_status()
    {
        $course_id = $this->input->post('course_id');
        $schedule_date = date_format(date_create($this->input->post('attendance_date')),'Y-m-d');
        $list_type = $this->input->post('status');

        $call_status = $this->call_log_model->get_call_status($course_id,$schedule_date,$list_type);

        if(empty($call_status))
        {
            echo json_encode(array('success' => false, 'call_status' => $call_status));
        }
        else
        {
            echo json_encode(array('success' => true, 'call_status' => $call_status));
        }
    }
    function reset_call_status()
    {
        $id = $this->input->post('id');
        $this->call_log_model->delete_call_status($id);
        echo json_encode(array('success' => true, 'message' => 'Call Status Reset'));
    }
    function add_call_status()
    {
        $course_id = $this->input->post('course_id');
        $schedule_date = date_format(date_create($this->input->post('attendance_date')),'Y-m-d');
        $list_type = $this->input->post('status');

        $add = array('schedule_date'=>$schedule_date,'course_id'=>$course_id,'list_type'=>$list_type,'done_date'=>date('Y-m-d'));
        $id = $this->call_log_model->add_call_status($add);
        $add['id'] = $id;
        $add['done_date'] = date_format(date_create($add['done_date']),'d-m-Y');;
        echo json_encode(array('success' => true, 'message' => 'Call Status Reset','data' =>$add));

    }
}

/*
 * EOF: ./application/controllers/Login.php
 */
