-- Adminer 4.2.2 MySQL dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(11) NOT NULL AUTO_INCREMENT,
  `config_key` text NOT NULL,
  `config_value` text NOT NULL,
  PRIMARY KEY (`config_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `course`;
CREATE TABLE `course` (
  `course_id` int(11) NOT NULL AUTO_INCREMENT,
  `course_title` varchar(100) NOT NULL,
  `course_description` text NOT NULL,
  `course_duration` int(11) NOT NULL COMMENT 'In Days',
  `course_fees` decimal(10,2) NOT NULL,
  `course_is_active` tinyint(4) NOT NULL,
  `course_is_selling` tinyint(4) NOT NULL,
  `course_created_by` int(11) NOT NULL,
  `course_created_date` datetime NOT NULL,
  `course_updated_by` int(11) NOT NULL,
  `course_updated_date` datetime NOT NULL,
  PRIMARY KEY (`course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `enrollment`;
CREATE TABLE `enrollment` (
  `enrollment_id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `enrollment_validity_date` date NOT NULL,
  `enrollment_yearly_membership` tinyint(4) NOT NULL,
  `sub_total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `additional_discount_percentage` decimal(5,2) NOT NULL,
  `additional_discount_amount` decimal(10,2) NOT NULL,
  `total_discount` decimal(10,2) NOT NULL,
  `payable_amount` decimal(10,2) NOT NULL,
  `due_amounts` decimal(10,2) NOT NULL,
  `is_package_applied` tinyint(4) NOT NULL,
  `package_details` text NOT NULL,
  `no_of_courses` int(11) NOT NULL,
  `average_amount` decimal(10,2) NOT NULL,
  `enrollment_discount_note` text NOT NULL,
  `enrollment_created_by` int(11) NOT NULL,
  `enrollment_created_date` date NOT NULL,
  `enrollment_updated_by` int(11) NOT NULL,
  `enrollment_updated_date` datetime NOT NULL,
  `is_delete` tinyint(4) NOT NULL,
  PRIMARY KEY (`enrollment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `enrollment_course`;
CREATE TABLE `enrollment_course` (
  `enrollment_course_id` int(11) NOT NULL AUTO_INCREMENT,
  `enrollment_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `enrollment_course_name` varchar(100) NOT NULL,
  `enrollment_course_amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`enrollment_course_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `package`;
CREATE TABLE `package` (
  `package_id` int(11) NOT NULL AUTO_INCREMENT,
  `no_of_course` int(11) NOT NULL,
  `no_of_free_course` int(11) NOT NULL,
  `validity` date NOT NULL,
  `package_validity_no` int(11) NOT NULL,
  `package_validity_duration` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `created_date` datetime NOT NULL, 
  `updated_by` int(11) NOT NULL,
  `updated_date` datetime NOT NULL,
  PRIMARY KEY (`package_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `payment`;
CREATE TABLE `payment` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `enrollment_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `payment_amount` decimal(10,2) NOT NULL,
  `payment_date` date NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `payment_reference_number` varchar(100) NOT NULL,
  `payment_remarks` text NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `schedule`;
CREATE TABLE `schedule` (
  `schedule_id` int(11) NOT NULL AUTO_INCREMENT,
  `schedule_date` date NOT NULL,
  `schedule_course_id` int(11) NOT NULL,
  `schedule_from_time` time NOT NULL,
  `schedule_to_time` time NOT NULL,
  `schedule_day` int(11) NOT NULL,
  PRIMARY KEY (`schedule_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `student_attendance`;
CREATE TABLE `student_attendance` (
  `attendance_id` int(11) NOT NULL AUTO_INCREMENT,
  `attendance_schedule_id` int(11) NOT NULL,
  `attendance_student_id` int(11) NOT NULL,
  `attendance_enrollment_id` int(11) NOT NULL,
  `attendance_date` date NOT NULL,
  `attendance_created_by` int(11) NOT NULL,
  `attendance_created_date` datetime NOT NULL,
  `attendance_updated_by` int(11) NOT NULL,
  `attendance_updated_date` datetime NOT NULL,
  PRIMARY KEY (`attendance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `student_interest`;
CREATE TABLE `student_interest` (
  `student_interest_id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `course_id` int(11) NOT NULL,
  `created_date` datetime NOT NULL,
  PRIMARY KEY (`student_interest_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `student_master`;
CREATE TABLE `student_master` (
  `student_id` int(11) NOT NULL AUTO_INCREMENT,
  `student_first_name` varchar(100) NOT NULL,
  `student_middle_name` varchar(100) NOT NULL,
  `student_last_name` varchar(100) NOT NULL,
  `student_gender` tinyint(4) NOT NULL,
  `student_birthdate` date NOT NULL,
  `student_phone` varchar(100) NOT NULL,
  `student_mobile` varchar(100) NOT NULL,
  `student_email` varchar(100) NOT NULL,
  `student_profession` varchar(100) NOT NULL,
  `student_reference` varchar(100) NOT NULL,
  `student_reference_other` varchar(100) NOT NULL,
  `lang_preference` varchar(100) NOT NULL COMMENT 'Hindi, Gujarati, English',
  `student_address` varchar(500) NOT NULL,
  `student_city` varchar(100) NOT NULL,
  `student_state` varchar(100) NOT NULL,
  `student_country` varchar(100) NOT NULL,
  `student_photo` varchar(100) NOT NULL,
  `student_interestedin_email` tinyint(4) NOT NULL,
  `student_interestedin_message` tinyint(4) NOT NULL,
  `student_registration_date` date NOT NULL,
  `discontinue` tinyint(4) NOT NULL,
  `student_group_tag` varchar(500) NOT NULL,
  `student_note` text NOT NULL,
  `student_created_by` int(11) NOT NULL,
  `student_created_date` datetime NOT NULL,
  `student_updated_by` int(11) NOT NULL,
  `student_updated_date` datetime NOT NULL,
  `is_delete` tinyint(4) NOT NULL,
  PRIMARY KEY (`student_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  PRIMARY KEY (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- 2018-05-26 12:18:10
