<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Report_model extends CI_Model {

    function get_student_payment_details($payment_date) {
        $sql = "select sum(p.payment_amount) as payment,p.student_id,p.payment_date,sm.student_first_name,sm.student_middle_name,sm.student_last_name
               from payment as p join student_master as sm on p.student_id=sm.student_id
               where p.payment_date='" . $payment_date . "'
               group  by  p.student_id";
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    function get_schedule_by_report_date($report_date) {
        $this->db->select('s.schedule_id,c.course_title,s.schedule_day,s.schedule_from_time,s.schedule_to_time,s.schedule_date,sa.attendance_schedule_id');
        $this->db->where('s.schedule_date', $report_date);
        $this->db->join('course AS c', 'c.course_id = s.schedule_course_id');
        $this->db->join('student_attendance AS sa', 'sa.attendance_schedule_id = s.schedule_id', 'left');
        $this->db->group_by('s.schedule_id');
        return $this->db->get('schedule AS s')->result_array();
    }

    function get_course_revenue() {
        $this->db->select('c.course_title,IFNULL(sum(e.average_amount),0) as average_amount');
        $this->db->join('enrollment_course as ec', 'ec.enrollment_id = e.enrollment_id');
        $this->db->join('course as c', 'ec.course_id = c.course_id', 'right');
        $this->db->group_by('ec.course_id,c.course_title');
        $this->db->order_by("average_amount", "desc");
        return $this->db->get('enrollment as e')->result_array();
    }

    function get_course_details_by_schedule_date($new_from_date, $new_to_date) {
        $this->db->select('c.course_title,DATE_FORMAT(s.schedule_date,"%d-%m-%Y") as schedule_date,s.schedule_course_id,c.course_fees');
        $this->db->join('course as c', 'c.course_id=s.schedule_course_id');
        if ($new_from_date != '') {
            $this->db->where('s.schedule_date >="' . $new_from_date . ' 00:00:00"');
        }
        if ($new_to_date != '') {
            $this->db->where('s.schedule_date <="' . $new_to_date . ' 23:59:59"');
        }
        $this->db->order_by('s.schedule_date');
        return $this->db->get('schedule as s')->result_array();
    }

    function get_enrollment_data($from_date, $to_date, $course_id) {
        $this->db->where('e.enrollment_created_date >="' . $from_date . '"');
        $this->db->where('e.enrollment_created_date <="' . $to_date . '"');
        $this->db->where('ec.course_id', $course_id);
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        return $this->db->get('enrollment AS e')->result_array();
    }

    function get_enrollment_less_then_date($from_date, $schedule_date, $course_id) {
        $this->db->where('e.enrollment_created_date >="' . $from_date . '"');
        $this->db->where('e.enrollment_created_date <="' . $schedule_date . '"');
        $this->db->where('ec.course_id', $course_id);
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        return $this->db->get('enrollment AS e')->result_array();
    }

}

?>