<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Data_lib {

    var $CI;

    public function __construct() {
        $this->CI = & get_instance();
        $this->CI->load->model('payment_model');
    }

    function get_payment_detail($student_id) {
        $payment_details = $this->CI->payment_model->get_payment_details($student_id);
        $get_payment_amount = generate_array_for_id_object($this->CI->payment_model->get_payment_amount($student_id), 'enrollment_id');
        foreach ($payment_details as &$pd) {
            $amount = 0;
            $pd['payment_details'] = $this->CI->payment_model->get_payments($pd['enrollment_id'], $pd['student_id']);
            if (isset($get_payment_amount[$pd['enrollment_id']])) {
                $amount = $get_payment_amount[$pd['enrollment_id']]['paid_amount'];
            }
            $pd['pay_amount'] = $amount == '' ? 0 : $amount;
            $enrollment_created_date = new DateTime($pd['enrollment_created_date']);
            $enrollment_validity_date = new DateTime($pd['enrollment_validity_date']);
            $pd['enrollment_created_date'] = $enrollment_created_date->format('d-m-Y');
            $pd['enrollment_validity_date'] = $enrollment_validity_date->format('d-m-Y');
        }
        return $payment_details;
    }

}
