<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Courses extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('courses_model');
        $this->load->model('payment_model');
        $this->load->model('attendance_model');
        check_authenticated();
    }

    function save_courses() {
        $courses = $this->_get_courses_from_post();
        $courses_title = $courses['course_title'];
        $course_exists = $this->courses_model->get_exists_course_details($courses_title);
        if (!empty($course_exists)) {
            echo json_encode(array('success' => FALSE, 'message' => 'Course already exists'));
            return;
        }
        $validation_message = $this->_validate_courses($courses);
        if ($validation_message != '') {
            echo json_encode(array('success' => FALSE, 'message' => $validation_message));
            return;
        }
        $user_id = get_from_session('ccm_user_id');
        $courses['course_created_by'] = $user_id;
        $courses['course_id'] = $this->courses_model->create($courses);

        echo json_encode(array('success' => TRUE, 'message' => 'Course Saved Successflly', 'course_data' => $courses));
    }

    function get_all_courses() {
        $result = $this->courses_model->get_all_type();
        echo json_encode($result);
    }

    function get_by_courses_id() {
        $courses_id = $this->input->post('course_id');
        $courses_array = $this->courses_model->get_by_courses_id($courses_id);
        echo json_encode($courses_array);
    }

    function update_courses() {
        $courses_id = $this->input->post('course_id');
        $courses = $this->_get_courses_from_post();
        $validation_message = $this->_validate_courses($courses);
        if ($validation_message != '') {
            echo json_encode(array('success' => false, 'message' => $validation_message));
            return;
        }
        $user_id = get_from_session('ccm_user_id');
        $courses['course_updated_by'] = $user_id;
        $this->courses_model->update_courses($courses_id, $courses);
        $courses['course_id'] = $courses_id;
        echo json_encode(array('success' => true, 'message' => 'Course Updated Successflly', 'course_data' => $courses));
    }

    function delete_course() {
        $courses_id = $this->input->post('course_id');
        $check_existing_courses_in_interest = $this->courses_model->get_interest_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_interest)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It has interested students'));
            return;
        }
        $check_existing_courses_in_enrollment = $this->courses_model->get_enrollment_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_enrollment)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It Is Used In Enrollment Course'));
            return;
        }
        $check_existing_courses_in_schedule = $this->courses_model->get_schedule_by_course_id($courses_id);
        if (!empty($check_existing_courses_in_schedule)) {
            echo json_encode(array('success' => FALSE, 'message' => 'You Cannot Delete This Course It Is Used In Schedule'));
            return;
        }
        $this->courses_model->delete_course_by_id($courses_id);
        echo json_encode(array('success' => true, 'message' => 'Course deleted successfully'));
    }

    function _get_courses_from_post() {
        return array(
            'course_title' => strtoupper($this->input->post('courses_title')),
            'course_description' => $this->input->post('courses_description'),
            'course_duration' => $this->input->post('courses_duration'),
            'course_fees' => $this->input->post('courses_fees'),
            'course_is_active' => $this->input->post('courses_is_active'),
            'course_is_selling' => $this->input->post('courses_is_selling')
        );
    }

    function _validate_courses($courses) {
        if ($courses['course_title'] == '') {
            return 'Please Enter Course Title.';
        }
        if ($courses['course_duration'] == '') {
            return 'Please Enter Course Duration.';
        }
        if ($courses['course_fees'] == '') {
            return 'Please Enter Rate.';
        }
        return '';
    }

    function get_enrollment_details() {
        $course_id = $this->input->post('course_id');
        $post_from_date = $this->input->post('from_date');
        if ($post_from_date != '') {
            $from_date = to_database_format($post_from_date);
        } else {
            $from_date = '';
        }
        $post_to_date = $this->input->post('to_date');
        if ($post_to_date != '') {
            $to_date = to_database_format($post_to_date);
        } else {
            $to_date = '';
        }
        $enrollment_details = $this->courses_model->get_enrollment_details($course_id, $from_date, $to_date);
        foreach ($enrollment_details as &$enrollment_data) {
            $enrollment_data['payment_details'] = $this->payment_model->get_payments($enrollment_data['enrollment_id'], $enrollment_data['student_id']);
            $amount = 0;
            foreach ($enrollment_data['payment_details'] as &$e) {
                $amount += $e['payment_amount'];
            }
            $enrollment_data['paid_amount'] = $amount;
            $enrollment_data['has_remaining_attendance'] = 'yes';
            $student_attendance = $this->attendance_model->get_attendence_by_student($course_id, $enrollment_data['enrollment_id']);
            if (!empty($student_attendance)) {
                if ($student_attendance['total_attendance'] < $enrollment_data['course_duration']) {
                    $enrollment_data['has_remaining_attendance'] = 'yes';
                } else {
                    $enrollment_data['has_remaining_attendance'] = 'no';
                }
            }
        }
        echo json_encode($enrollment_details);
    }

}

/**
 * EOF: ./application/controllers/Courses.php
 */
