<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Call_log extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('call_log_model');
        $this->load->model('interest_model');
        $this->load->model('student_master_model');        
    }
    function get_call_log_by_student_id()
    {
        $student_id = $this->input->post('student_id');
        $call_log = $this->call_log_model->get_call_log_by_student_id($student_id);
        $c=1;
        $call_logs = array();
        foreach ($call_log as $row) {
            $log = $row;
            $log['sr_no'] = $c;
            $date = new DateTime($log['call_date']);
            $log['call_date']= $date->format('d-m-Y');
            $call_logs[] = $log;
            $c++;
        }
        echo json_encode($call_logs);
    }
    function delete_call_log()
    {
        $call_log_id = $this->input->post('call_log_id');
        $student_id = $this->input->post('student_id');
        
        $this->call_log_model->delete_call_log($call_log_id);
        $last_call_date = $this->call_log_model->get_last_call_date($student_id);
        if(empty($last_call_date))
        {
            $last_call_date['call_date'] = '';
        }
        else
        {
            $last_call_date['call_date'] = date_format(date_create($last_call_date['call_date']),'d-m-Y');
            $last_call_date['call_date'] = '<span class="red_color"> '.$last_call_date['call_date'] .'</span><br>'.$last_call_date['note'].'<br> <span class="red_color"> '.$last_call_date['course_title'].'</span>';
        }
        echo json_encode(array('success' => true, 'message' => 'Call Log Deleted','last_call_date' => $last_call_date['call_date']));
    }
    function add_call_log()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');

        $call_log_date = $this->input->post('call_log_date');
        $call_log_note = $this->input->post('call_log_note');

        foreach ($call_log_date as $key => $row) {

            $date = new DateTime($row);
            $call_date = $date->format('Y-m-d');

            $call_log[] = array(
                                'student_id' => $student_id,
                                'course_id' => $course_id,
                                'call_date' => $call_date,
                                'note' => $call_log_note[$key]
                            );
           
        }

        $this->call_log_model->save_call_log($call_log);

        $last_call_date = $this->call_log_model->get_last_call_date($student_id);
        if(empty($last_call_date))
        {
            $last_call_date['call_date'] = '';
        }
        else
        {
            $last_call_date['call_date'] = date_format(date_create($last_call_date['call_date']),'d-m-Y');
            $last_call_date['call_date'] = '<span class="red_color"> '.$last_call_date['call_date'] .'</span><br>'.$last_call_date['note'].'<br> <span class="red_color"> '.$last_call_date['course_title'].'</span>';
        }

        echo json_encode(array('success' => true, 'message' => 'Call Log Added','last_call_date' => $last_call_date['call_date']));
    }

    


}

/*
 * EOF: ./application/controllers/Login.php
 */
