<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Report_model extends CI_Model {

    // function get_student_payment_details($payment_date) {
    //     $sql = "select sum(p.payment_amount) as payment, GROUP_CONCAT(enrollment_id) as enrollment_id,p.student_id,p.payment_date,p.payment_mode,sm.student_first_name,sm.student_middle_name,sm.student_last_name
    //            from payment as p join student_master as sm on p.student_id=sm.student_id
    //            where p.payment_date='" . $payment_date . "'
    //            group  by  p.student_id";
    //     $recs = $this->db->query($sql);
    //     return $recs->result_array();
    // }

    // function get_student_payment_details($payment_date) {
    //     $sql = "select sum(p.payment_amount) as payment, GROUP_CONCAT(enrollment_id) as enrollment_id,p.student_id,p.payment_date,p.payment_mode,sm.student_first_name,sm.student_middle_name,sm.student_last_name
    //            from payment as p join student_master as sm on p.student_id=sm.student_id
    //            where p.payment_date='" . $payment_date . "'
    //            group  by  p.student_id order by p.payment_date asc,p.payment_id asc";
    //     $recs = $this->db->query($sql);
    //     return $recs->result_array();
    // }

    function get_student_payment_details($payment_date) {
        $sql = "select p.payment_id,p.payment_amount as payment, enrollment_id as enrollment_id,p.student_id,p.payment_date,p.payment_mode,sm.student_first_name,sm.student_middle_name,sm.student_last_name
               from payment as p join student_master as sm on p.student_id=sm.student_id
               where DATE(p.payment_date)='" . $payment_date . "'
               order by p.payment_date asc,p.payment_id asc";
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    function get_student_course_id($enrollment_id) {

        $sql = "select GROUP_CONCAT(e.course_id) as course_id
                from enrollment_course e
                where e.enrollment_id IN (".$enrollment_id.")";
        $select = $this->db->query($sql);
        return $select->row_array();
    }

    function get_schedule_by_report_date($report_date) {
        $this->db->select('s.schedule_course_id,s.schedule_id,c.course_title,s.schedule_day,s.schedule_from_time,s.schedule_to_time,s.schedule_date,sa.attendance_schedule_id');
        $this->db->where('s.schedule_date', $report_date);
        $this->db->join('course AS c', 'c.course_id = s.schedule_course_id');
        $this->db->join('student_attendance AS sa', 'sa.attendance_schedule_id = s.schedule_id', 'left');
        $this->db->group_by('s.schedule_id');
        return $this->db->get('schedule AS s')->result_array();
    }

    function get_course_revenue() {
        $this->db->select('c.course_id,c.course_title,IFNULL(sum(e.average_amount),0) as average_amount');
        $this->db->join('enrollment_course as ec', 'ec.enrollment_id = e.enrollment_id');
        $this->db->join('course as c', 'ec.course_id = c.course_id', 'right');
        $this->db->group_by('ec.course_id,c.course_title');
        $this->db->order_by("average_amount", "desc");
        return $this->db->get('enrollment as e')->result_array();
    }   

    function get_course_day_wise_data($course_id)
    {
        $this->db->select('DATE_FORMAT(s.schedule_date,"%d-%m-%Y") as schedule_date,s.*,c.course_duration');
        $this->db->from('schedule s');
        $this->db->join('course c','c.course_id=s.schedule_course_id','left');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('s.schedule_day','1');
        $this->db->order_by('s.schedule_date', 'desc');
        return $this->db->get()->result_array();
    }

    function get_course_day_schedule($data)
    {
        $this->db->select('s.*,DATE_FORMAT(s.schedule_date,"%d-%m-%Y") as schedule_date,c.course_duration');
        $this->db->from('schedule s');
        $this->db->join('course c','c.course_id=s.schedule_course_id','left');
        $this->db->where('s.schedule_course_id',$data['schedule_course_id']);
        $this->db->where('s.schedule_day <='.$data['course_duration']);
        $this->db->where('s.schedule_date >="'.$data['schedule_date'].'"');
        $this->db->limit($data['course_duration']);
        return $this->db->get()->result_array();
    }

    function get_course_details_by_schedule_date($new_from_date, $new_to_date) {
        $this->db->select('c.course_title,DATE_FORMAT(s.schedule_date,"%d-%m-%Y") as schedule_date,s.schedule_id,s.schedule_course_id,c.course_fees');
        $this->db->join('course as c', 'c.course_id=s.schedule_course_id');
        if ($new_from_date != '') {
            $this->db->where('s.schedule_date >="' . $new_from_date . ' 00:00:00"');
        }
        if ($new_to_date != '') {
            $this->db->where('s.schedule_date <="' . $new_to_date . ' 23:59:59"');
        }
        $this->db->order_by('s.schedule_date');
        return $this->db->get('schedule as s')->result_array();
    }

    function get_enrollment_data($from_date, $to_date, $course_id) {
        $this->db->where('e.enrollment_created_date >="' . $from_date . '"');
        $this->db->where('e.enrollment_created_date <="' . $to_date . '"');
        $this->db->where('ec.course_id', $course_id);
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        return $this->db->get('enrollment AS e')->result_array();
    }

    function get_enrollment_less_then_date($from_date, $schedule_date, $course_id) {
        $this->db->where('e.enrollment_created_date >="' . $from_date . '"');
        $this->db->where('e.enrollment_created_date <="' . $schedule_date . '"');
        $this->db->where('ec.course_id', $course_id);
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        return $this->db->get('enrollment AS e')->result_array();
    }

    function getEnrollmentDateWise($from_date, $to_date, $sort_by)
    {        
        $this->db->select('e.*,s.student_id,s.student_first_name,s.student_last_name,s.student_mobile');
        $this->db->select('(SELECT GROUP_CONCAT(enrollment_course_name) from enrollment_course where enrollment_id=e.enrollment_id)  as enrollment_course_name');
        $this->db->from('enrollment e');        
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->where('e.enrollment_created_date >=',$from_date);
        $this->db->where('e.enrollment_created_date <=',$to_date);
        $this->db->where('e.is_delete',0);
        $this->db->order_by('e.'.$sort_by[0],$sort_by[1]);
        $res = $this->db->get();
        return $res->result_array();
    }

    function getPaymentCollectionData($from_date, $to_date, $sort_by)
    {
        $this->db->select('e.*,s.student_id,s.student_first_name,s.student_last_name,s.student_mobile');
        $this->db->select('(SELECT GROUP_CONCAT(enrollment_course_name) from enrollment_course where enrollment_id=e.enrollment_id)  as enrollment_course_name');
        $this->db->from('enrollment e');
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->where('e.enrollment_created_date >=',$from_date);
        $this->db->where('e.enrollment_created_date <=',$to_date);
        $this->db->where('e.due_amounts !=',0);
        $this->db->where('e.is_delete',0);
        $this->db->order_by('e.'.$sort_by[0],$sort_by[1]);
        $res = $this->db->get();
        return $res->result_array();
    }

    function get_course_revenue_attendance_wise($schedule_id,$schedule_date)
    {
        $this->db->select('e.average_amount');
        $this->db->from('student_attendance sa');
        $this->db->join('enrollment e','e.enrollment_id=sa.attendance_enrollment_id');
        $this->db->join('schedule s','s.schedule_id=sa.attendance_schedule_id');
        $this->db->where('sa.attendance_schedule_id',$schedule_id);
        // $this->db->where('sa.attendance_date',$schedule_id);
        $this->db->where('sa.attendance_repeated',0);
        $this->db->where('s.schedule_day',1);
        $res = $this->db->get();
        return $res->result_array();
    }


    function get_student_attendance_wise($from_date,$to_date,$r_date)
    {
        $this->db->select('s.student_id,s.student_first_name,s.student_middle_name,s.student_last_name,s.student_mobile,DATE_FORMAT(s.student_registration_date,"%d-%m-%Y") as student_registration_date,s.student_interestedin_email,s.student_interestedin_message,s.discontinue,sa.attendance_date');
        $this->db->from('student_master s');
        $this->db->join('student_attendance sa','sa.attendance_student_id=s.student_id','left');
        $this->db->where('s.student_registration_date <',$r_date);
        //$this->db->where('sa.attendance_date >',$from_date);
        //$this->db->where('sa.attendance_date <',$to_date);
        $this->db->where("sa.attendance_date NOT BETWEEN '" . $from_date . "' AND '" . $to_date . "'", NULL, FALSE);
        $this->db->where('s.is_delete',0);
        $this->db->group_by('s.student_id');
        $res = $this->db->get();
        return $res->result_array();
    }

    function check_student_attendance_wise($type,$student_id,$from_date,$to_date)
    {
        $this->db->select('count(sa.attendance_id) as total_attendance');        
        $this->db->from('student_master s');
        $this->db->join('student_attendance sa','sa.attendance_student_id=s.student_id');
        $this->db->where('sa.attendance_student_id',$student_id);
        if($from_date != '')
        {
            if($type == 'inactive')
            {
                $this->db->where("(sa.attendance_date >'".$to_date."')");
            }
            else
            {
                $this->db->where("(sa.attendance_date <'".$from_date."' OR sa.attendance_date >'".$to_date."')");
            }
        }
        else
        {
            $this->db->where("(sa.attendance_date >'".$to_date."')");
        }
        $this->db->where('s.is_delete',0);
        $res = $this->db->get();
        return $res->row_array();
    }

    function get_call_log_date_wise($new_from_date,$new_to_date)
    {
        $this->db->select('cl.*,DATE_FORMAT(cl.call_date, "%d-%m-%Y") as call_date, s.student_first_name,s.student_middle_name,s.student_last_name,s.student_mobile, IF(cl.reminder_date="0000-00-00"," ",DATE_FORMAT(cl.reminder_date, "%d-%m-%Y")) as reminder_date,c.course_title');
        $this->db->from('call_log cl');
        $this->db->join('student_master s','s.student_id=cl.student_id');
        $this->db->join('course c','c.course_id=cl.course_id');
        $this->db->where('cl.call_date >=',$new_from_date);
        $this->db->where('cl.call_date <=',$new_to_date);
        $this->db->where('s.is_delete ',0);
        $this->db->order_by('cl.call_date','ASC');
        $res = $this->db->get();
        return $res->result_array();
    }
}

?>