var studentMasterListTemplate = Handlebars.compile($('#student_master_list_template').html());
var studentMasterTableTemplate = Handlebars.compile($('#student_master_table_template').html());
var studentMasterFormTemlate = Handlebars.compile($('#student_master_form_temlate').html());
var studentMasterViewTemlate = Handlebars.compile($('#student_master_view_template').html());
var studentMasterActionButtonsTemplate = Handlebars.compile($("#student_master_action_buttons_template").html());
var studentMasterProfileImageTemplate = Handlebars.compile($("#student_master_profile_image_template").html());
var actionButtonTemplate = Handlebars.compile($('#action_buttons_template').html());
var addPaymentTemplate = Handlebars.compile($('#add_payment_modal').html());
var studentScheduleInformation = Handlebars.compile($('#student_schedule_information').html());
var reminderListTemplate = Handlebars.compile($('#reminder_list_template').html());
var reminderListTableTemplate = Handlebars.compile($('#reminder_list_table_template').html());
var studentCalllogTemplate = Handlebars.compile($('#student_call_log_template').html());

var StudentMaster = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
StudentMaster.Router = Backbone.Router.extend({
    routes: {
        '': 'renderList',
        'student/list': 'renderList',
        'student/view/:id': 'renderView',
        'student/reminder': 'renderReminderView'
    },
    renderList: function () {
        StudentMaster.listview.listPage();
    },
    renderView: function (studentId) {
        StudentMaster.listview.viewStudent(studentId);
//        StudentMaster.listView.viewPayment(stude StudentMaster.listview.viewStudent(studentId);ntId)
    },
    renderReminderView:function() {
        StudentMaster.listview.viewReminder();
    }
});
StudentMaster.listView = Backbone.View.extend({
    el: 'div#main_container',
    events: {
        'click #new_student_master_btn': 'newStudent',
        'click #student_lan_chack_box': 'showHideLanDiv',
        //'click #save_pay_btn': 'paymentSave',
    },
    appendAreaNAme:function(area_name) {
        $('#student_area').val(area_name);
        $('#area_list').hide();
    },
    searchForArea:function() {
        $('#area_list').show();
        var input, filter, ul, li, a, i;
        input = document.getElementById("student_area");
        filter = input.value.toUpperCase();
        ul = document.getElementById("area_list");
        li = ul.getElementsByTagName("li");
        var is_found = false;
        for (i = 0; i < li.length; i++)
        {
            a = li[i].getElementsByTagName("a")[0];
            if(a.innerHTML.toUpperCase().indexOf(filter) > -1)
            {
                is_found = true;
                li[i].style.display = "";
            }
            else
            {
                li[i].style.display = "none";
            }
        }
        if(is_found == true)
        {
            $('#area_list').show();
        }
        else
        {
            $('#area_list').hide();
        }
    },
    showHideLanDiv: function() {

        if($("#student_lan_chack_box").prop('checked') == true)
        {
            $('#student_lan_chack_box').val('1');
            $('#student_from_lan_div').show();
        }
        else
        {
            $('#student_lan_chack_box').val('0');
            $('#student_from_lan_div').hide();
        }
    },
    exportStudent: function (export_type) {
        $('#temp_password').val('');
        getConfirmPassword(function (result) {
            if (result === false) {
                return false;
            }
            var tempPassword = $('#temp_password').val();
            if (tempPassword == 'sw@dbliss') {
                $('#export_type').val(export_type);
                document.getElementById('student_search_form').submit();
            } else {
                showError("Please Enter Correct Password");
                $('#temp_password').val('');
            }
        });
    },
    listPage: function (studentId) {
        this.$el.html(studentMasterListTemplate);
        $('#student_master_table_container').html(studentMasterTableTemplate);
        renderOptionsForTwoDimensionalArray_payment_mode(referenceArray, 'search_reference', false);
        var genderArray = {};
        genderArray[MALE] = 'Male';
        genderArray[FEMALE] = 'Female';
        renderOptionsForTwoDimensionalArray(genderArray, 'search_gender', false);
        $('.select2').select2({"allowClear": true});
        this.availableTags();
        this.loadstudent(false, '');
    },
    loadstudent: function (isSearch, searchData) {
        if (isSearch) {
            studentMasterDataTable.destroy();
        }
        var sturentMasterActionRenderer = function (data, type, full, meta) {
            var discontinueNo = 'display:none;';
            var discontinueYes = '';
            if (full.discontinue == GLOBAL_DISCONTINUE_YES) {
                discontinueNo = '';
                discontinueYes = 'display:none;';
            }
            return studentMasterActionButtonsTemplate({"student_id": data, 'discontinue_yes': discontinueYes, 'discontinue_no': discontinueNo, 'GLOBAL_DISCONTINUE_YES': GLOBAL_DISCONTINUE_YES, 'GLOBAL_DISCONTINUE_NO': GLOBAL_DISCONTINUE_NO});
        };

        var genderRenderer = function (data, type, full, meta) {
            return data == FEMALE ? 'Female' : 'Male';
        };
        var imageRenderer = function (data, type, full, meta) {

            $('#img_name').val(data);
            if (!data) {
                return '<img src="assets/profile_image/images.jpg" width="50" />';
            } else {
                return '<img src="assets/profile_image/' + data + '" width="50"/>';
            }
        };
        var emailCheckBoxRenderer = function (data, type, full, meta) {

            if (full.student_interestedin_email == GLOBAL_YES && full.discontinue == 0) {
                return ' <div class="checkbox checkbox-primary"><input type="checkbox" name="email_chack_box" id="email_chack_box_' + data + '" value="' + data + '"><label for="email_chack_box_' + data + '"></label></div>';
            }
            return '';
        };
        var smsCheckBoxRenderer = function (data, type, full, meta) {
            if (full.student_interestedin_message == GLOBAL_YES && full.discontinue == 0) {
                return ' <div class="checkbox checkbox-primary"><input type="checkbox" name="sms_chack_box" id="sms_chack_box_' + data + '" value="' + data + '"><label for="sms_chack_box_' + data + '"></label></div>';
            }
            return '';
        };
        var dateRenderer = function (data, type, full, meta) {
             return full.student_registration_date;
        };
        var student_FullName_Renderer = function (data, type, full, meta) {
            var fullName = studentFullName(full);
            // if (full.discontinue == GLOBAL_DISCONTINUE_YES) {
            //     fullName += '<br><i><label class="label lab el-lg" style="color: #DD4A68;margin-left: -6px;">Discontinued</lable></i>';
            // }
            var text = "'student_module'";
            text.toString();

            var discontinueNo = 'display:none;';
            var discontinueYes = '';
            if (full.discontinue == GLOBAL_DISCONTINUE_YES) {
                discontinueNo = '';
                discontinueYes = 'display:none;';
            }

            fullName += '<br><a target="_blank" href="main#student/view/'+full.student_id+'" class="btn btn-xs btn-light-black" id="student_view_btn" data-toggle="tooltip" data-placement="top" title="View">'+
                            '<label class="fa fa-eye label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</a>'+
                        '<button type="button" class="btn btn-xs btn-light-black" id="edit_student_master_btn_'+full.student_id+'"  onclick="StudentMaster.listview.editStudent('+full.student_id+')" data-toggle="tooltip" data-placement="top" title="Edit">'+
                            '<label class="fa fa-pencil label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</button>'+
                        '<button type="button" class="btn btn-xs btn-light-black"  onclick="StudentMaster.listview.profileImage('+full.student_id+')" data-toggle="tooltip" data-placement="top" title="Camera">'+
                            '<label class="fa fa-camera label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</button>'+
                        '<button type="button" class="btn btn-xs btn-light-black"  id="discontinue_btn_'+full.student_id+'" onclick="StudentMaster.listview.disContinueStudent('+full.student_id+','+GLOBAL_DISCONTINUE_YES+')" data-toggle="tooltip" data-placement="top" title="dis-continue" style="'+discontinueYes+'">'+
                            '<label class="fa fa-remove label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</button>'+
                        '<button type="button" class="btn btn-xs btn-light-black"  id="continue_btn_'+full.student_id+'" onclick="StudentMaster.listview.disContinueStudent('+full.student_id+','+GLOBAL_DISCONTINUE_NO+')" data-toggle="tooltip" data-placement="top" title="continue" style="'+discontinueNo+'">'+
                            '<label class="fa fa-check label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</button>'+
                        '<button type="button" class="btn btn-xs btn-light-black" id="delete_student_btn_'+full.student_id+'" data-toggle="tooltip" data-placement="top" title="delete" onclick="StudentMaster.listview.deleteStudent('+full.student_id+')">'+
                            '<label class="fa fa-trash label-btn-icon"></label>'+
                        '</button>';

            return fullName;
        };

        var mobileRenderer = function (data, type, full, meta) {

             var mobile = '';

            if(full.student_mobile != '')
            {
                mobile+=full.student_mobile;
            }

            if (full.discontinue == GLOBAL_DISCONTINUE_YES) {
                mobile += '<br/><small class="discontinue_title" data-toggle="tooltip" data-placement="top" title="Student Discontinued">Discontinued</small>';
            }

            return mobile;

        };

        studentMasterDataTable = $('#student_master_data_table').DataTable({
            ajax: {
                url: 'student_master/get_all_student',
                dataSrc: "",
                type: "post",
                data: searchData,
                "dataSrc": function ( json ) {
                    // let length = json.length;
                    // json.forEach((element, i) => {
                    //   element.sr = length - i;
                    // });

                    return json;
                }
            },
            deferRender: true,
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            'processing': true,
            'language': {
                'loadingRecords': '&nbsp;',
                'processing': 'Loading...'
            },
            columns: [
                {data: 'student_id'},
                {data: 'student_id', 'render': emailCheckBoxRenderer},
                {data: 'student_id', 'render': smsCheckBoxRenderer},
                {data: 'student_photo', 'render': imageRenderer},
                {data: 'student_registration_date', 'render': dateRenderer},
                {data: 'full_name', 'render': student_FullName_Renderer},
                {data: 'student_gender', 'render': genderRenderer},
                {data: 'student_mobile', 'render': mobileRenderer},
                {
                    "className": '',
                    "orderable": false,
                    "data": 'student_id',
                    "render": sturentMasterActionRenderer
                }
            ],
            "columnDefs": [{
                    "searchable": false,
                    "orderable": false,
                    "targets": 0,
                    "defaultcontent": "-"

                }],
            "order": [[1, 'asc']],
            "dom": '<"col-sm-6"l><"col-sm-6"f><"col-sm-6"i><"col-sm-6"p>rt<"col-sm-6"i><"col-sm-6"p><"clear">',
            "createdRow": function (row, data, dataIndex) {
                if (data['total_enrollment'] == 0) {
                    $(row).css("background-color", "white");
                }
                if (data['total_enrollment'] != 0) {
                    $(row).css("background-color", "#CBE0CB");
                    if ((data['due_amounts'] >= 0) && (data['due_amounts'] != 0)) {
                        $(row).css("background-color", "#F4E2E2"); //green
                    }
                }
                $(row).attr('data-id', data['student_id']);
            },
            'initComplete':function( settings, json ) {

                $.ajax({
                    type: 'POST',
                    url: 'student_attendance/get_ref_counter',
                    dataType: 'json',
                    async: true,
                    success: function (data) {
                        var ref_array_counter = data;
                        var ref_html = '';
                        $.each(ref_array_counter, function (index,value) {
                            ref_html+='<a class="btn btn-app">'+
                                            '<span class="ref_label">'+value.name+'</span><br>'+value.count+
                                       '</a>';
                        });
                        $('#student_ref_div').html(ref_html);
                    }
                });
            }
        });
        /*studentMasterDataTable.on('order.dt search.dt', function () {
            studentMasterDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();*/
    },
    searchStudentsData: function () {
        var studentMasterFormData = $('#student_search_form').serializeFormJSON();

        var address = studentMasterFormData.search_address;
        var reference = studentMasterFormData.search_reference;
        var gender = studentMasterFormData.search_gender;
        var group_tag = studentMasterFormData.student_group_tag1;
        if (address == '' && reference == '' && group_tag == '' && gender == '') {
            showError('Please Fill Any One Field');
            return false;
        }
        var searchData = {
            "search_address": address,
            "search_reference": reference,
            "search_gender": gender,
            "student_group_tag1": group_tag
        };
        this.loadstudent(true, searchData);
    },
    newStudent: function () {

        var area_list = [];
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: 'student_master/get_area',
            async: false,
            success: function (data) {
                area_list = data.area;
            }
        });

        var parseData = {
            "student_city": 'Surat',
            "student_state": 'Gujarat',
            "YES": GLOBAL_YES,
            "NO": GLOBAL_NO,
            "MALE": MALE,
            "FEMALE": FEMALE,
            "area_list":area_list
        };

        $('#add_student_popup_body').html(studentMasterFormTemlate({"student_data": parseData}));
        //$('#student_master_form_container').html(studentMasterFormTemlate({"student_data": parseData}));
        $('#save_student_master_btn').show();
        $('#save_interest_student_master_btn').show();

        renderOptionsForTwoDimensionalArray(countryArray, 'student_country');
        renderOptionsForTwoDimensionalArray_payment_mode(referenceArray, 'student_reference', true);
        $('#student_reference').change(function () {
            var studentReferenceMode = $(this).val();
            if (studentReferenceMode != 'Other') {
                $('#other_reference').hide();
            } else {
                $('#other_reference').show();
            }
        });
        $('#student_country').val('1');
        $('.date_picker').datetimepicker({
            format: 'dd-mm-yyyy',
        });
        $('#student_registration_date').val(dateTo_DD_MON_YYYY(new Date()));

        var data2 = $("#sortable").sortable();
        $("#sortable").disableSelection();
        this.availableTags();
        var data = [];
        $('#student_name').focus();
        $('.select2').select2({"allowClear": true});
        $('#student_from_lan_div').hide();
        $('#student_lan_chack_box').val(0);
        $('#student_lan_chack_box').prop("checked", false);

        $('#add_student_popup').modal({backdrop: 'static', keyboard: false});
    },
    saveStudent: function (isInterest,refresh) {
        var that = this;
        var recipeLanguageData = [];
        var studentMasterFormData = $('#add_edit_student_master_from').serializeFormJSON();
        $.each($('#sortable').find('li'), function () {
            recipeLanguageData.push($(this).text());
        });
        studentMasterFormData.recipe_language_data = recipeLanguageData;
        if (studentMasterFormData.student_first_name == '') {
            showError('Please Enter First Name.');
            $('#student_first_name').focus();
            return false;
        }
//        if ($('#student_middle_name').val() == '') {
//            showError('Please Enter Middle Name.');
//            $('#student_first_name').focus();
//            return false;
//        }
        if ($('#student_last_name').val() == '') {
            showError('Please Enter Last Name.');
            $('#student_last_name').focus();
            return false;
        }
        var mobile_number = $('#student_mobile').val();
        if (mobile_number == '') {
            showError('Please Enter Mobile Number.');
            //$('#student_mobile').focus();
            return false;
        }
        if (mobile_number.length != 10) {
            showError('Please Enter 10 digit Mobile Number.');
            //$('#student_mobile').focus();
            return false;
        }

        // var student_area = $('#student_area').val();
        // if (student_area == '') {
        //     showError('Please Enter Area.');
        //     //$('#student_mobile').focus();
        //     return false;
        // }

        if (studentMasterFormData.student_interestedin_email == GLOBAL_YES) {
            if ($('#student_email').val() == '') {
                showError('Please Enter Email.');
                $('#student_email').focus();
                return false;
            }
            if (!validateEmail($('#student_email').val())) {
                showError('Please Enter Valid Email.');
                $('#student_email').focus();
                return false;
            }
        } else {
            if ($('#student_email').val() != '') {
                if (!validateEmail($('#student_email').val())) {
                    showError('Please Enter Valid Email.');
                    $('#student_email').focus();
                    return false;
                }
            }
        }
        var url = studentMasterFormData.student_id == '' ? 'save' : 'update';
        $.ajax({
            type: 'POST',
            url: 'student_master/' + url + '_student',
            data: studentMasterFormData,
            success: function (data) {
                var StudentData = JSON.parse(data);
                var studentId = StudentData.student_id;
                if (StudentData.success === false) {
                    showError(StudentData.message);
                    return false;
                }
                $('#add_student_popup').modal('hide');
                showSuccess(StudentData.message);
                if(refresh == true)
                {
                    StudentMaster.listview.viewStudent(studentId);
                }
                else
                {
                    if (isInterest)
                    {
                        Interest.listview.addIntrest(studentId,'student_module');
                        //Interest.router.navigate('interest/list/' + studentId, {trigger: true});
                    }
                    else
                    {
                        studentMasterDataTable.ajax.reload( null, false );
                    }
                }
                $('#student_master_form_container').html('');
                that.availableTags();
                // if (isInterest) {
                //     Interest.listview.addIntrest(studentId);
                //     //Interest.router.navigate('interest/list/' + studentId, {trigger: true});
                // }
            }
        });
    },
    profileImage: function (studentId) {
        $.ajax({
            type: 'POST',
            url: 'student_master/view_student',
            data: {"student_id": studentId},
            success: function (response) {
                var parseData = JSON.parse(response);
                $('#profile_image_container').html(studentMasterProfileImageTemplate({"student_id": studentId}));
                $('#image_module').modal({
                    "show": true,
                    "backdrop": 'static',
                    "keyboard": false});
                Webcam.set({
                    width: 200,
                    height: 150,
                    image_format: 'jpeg',
                    jpeg_quality: 90
                });
                Webcam.attach('#my_camera');
                $('#img_name').val(parseData.student_photo);
                if (parseData.student_photo != "") {
                    $('#results1').html('<img src="assets/profile_image/' + parseData.student_photo + '" class="img img-responsive" height="150" width="200"/>');
                    $('#results_default').hide();
                }
            }
        });
    },
    take_snapshot: function (studenId) {
        Webcam.snap(function (data_uri) {
            Webcam.upload(data_uri, 'Student_master/get_image/' + studenId, function (code, text) {
                $('#results_default').hide();
                $('#results1').hide();
                $('#img_name').val(text);
                $('#results').html('<img src="assets/profile_image/' + text + '"/>');
            });
        });
    },
    save_profile_image: function (studentId) {
        $.ajax({
            type: 'POST',
            url: 'student_master/save_profile_image',
            data: {
                "student_id": studentId,
                "profile_image": $('#img_name').val()
            },
            success: function (response) {
                var StudentData = JSON.parse(response);
                if (StudentData.success === false) {
                    showError('');
                    return false;
                }
                showSuccess(StudentData.message);
                window.location = "main#student/list";
                window.location.reload();
            }
        });
    },
    delete_profile_image: function (studentId) {
        $.ajax({
            type: 'POST',
            url: 'student_master/delete_profile_image',
            data: {
                "student_id": studentId,
            },
            success: function (response) {
                var StudentData = JSON.parse(response);
                if (StudentData.success === false) {
                    showError('');
                    return false;
                }
                showSuccess(StudentData.message);
                window.location = "main#student/list";
//                window.location.reload();
            }
        });
    },
    editStudent: function (studentId,refresh=false) {

        $('#spinner_edit_student_master_btn_' + studentId).show();
        $('#edit_student_master_btn_' + studentId).hide();
        var that = this;
        $('#student_name').focus();
        var area_list = [];
        $.ajax({
            type: 'POST',
            dataType: 'json',
            url: 'student_master/get_area',
            async: false,
            success: function (data) {
                area_list = data.area;
            }
        });

        $.ajax({
            type: 'POST',
            url: 'student_master/get_by_student_id',
            data: {"student_id": studentId},
            success: function (response) {


                var parseData = JSON.parse(response);
                parseData.YES = GLOBAL_YES;
                parseData.NO = GLOBAL_NO;
                parseData.MALE = MALE;
                parseData.FEMALE = FEMALE;
                parseData.area_list = area_list;
                parseData.refresh = refresh;
                $('#spinner_edit_student_master_btn_' + studentId).hide();
                $('#edit_student_master_btn_' + studentId).show();

                $('#add_student_popup_body').html(studentMasterFormTemlate({"student_data": parseData}));
                //$('#student_master_form_container').html(studentMasterFormTemlate({"student_data": parseData}));
                $('#add_student_popup').modal({backdrop: 'static', keyboard: false});
                that.availableTags();
                renderOptionsForTwoDimensionalArray(langPreferenceArray, 'lang_preference');
                renderOptionsForTwoDimensionalArray(countryArray, 'student_country');
                renderOptionsForTwoDimensionalArray_payment_mode(referenceArray, 'student_reference', true);
                $("input[name=student_gender][value=" + parseData.student_gender + "]").attr('checked', 'checked');
                $("input[name=student_interestedin_email][value=" + parseData.student_interestedin_email + "]").attr('checked', 'checked');
                $("input[name=student_interestedin_message][value=" + parseData.student_interestedin_message + "]").attr('checked', 'checked');
                $('#update_student_master_btn').show();
                $('#student_birthdate').datepicker({
                    'format': 'dd-mm-yyyy',
                    'endDate': new Date(),
                    'autoclose': true
                });
                $('#student_registration_date').datepicker({
                    'format': 'dd-mm-yyyy',
                    'endDate': new Date(),
                    'autoclose': true
                });
                $('#student_reference').change(function () {
                    var studentReferenceMode = $(this).val();
                    if (studentReferenceMode != 'Other') {
                        $('#other_reference').hide();
                    } else {
                        $('#other_reference').show();
                    }

                });
                $('#student_registration_date').datepicker('setDate', changeDateFormat(parseData.student_registration_date));

                if(parseData.student_birthdate != '0000-00-00')
                $('#student_birthdate').datepicker('setDate', changeDateFormat(parseData.student_birthdate));
                $('#lang_preference').val(parseData.lang_preference);
                $('#student_country').val(parseData.student_country);
                $('#student_area').val(parseData.student_area);
                $('#student_reference').val(parseData.student_reference).trigger('change');


                if(parseData.lang_preference != '' && parseData.lang_preference != null)
                {
                    $('#student_from_lan_div').show();
                    $('#student_lan_chack_box').val(1);
                    $('#student_lan_chack_box').prop("checked", true);

                    var data = parseData.lang_preference;
                    $.each(data, function (i) {
                        $('.first_' + i).text(data[i]);
                    });
                }
                else
                {
                    $('#student_from_lan_div').hide();
                    $('#student_lan_chack_box').val(0);
                    $('#student_lan_chack_box').prop("checked", false);
                }

                var data2 = $("#sortable").sortable();
                $("#sortable").disableSelection();

                var data = [];
                $('.select2').select2({"allowClear": true});
                document.body.scrollTop = 2;
            }
        });
    },
    viewStudent: function (studentId) {
        $('#add_student_modal').modal("hide");
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'student_master/view_student',
            data: {"student_id": studentId},
            success: function (response) {
                var parseData = JSON.parse(response);
                if (parseData.student_name == '') {
                    parseData.student_name = ' - ';
                }
                if (parseData.student_phone == '') {
                    parseData.student_phone = ' - ';
                }
                if (parseData.student_mobile == '') {
                    parseData.student_mobile = ' - ';
                }
                if (parseData.student_email == '') {
                    parseData.student_email = ' - ';
                }
                if (parseData.student_address == '') {
                    parseData.student_address = ' - ';
                }
                if (parseData.student_area == '') {
                    parseData.student_area = ' - ';
                }
                if (parseData.student_gender == '') {
                    parseData.student_gender = ' - ';
                }
                if (parseData.student_city == '') {
                    parseData.student_city = ' - ';
                }
                if (parseData.student_state == '') {
                    parseData.student_state = ' - ';
                }
                if (parseData.student_country_text == '') {
                    parseData.student_country_text = ' - ';
                }
                if (parseData.student_profession == '') {
                    parseData.student_profession = ' - ';
                }
                if (parseData.student_reference == '') {
                    parseData.student_reference = ' - ';
                }
                if (parseData.lang_preference == '') {
                    parseData.lang_preference = ' - ';
                }
                if (parseData.student_registration_date == '') {
                    parseData.student_registration_date = ' - ';
                }
                if (parseData.student_birthdate == '') {
                    parseData.student_birthdate = ' - ';
                }
                if (parseData.student_interestedin_email == '') {
                    parseData.student_interestedin_email = ' - ';
                }
                if (parseData.student_interestedin_message == '') {
                    parseData.student_interestedin_message = ' - ';
                }
                if (parseData.student_group_tag == '') {
                    parseData.student_group_tag = ' - ';
                }
                if (parseData.student_note == '') {
                    parseData.student_note = ' - ';
                }
                parseData.calling_module = callingModuleView;
                parseData.courseId = courseIdForBackView;


                var discontinueNo = 'display:none;';
                var discontinueYes = '';
                if (parseData.discontinue == GLOBAL_DISCONTINUE_YES) {
                    discontinueNo = '';
                    discontinueYes = 'display:none;';
                }

                var course_id = '96';
                $.each(allCourseData, function (index, value) {
                    if(course_id == value.course_id)
                    {
                        value.course_id_flag = true;
                    }
                    else
                    {
                        value.course_id_flag = false;
                    }
                });

                that.$el.html(studentMasterViewTemlate({"parsedata": parseData,'courses': allCourseData,'discontinue_yes': discontinueYes, 'discontinue_no': discontinueNo, 'GLOBAL_DISCONTINUE_YES': GLOBAL_DISCONTINUE_YES, 'GLOBAL_DISCONTINUE_NO': GLOBAL_DISCONTINUE_NO}));

                $('#view_payment_table').html(paymentTableTemplate());
                Payment.listview.loadPayment(studentId,'student_module');

                $('#view_student_attendance_table').html(studentAttendanceTableListTemplate());
                StudentAttendance.listview.getStudentAttendanceDetail(studentId);

                StudentMaster.listview.getStudentInterestCoursesDetail(studentId);

                StudentMaster.listview.getStudentCallLogList(false,studentId);

                if (parseData.student_reference == 'Other') {
                    $('#other_reference_lbl').show();
                    $('#other_reference_text').show();
                }
                $('#img_name').val(parseData.student_photo);
                if (parseData.student_photo != "") {
                    $('#image_default').hide();
                    $('#profile_images').html('<img src="assets/profile_image/' + parseData.student_photo + '" class="img img-responsive" height="450" width="450" />');
                } else {
                    $('#delete_image_button').hide();
                    $('#image_default').show();
                    $('#profile_images').hide();
                }
            }
        });
    },
    getStudentCallLogList: function (isSearch,studentId) {
        if (isSearch) {
            studentCallLogDataTable.destroy();
        }
        var renderReminderDate = function (data, type, full, meta) {
            if (full.reminder_date == '00-00-0000') {
                 reminder_date = '';
            }
            else
            {
                reminder_date = full.reminder_date ;
            }
            return reminder_date;
        };
        var studentActionRenderer = function(data,type, full, meta) {

            var html = '<label class="fa fa-trash label-btn-icon red" onclick="Interest.listview.deleteCallLog('+full.call_log_id+','+full.student_id+')" style="font-size: 18px;cursor: pointer;top: -9px;right: -9px;color: red;"></label>';

            /*var html ='<button type="button" class="btn btn-xs btn-light-black" onclick="Interest.listview.deleteCallLog('+full.call_log_id+','+full.student_id+')">'+
                            '<label class="fa fa-trash label-btn-icon"></label>'+
                            '&nbsp;<label class="label-btn-fonts">Delete</label>'+
                        '</button>';*/
            return html;
        };
        studentCallLogDataTable = $('#student_all_call_logs_data_table').DataTable({
            "ajax": {
                "url": 'call_log/get_call_log_by_student_id',
                "type": "POST",
                "dataType": 'json',
                "type" : "post",
                "data" : {'student_id': studentId},
                "dataSrc": function ( json ) {
                    return json;
                }
            },
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            "aaSorting": [],
            columns: [
                {data: 'sr_no' },
                {data: 'call_date'},
                {data: 'note'},
                {data: 'course_title'},
                {data: 'reminder_date','render': renderReminderDate},
                {data: 'reminder_date','render': studentActionRenderer},
            ],

        });
    },
    getStudentInterestCoursesDetail: function (studentId) {
         studentIntrestedCoursesListDataTable = $('#student_interested_courses_list_data_table').DataTable({
            "ajax": {
                "url": 'Interest/get_student_interest_data',
                "type": "POST",
                "dataType": 'json',
                "type" : "post",
                "data" : {'student_id': studentId},
                "dataSrc": function ( json ) {

                    var total = 0;
                    json.student_interest_course_data.forEach((element, i) => {
                        total = total+Math.round(element.course_fees);
                    });
                    $('#interest_total').html(Math.abs(total).toFixed(2));
                    return json.student_interest_course_data;
                }
            },
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            "aaSorting": [],
            columns: [
                {data: 'course_id'},
                {data: 'course_title'},
                {data: 'created_date'},
                {data: 'course_fees'},
            ]
        });
        studentIntrestedCoursesListDataTable.on('order.dt search.dt', function () {
            studentIntrestedCoursesListDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
    },
    Payment: function (studentId, enrollmentId, dueAmount) {
        $('#add_payment_container').html(addPaymentTemplate({"student_id": studentId, "enrollment_id": enrollmentId, "due_amounts": dueAmount}));
        renderOptionsForTwoDimensionalArray_payment_mode(paymentModeArray, 'payment_mode', true);
        $('#payment_modal').modal({
            "show": true,
            "backdrop": 'static',
            "keyboard": false});
        $('.payment_date').val(dateTo_DD_MON_YYYY(new Date()));
        $('.payment_date').datepicker({
            'format': 'dd-mm-yyyy',
            autoclose: true
        });
        $('.select2').select2({"allowClear": true});
    },
    paymentSave: function () {
        var paymentFormData = $('#add_payment_from').serializeFormJSON();
        $.ajax({
            type: 'POST',
            url: 'payment/save_payment',
            data: paymentFormData,
            success: function (data) {
                var paymentData = JSON.parse(data);
                $("#payment_modal").modal("hide");
                StudentMaster.listview.viewStudent(paymentFormData.student_id);
            }
        });
    },
    paidPaymentDetails: function (obj) {
        var tr = obj.parents('tr');
        var row = paymentDataTable.row(tr);

        var that = this;
        var detailsIconLink = tr.find('.show-payment-details-control');
        if (row.child.isShown()) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
            detailsIconLink.removeClass('fa-minus').addClass('fa-plus');
        } else {
            // Open this row
            row.child(that.formatPayment(row.data())).show();
            tr.addClass('shown');
            detailsIconLink.removeClass('fa-plus').addClass('fa-minus');
        }
    },
    formatPayment: function (payment_details) {
        // `d` is the original data object for the row
        if (payment_details != undefined) {
            return childPaymentTableTemplate({'payments': payment_details.payment_details});
        }
        return "";
    },
    availableTags: function () {
        $.ajax({
            type: 'POST',
            url: 'student_master/get_all_student_for_tag',
            success: function (data) {
                var availableTags = JSON.parse(data);
                $("#student_group_tag1").autocomplete({
                    source: availableTags
                });
                $("#student_group_tag").autocomplete({
                    source: availableTags
                });
            }
        });
    },
    sendEmailMessage: function (type, title, come_from_module) {
        var checkboxValues = [];
        if (type == 'email') {
            $('input[name=email_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
        }
        if (type == 'message') {
            $('input[name=sms_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
        }
        var message = $('#student_sms_data').val();
        if (message == '') {
            showError('Please enter Message');
            return false;
        }

        var finalData = {
            "sending_type": type,
            "student_array": checkboxValues,
            "title": title,
            "message": message,
            "come_from_module":come_from_module
        };

        if(come_from_module != 'dashboard')
        {
            if ($.isEmptyObject(checkboxValues))
            {
                showError('Plase Select Any ' + title + ' CheckBox');
                return false;
            }
        }

        if (type == 'email') {
            $('#send_shedule_mail_information').hide();
            $('#spinner_send_schedule_mail_btn').html(spinnerTemplate);
            $('#spinner_send_schedule_mail_btn').show();
        }
        if (type == 'message') {
            $('#send_shedule_sms_information').hide();
            $('#spinner_send_schedule_sms_btn').html(spinnerTemplate);
            $('#spinner_send_schedule_sms_btn').show();
        }

        $.ajax({
            type: 'POST',
            url: 'student_master/send_mail_and_sms',
            data: finalData,
            success: function (data) {

                var StudentData = JSON.parse(data);
                if (StudentData.success === false) {
                    showError(StudentData.message);
                    return false;
                }
                showSuccess(StudentData.message);


                if(type == 'message')
                {
                    if(come_from_module == 'student_module')
                    {
                        $('input[id=check_student_message_box]').prop('checked',false);
                        $('input[name=sms_chack_box]').prop('checked',false);
                    }
                    if(come_from_module == 'interest_module')
                    {
                        $('input[id=check_intrested_student_message_box]').prop('checked',false);
                        $('input[name=sms_chack_box]').prop('checked',false);
                    }
                    if(come_from_module == 'enrollment_module')
                    {
                        $('input[id=check_enroll_student_message_box]').prop('checked',false);
                        $('input[name=sms_chack_box]').prop('checked',false);
                    }
                }
                else
                {
                    if(come_from_module == 'student_module')
                    {
                        $('input[id=check_student_email_box]').prop('checked',false);
                        $('input[name=email_chack_box]').prop('checked',false);
                    }
                    if(come_from_module == 'interest_module')
                    {
                        $('input[id=check_intrested_student_email_box]').prop('checked',false);
                        $('input[name=email_chack_box]').prop('checked',false);
                    }
                    if(come_from_module == 'enrollment_module')
                    {
                        $('input[id=check_enroll_student_email_box]').prop('checked',false);
                        $('input[name=email_chack_box]').prop('checked',false);
                    }
                }

                generateTinymce('.tinymce');
                if (type == 'email') {
                    $('#send_shedule_mail_information').show();
                    $('#spinner_send_schedule_mail_btn').hide();
                    $('#send_sms_modal').modal('hide');
                }
                if (type == 'message') {
                    $('#send_shedule_sms_information').show();
                    $('#spinner_send_schedule_sms_btn').hide();
                    $('#send_sms_modal').modal('hide');
                }
            }
        });
    },
    disContinueStudent: function (studentId, status) {
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'student_master/discontinue_student_from_attendance',
            data: {'student_id': studentId,
                'status': status},
            success: function (response) {
                var responseData = JSON.parse(response);
                if (responseData.success == true) {
                    showSuccess(responseData.message);

                    if(status == 1)
                    {
                        $('#continue_btn_' + studentId).show();
                        $('#discontinue_btn_' + studentId).hide();
                    }
                    else
                    {
                        $('#discontinue_btn_' + studentId).show();
                        $('#continue_btn_' + studentId).hide();
                    }

                    studentMasterDataTable.ajax.reload( null, false );
                }
            }
        });
    },
    getMessageData: function (type, title, come_from_module) {
        var checkboxValues = [];
        var is_message = false;
        var is_email = false;
        var title = '';
        if (type == 'message') {
            $('input[name=sms_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
            is_message = true;
            title = 'Send Message';
        }
        if(type == 'email') {
            $('input[name=email_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
            is_email = true;
            title = 'Send Mail';
        }

        if(come_from_module != 'dashboard')
        {
            if ($.isEmptyObject(checkboxValues)) {
                showError('Plase Select Any ' + title + ' CheckBox');
                return false;
            }
        }

        //$('#send_student_message').html(studentScheduleInformation({"message_body": 'SWAD INSTITUE: Your claDATEss is scheduled on {#DATE}, {#DAY} at {#TIME} for {#COURSENAME}. Kindly be present on time.'}));
        $('#send_student_message').html(studentScheduleInformation({"message_body": '',"is_message":is_message,"is_email":is_email,"title":title,"come_from_module":come_from_module}));
        $('#send_sms_modal').modal({"show": true, "backdrop": 'static', "keyboard": false});
    },
    deleteStudent: function (studentId) {
//        getConfirmPassword(function (result) {
//            if (result === false) {
//                return false;
//            }
        //var tempPassword = $('#temp_password').val();
        // if (tempPassword == 'sw@d') {
        $.ajax({
            url: 'student_master/delete_student',
            data: {'student_id': studentId},
            type: "POST",
            success: function (data) {
                var parseData = JSON.parse(data);
                $('#temp_password').val('');
                if (parseData.success === false) {
                    showError(parseData.message);
                    return false;
                }
                $('#student_master_data_table tr[data-id="' + studentId + '"]').hide('slow');
                $('#interested_course_student_data_table tr[data-id="' + studentId + '"]').hide('slow');
                showSuccess(parseData.message);
            }
        });
//            } else {
//                showError("Please Enter Correct Password");
//                $('#temp_password').val('');
//            }
        // });
    },
    viewReminder: function () {
        this.$el.html(reminderListTemplate);
        $('#reminder_table_container').html(reminderListTableTemplate);
        this.loadReminder(false);
    },
    setStudentFollowUp: function (call_log_id,status) {

        $.ajax({
            url: 'student_master/set_followup',
            data: {'call_log_id': call_log_id,'status': status},
            type: "POST",
            success: function (data) {
                var parseData = JSON.parse(data);
                showSuccess(parseData.message);
                if(status == 1)
                {
                    $('#reminder_checkbox_'+call_log_id).attr('onclick','StudentMaster.listview.setStudentFollowUp('+call_log_id+',0)');
                }
                else
                {
                    $('#reminder_checkbox_'+call_log_id).attr('onclick','StudentMaster.listview.setStudentFollowUp('+call_log_id+',1)');
                }

                $('#reminder_total').html(parseData.total_reminder);
                //reminderDataTable.ajax.reload();
                //reminderDataTable.draw(false);

            }
        });
    },
    loadReminder: function (isSearch) {

        search_date = $('#reminder_date').val();
        var searchData = {
            "search_date": search_date
        };
        if (isSearch) {
            reminderDataTable.destroy();
        }



        var viewBtnRenderer = function(data,type, full, meta) {
            var html = '<button type="button" class="btn btn-xs btn-yellow label-icon" style="margin-left: 3px;" onclick="StudentMaster.listview.studentCallDetails($(this));">'+
                        '<label class="fa fa-plus show-call-details-control" style="font-size: 15px;padding-left: 5px;padding-top: 7px;padding-bottom: 1px;padding-right: 4px;"></label>'+
                    '</button>';
            return html;
        };

        var student_FullName_Renderer = function (data, type, full, meta) {

            var fullName ='<a target="_blank" href="main#student/view/'+full.student_id+'" id="student_view_btn">'+
                            '<label class="fa fa-eye label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</a> ';

            fullName += studentFullName(full);

            return fullName;
        };
        var courseTitleRenderer = function (data, type, full, meta) {
            course_name = full.course_title;
            if(full.course_title == '' || full.course_title == null)
            {
                course_name = 'N/A';
            }
            return course_name;
        };
        var checkBoxRenderer = function (data, type, full, meta) {
            if(full.follow_up == 0)
            {
                return '<center><input style="margin: 8px;" type="checkbox" name="reminder_checkbox" onclick="StudentMaster.listview.setStudentFollowUp('+data+',1);" id="reminder_checkbox_' + data + '" value="' + data + '"><label for="reminder_checkbox_' + data + '"></label></center>';
            }
            else
            {
                return '<center><input style="margin: 8px;" type="checkbox" name="reminder_checkbox" onclick="StudentMaster.listview.setStudentFollowUp('+data+',0);" id="reminder_checkbox_' + data + '" value="' + data + '" checked><label for="reminder_checkbox_' + data + '"></label></center>';
            }
        };
        reminderDataTable = $('#reminder_data_table').DataTable({
            ajax: {
                url: 'student_master/get_reminder_data',
                dataSrc: "",
                type: "post",
                data:searchData,
                "dataSrc": function ( json ) {
                    return json;
                }
            },
            bAutoWidth: false,
            ordering: false,
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            stateSave: true,
            'processing': true,
            'language': {
                'loadingRecords': '&nbsp;',
                'processing': 'Loading...'
            },
            columns: [
                {data: 'call_log_id','render':viewBtnRenderer},
                {data: 'call_log_id','render':checkBoxRenderer},
                {data: 'student_first_name','render':student_FullName_Renderer},
                {data: 'call_date'},
                {data: 'course_title','render': courseTitleRenderer},
                {data: 'note'},
                {data: 'reminder_date'},
            ]

        });
    },
    studentCallDetails: function (obj) {
        var tr = obj.parents('tr');
        var row = reminderDataTable.row(tr);
        var that = this;
        var detailsIconLink = tr.find('.show-call-details-control');
        if (row.child.isShown()) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
            detailsIconLink.removeClass('fa-minus').addClass('fa-plus');
        } else {
            // Open this row
            row.child(that.formatCalllog(row.data())).show();
            tr.addClass('shown');
            detailsIconLink.removeClass('fa-plus').addClass('fa-minus');

            var student_id = row.data().student_id;
            Interest.listview.setCallLogTable(student_id);
        }
    },
    setCallLogTable: function(student_id){

        $('#student_call_log_data_table_'+student_id).dataTable().fnDestroy();

        var call_log;
        $.ajax({
            type: 'POST',
            url: 'Call_log/get_call_log_by_student_id',
            dataType: 'json',
            data: {'student_id': student_id},
            async: false,
            success: function (data) {
                call_log = data;
            }
        });

        var studentActionRenderer = function(data,type, full, meta) {

            var html = '<label class="fa fa-trash label-btn-icon red" onclick="Interest.listview.deleteCallLog('+full.call_log_id+','+full.student_id+')" style="font-size: 18px;cursor: pointer;top: -9px;right: -9px;color: red;"></label>';

            /*var html ='<button type="button" class="btn btn-xs btn-light-black" onclick="Interest.listview.deleteCallLog('+full.call_log_id+','+full.student_id+')">'+
                            '<label class="fa fa-trash label-btn-icon"></label>'+
                            '&nbsp;<label class="label-btn-fonts">Delete</label>'+
                        '</button>';*/
            return html;
        };

        var jsonData = call_log;
        studentCallData = $('#student_call_log_data_table_'+student_id).dataTable({
            data: jsonData,
            columns: [
                { data: 'sr_no' },
                { data: 'call_date' },
                { data: 'note' },
                { data: 'course_title' },
                { data: 'reminder_date' },
                {
                    "className": '',
                    "data": 'student_id',
                    "render": studentActionRenderer
                }
            ],
            "bPaginate": false,
            "bInfo" : false,
            "searching": false,
            "language": {
              "emptyTable": "No data available"
            }
        });

    },
    formatCalllog: function (student_detail) {

        if (student_detail != undefined) {
            var course_id = $('#reset_course_id').val();
            if(course_id == '' || course_id == undefined)
            {
                course_id = '96';
            }
            $.each(allCourseData, function (index, value) {
                if(course_id == value.course_id)
                {
                    value.course_id_flag = true;
                }
                else
                {
                    value.course_id_flag = false;
                }
            });
            return studentCalllogTemplate({'student_detail': student_detail,'courses':allCourseData});
        }
        return "";
    }
});
