<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Schedule_model extends CI_Model {

    function create($schedule_data) {
        $this->db->insert('schedule', $schedule_data);
        return $this->db->insert_id();
    }

    function get_schedule_by_date($schedule_from_data, $schedule_to_data) {
        $this->db->select('s.schedule_id,c.course_title,s.schedule_day,s.schedule_from_time,s.schedule_to_time,s.schedule_date,sa.attendance_schedule_id');
        $this->db->where('schedule_date >=', $schedule_from_data);
        $this->db->where('schedule_date <=', $schedule_to_data);
        $this->db->join('course AS c', 'c.course_id = s.schedule_course_id');
        $this->db->join('student_attendance AS sa', 'sa.attendance_schedule_id = s.schedule_id', 'left');
        $this->db->group_by('s.schedule_id');
        return $this->db->get('schedule AS s')->result_array();
    }

    function get_schedule_by_id($schedule_id) {
        $this->db->where('schedule_id', $schedule_id);
        $this->db->join('course AS c', 'c.course_id = s.schedule_course_id');
        return $this->db->get('schedule AS s')->row_array();
    }

    function delete_schedule_by_id($schedule_id) {
        $this->db->where('schedule_id', $schedule_id);
        $this->db->delete('schedule');
    }

    function get_schedule_data_by_date($from_date, $to_date) {
        $this->db->select('*');
        if ($from_date != '' && $to_date != '') {
            $this->db->where('schedule_date >="' . $from_date . '"');
            $this->db->where('schedule_date <="' . $to_date . '"');
        }
        $this->db->order_by("schedule_date", "asc");
        $this->db->from('schedule');
        $resc = $this->db->get();
        return $resc->result_array();
    }

    function get_schedule_arr1($attendance_date,$course_id,$total_day,$schedule_day,$order_by)
    {
        $this->db->select('s.*,c.course_title');
        $this->db->from('schedule as s');
        $this->db->join('course c','c.course_id=s.schedule_course_id','left');
        if($total_day == 1 || $schedule_day == 1)
        {
            $this->db->where('s.schedule_date',$attendance_date);
        }
        else
        {           
            $this->db->where('s.schedule_date <=',$attendance_date);            
        }
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->limit($total_day);
        $this->db->order_by('s.schedule_date '.$order_by);
        $res = $this->db->get();
        return $res->result_array();
    }
    function get_schedule_arr2($attendance_date,$course_id,$total_day)
    {
        $this->db->select('s.*,c.course_title');
        $this->db->from('schedule as s');
        $this->db->join('course c','c.course_id=s.schedule_course_id','left');
        if($total_day == 1)
        {
            $this->db->where('s.schedule_date',$attendance_date);
        }
        else
        {
            $this->db->where('s.schedule_date >=',$attendance_date);
        }            
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->limit($total_day);
        $this->db->order_by('s.schedule_date ASC');
        $res = $this->db->get();
        return $res->result_array();
    }
    function get_last_scheduled($course_id)
    {
        $this->db->select('s.*');
        $this->db->from('schedule as s');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->order_by('s.schedule_id','DESC');
        $res = $this->db->get();
        return $res->row_array();
    }

}

/**
 * EOF: ./application/models/Schedule_model.php
 */
    