<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Interest extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('interest_model');
        $this->load->model('student_master_model');
        $this->load->model('Student_enrollment_model');
        $this->load->model('attendance_model');
        $this->load->model('courses_model');
    }

    function get_student_interest_data() {
        $student_id = $this->input->post('student_id');
        $data['student_data'] = $this->student_master_model->get_by_student_id($student_id);
        $data['student_interest_course_data'] = $this->interest_model->get_student_interest_data_by_student_id($student_id);
        $data['course_group'] = $this->courses_model->get_all_groups();
        echo json_encode($data);
    }

    function save_student_interest() {
        $student_id = $this->input->post('student_id');
        //$this->interest_model->delete_student_interest_old_data($student_id);
        $student_interest_course_data = $this->_get_from_post_student_interest_data();


        //$student_interest_course_data = $this->input->post('interest_course_data');

        // if (empty($student_interest_course_data)) {
        //     echo json_encode(array('success' => TRUE, 'message' => 'Student Interest Saved Successfully'));
        //     return;
        // }  

        $this->add_intrest($student_id,$student_interest_course_data);

        // foreach ($student_interest_course_data as $value) {
        //     $this->interest_model->insert_interest_student_course($value);
        // }

        //$this->interest_model->insert_student_interest_course($student_interest_course_data);
        echo json_encode(array('success' => TRUE, 'message' => 'Student Interest Saved Successfully','data'=>$student_interest_course_data));
    }

    function _get_from_post_student_interest_data() {
        $interest_course_data = $this->input->post('interest_course_data');
        if (empty($interest_course_data)) {
            return;
        }
        foreach ($interest_course_data as &$course_data) {
            if($course_data['created_date'] == '00-00-0000')
            {
                $course_data['created_date'] = date('Y-m-d h:i:s');
            }
            
        }
        return $interest_course_data;
    }

    function add_intrest($student_id,$interested_courses)
    {
        if(empty($interested_courses))
        {
            $this->interest_model->delete_all_intrest($student_id);
        }
        else
        {
            $course_id = implode(',', array_map(function ($entry) {
                return $entry['course_id'];
            }, $interested_courses));

            $course = $this->interest_model->get_other_interest($student_id,$course_id);

            if(!empty($course))
            {
                foreach ($course as $key => $value) {
                    
                    if($value['enrollment_course_id'] == 0)
                    {
                        $this->interest_model->delete_interest($value['student_interest_id']);
                    }
                    else
                    {
                        $this->interest_model->update_interest($value['student_interest_id']);
                    }
                }
            }

            foreach($interested_courses as $key => $value) {

                $value['created_date'] = date_format(date_create($value['created_date']),'Y-m-d');

                $res = $this->interest_model->check_interest($value['student_id'],$value['course_id']);

                if(empty($res))
                {
                    $this->interest_model->add_intrest($value);
                }
                else
                {
                    if($res['enrollment_course_id'] != 0)
                    {
                        $this->interest_model->update_interest($res['student_interest_id']);
                    }
                    else
                    {
                        $res['created_date']=$value['created_date'];
                        $this->interest_model->update_interest_time($res);
                    }
                }
            }
        }                
    }

    function get_student_interested_data() {
        $course_id = $this->input->post('course_id');
        $status = $this->input->post('status');   


        // $course_id = 2;
        // $status = 0;


        $result = array();

        if($status == 2)
        {
            $res = $this->Student_enrollment_model->get_enrolled_student($course_id);
            
            // echo $this->db->last_query();

            // echo "<pre>";
            // print_r($res);
            // exit;

            $result = array();            
            foreach ($res as $row) {

                if($row['student_id'] != '')
                {
                    //$select = $this->interest_model->check_intrest($course_id,$row['student_id']);
                    $select = $this->interest_model->check_intrest_for_intrested_list($course_id,$row['student_id']);
                    if(empty($select))
                    {
                        $result[]=$row;
                    }
                    else
                    {  
                       if($select['status'] == 0)
                       {
                            $result[]=$row;
                       }
                    }
                }
            }
        }
        else
        {
            $result = $this->interest_model->get_student_interested_data_by_course_id($course_id,$status);
        }  


        // echo "<pre>";
        // print_r($result);
        // exit;

        echo json_encode($result);
    }

    function get_detail_for_confirm() {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');        
        $result = $this->interest_model->get_detail_for_confirm($student_id,$course_id);
        echo json_encode($result);
    }

    function confirm_student_to_course() {


        $data['student_id'] = $this->input->post('student_id');
        $data['course_id'] = $this->input->post('course_id');
        $data['checkbox'] = $this->input->post('checkbox');
        $data['food_type'] = $this->input->post('food_type');
        $data['enrollment_course_id'] = $this->input->post('enrollment_course_id');
        $data['languageData'] =json_encode($this->input->post('languageData'));

        if($data['checkbox'] == 0)
        {
            $data['languageData'] = '';
        }
        $this->student_master_model->update_language($data['student_id'],$data['languageData']);

        $res['student_id'] = $data['student_id'];
        $res['course_id'] = $data['course_id'];
        $res['food_type'] = $data['food_type'];
        $res['enrollment_course_id'] = $data['enrollment_course_id'];
        $res['status'] = CONFIRM;
        $res['is_delete'] = 0;
        $res['created_date'] = date('Y-m-d h:i:s');

        //$this->interest_model->confirm_student_to_course($res,0);
        $this->interest_model->confirm_student_to_course_by_validate($res,$data['enrollment_course_id']);
        echo json_encode(array('success' => true, 'message' => 'Student Confirmed'));
    }

    function reset_to_waiting() {

        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $enrollment_course_id = $this->input->post('enrollment_course_id');
        $student_interest_id = $this->input->post('student_interest_id');
        $this->interest_model->reset_student_to_waiting($student_id,$course_id,$enrollment_course_id,$student_interest_id);
        echo json_encode(array('success' => true, 'message' => 'Student is moved to Waiting List'));
    }

    function reset_confirm_list() {

        $course_id = $this->input->post('course_id');
        $this->interest_model->reset_confirm_list($course_id);
        echo json_encode(array('success' => true, 'message' => 'Reset Successfully'));
    }

    function remove_student_from_course() {

        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $res = $this->interest_model->remove_student_from_course($student_id,$course_id);
        if($res==true)
        {
            echo json_encode(array('success' => true, 'message' => 'Student Removed'));
        }
        else
        {
            echo json_encode(array('success' => false, 'message' => 'Enrollment exist'));
        }
        
    }    
    
    function set_interest_to_next_class()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $this->interest_model->set_interest_to_next_class($student_id,$course_id);
        echo json_encode(array('success' => true, 'message' => 'Added To Next'));
    }
    function remove_interest_from_next_class()
    {
        $student_id = $this->input->post('student_id');
        $course_id = $this->input->post('course_id');
        $this->interest_model->remove_interest_from_next_class($student_id,$course_id);
        echo json_encode(array('success' => true, 'message' => 'Removed From Next'));
    }   

}

/*
 * EOF: ./application/controllers/Login.php
 */
