<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Custom_report extends CI_Controller {

    public function __construct() {
        parent::__construct();
        check_authenticated();
        $this->load->model('schedule_model');
        $this->load->model('custom_report_model');
    }

    function get_schedule_record_by_date() {
        $from_date = new DateTime($this->input->post('from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $to_date->modify('+1 day');
        $new_to_date = $to_date->format('Y-m-d');

        //loop for from date to todate
        $begin = new DateTime($new_from_date);
        $end = new DateTime($new_to_date);
        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);
        $main_array = array();
        foreach ($period as $dt) {
            $date = $dt->format("Y-m-d");
            $result = $this->custom_report_model->get_total_collected_payment_by_course($date);
            if (!empty($result)) {
                $sub_total = 0;
                foreach ($result as &$r) {
                    if (!$r['amount']) {
                        $r['amount'] = 0;
                    }
                    $sub_total += $r['amount'];
                }
                $payment_data_array = array();
                $payment_data_array['schedule_date'] = $dt->format("d-m-Y");
                $payment_data_array['sub_totals'] = $sub_total;
                $payment_data_array['course_and_payment_data'] = $result;
                array_push($main_array, $payment_data_array);
            }
        }
        echo json_encode($main_array);
    }

//    function get_total_collected_payment_by_course() {
//        $result = $this->custom_report_model->get_total_collected_payment_by_course();
//        echo json_encode($result);
//    }
}

/**
     * EOF: ./application/controllers/Courses.php
     */
    