var scheduleListTemplate = Handlebars.compile($('#schedule_list_template').html());
var scheduleSearchTemplate = Handlebars.compile($('#schedule_search_template').html());
var scheduleRowTemplate = Handlebars.compile($('#schedule_row_template').html());
var scheduleDayTemplate = Handlebars.compile($('#schedule_day_template').html());
var scheduleDayCustomTemplate = Handlebars.compile($('#schedule_day_custom_template').html());
var Schedule = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
Schedule.Router = Backbone.Router.extend({
    routes: {
        'schedule/list': 'renderList'
    },
    renderList: function () {
        Schedule.listview.listPage();
    }
});
Schedule.listView = Backbone.View.extend({
    el: 'div#main_container',
    listPage: function () {
        this.$el.html(scheduleListTemplate);
        $('.date_picker').datetimepicker({
            format: 'dd-mm-yyyy'
        });
        $('#schedule_from_date').val(dateTo_DD_MON_YYYY(new Date()));
        $('#schedule_to_date').val(dateTo_DD_MON_YYYY(new Date()));
        renderOptionsForTwoDimensionalArrayWithKeyValue(allCourseData, 'schedule_custom_course_id', 'course_id', 'course_title');
        $('.select2').select2();
        $(".timepicker").timepicker({
            showInputs: true
        });
    },
    generatePdfSchedule: function () {
        var fromDate = ddmmyyToDate($('#schedule_from_date').val());
        var toDate = ddmmyyToDate($('#schedule_to_date').val());
        var firstDay = new Date(fromDate.getFullYear(), fromDate.getMonth(), 1);
        var lastDay = new Date(fromDate.getFullYear(), fromDate.getMonth() + 1, 0);
        if (fromDate > toDate) {
            showError('Please Select To Date greater Than From Date');
            return false;
        }
        if (!(fromDate >= firstDay && fromDate <= lastDay)) {
            showError('From Date and To Date must be of same month1');
            return false;
        }
        if (!(toDate >= firstDay && toDate <= lastDay)) {
            showError('From Date and To Date must be of same month');
            return false;
        }
        $('#from_date').val(dateTo_YYYY_MM_DD(fromDate));
        $('#to_date').val(dateTo_YYYY_MM_DD(toDate));
        $('#print_schedule_form').submit();
    },
    searchSchedule: function () {
        var that = this;
        var fromDate = ddmmyyToDate($('#schedule_from_date').val());
        var fromDateForLoop = ddmmyyToDate($('#schedule_from_date').val());
        var toDate = ddmmyyToDate($('#schedule_to_date').val());
        if (fromDate.getTime() > toDate.getTime()) {
            showError('Please Select ToDate Grater Than FromDate');
            return false;
        }
        fromDate = fromDate.setHours(0, 0, 0, 0);
        toDate = toDate.setHours(0, 0, 0, 0);
        var diffDays = parseInt((toDate - fromDate) / (1000 * 60 * 60 * 24));
        if (diffDays > 32) {
            showError('Please Select Only One Month');
            return false;
        }
        $('#schedule_btn').hide();
        $('#spinner_schedule_btn').show();
        var mainCounter = null;
        var ScheduleDate = '';
        var scheduleDateForDB = '';
        var counter = 1;
        var appendCounter = 1;
        $('#schedule_search_container').html('');
        for (var d = fromDateForLoop; d <= toDate; d.setDate(d.getDate() + 1)) {
            mainCounter = dateTo_DD_MM_YYYYWithID(d);
            ScheduleDate = changeDateFormatForSchedule(d);
            scheduleDateForDB = dateTo_YYYY_MM_DD(d);
            if ((counter % 3) == 1) {
                $('#schedule_search_container').append('<div class="col-md-12" id="container_for_schedule_blocks_' + counter + '"></div>');
                appendCounter = counter;
            }
            $('#container_for_schedule_blocks_' + appendCounter).append(scheduleSearchTemplate({'schedule_date_for_db': scheduleDateForDB, 'schedule_date': ScheduleDate, 'main_counter': mainCounter}));
            that.loadCourse(mainCounter);
            $(".timepicker").timepicker({
                showInputs: true
            });
            $('.select2').select2();
            counter++;
        }
        that.scheduleRowData($('#schedule_from_date').val(), $('#schedule_to_date').val());
        $('#schedule_btn').show();
        $('#spinner_schedule_btn').hide();
    },
    scheduleRowData: function (fromDate, toDate) {
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'schedule/get_schedule_data_by_date',
            data: {
                "schedule_from_date": fromDate,
                "schedule_to_date": toDate
            },
            success: function (data) {
                var parseData = JSON.parse(data);
                var scheduleDate = parseData.schedule_data;
                $.each(scheduleDate, function (index, scheduleRowData) {
                    if (scheduleRowData.attendance_schedule_id == null) {
                        scheduleRowData.attendance_schedule_id = 0;
                    }
                    that.addScheduleRow(scheduleRowData, dateTo_DD_MM_YYYYWithID(ddmmyyToDate(scheduleRowData.schedule_date)));
                });
            }
        });
    },
    addScheduleRow: function (data, cnt) {
        var templateData = {
            'main_counter': cnt,
            'schedule_id': data.schedule_id,
            'course_title': data.course_title,
            'schedule_day': data.schedule_day,
            'schedule_from_time': convert24To12Hours(data.schedule_from_time),
            'schedule_to_time': convert24To12Hours(data.schedule_to_time),
            'schedule_date': data.schedule_date,
            'attendance_schedule_id': data.attendance_schedule_id
        };
        var result = scheduleRowTemplate(templateData);
        $('#schedule_row_table_' + cnt).append(result);
    },
    coursesOnChange: function (itemId) {
        var course_id = $('#schedule_course_id_' + itemId).val();
        var date = $('#schedule_date_for_db_' + itemId).val();
        if (course_id != '') {
            var courseDuration = allCourseData[course_id]['course_duration'];
            $('#select_date_' + itemId).html('');
            var ScheduleDate = '';
            var dateobj = null;
            for (var i = 1; i <= courseDuration; i++) {
                ScheduleDate = changeDateFormatForSchedule(date);
                var data = {
                    'day_cnt': i,
                    "day_name": ScheduleDate.dayname
                };
                var result = scheduleDayTemplate(data);
                $('#select_date_' + itemId).append(result);
                dateobj = new Date(date);
                dateobj.setDate(dateobj.getDate() + 1);
                date = dateTo_YYYY_MM_DD(dateobj);
            }
        }
    },
    coursesOnchangeCustom: function () {
        var course_id = $('#schedule_custom_course_id').val();
        if (course_id != '') {
            var courseDuration = allCourseData[course_id]['course_duration'];
            $('#schedule_custom_container').html('');
            for (var i = 1; i <= courseDuration; i++) {
                var data = {
                    'day_cnt': i
                };
                var result = scheduleDayCustomTemplate(data);
                $('#schedule_custom_container').append(result);
                $('#schedule_custom_date_' + i).val(dateTo_DD_MON_YYYY(new Date()));
                $('.date_picker').datetimepicker({
                    format: 'dd-mm-yyyy'
                });
                $(".timepicker").timepicker({
                    showInputs: true
                });
            }
        }
    },
    loadCourse: function (mainCounter) {
        renderOptionsForTwoDimensionalArrayWithKeyValue(allCourseData, 'schedule_course_id_' + mainCounter, 'course_id', 'course_title');
    },
    saveSchedule: function (mainCounter) {
        var scheduleFormData = $('#add_schedule_from_' + mainCounter).serializeFormJSON();
        var course_id = $('#schedule_course_id_' + mainCounter).val();
        var ScheduleDate = $('#schedule_date_for_db_' + mainCounter).val();
        if (course_id == '') {
            showError('Select Any Course !');
            $('#schedule_course_id_' + mainCounter).focus();
            return false;
        }
        var scheduleFromTime = changeTimeFormat((scheduleFormData.schedule_from_time).trim());
        var scheduleToTime = changeTimeFormat((scheduleFormData.schedule_to_time).trim());
        if (scheduleFromTime >= scheduleToTime) {
            showError('Select TO time greater than FROM time');
            return false;
        }
        var courseDuration = allCourseData[course_id]['course_duration'];
        var dateobj = null;
        var mainDataArray = [];
        var scheduleData = {};
        var scheduleCounter = 1;
        dateobj = new Date(ScheduleDate);
        for (var i = 1; i <= courseDuration; i++) {
            scheduleData = {};
            if ($('#schedule_day_' + i).is(':checked')) {
                scheduleData.schedule_date = ScheduleDate;
                scheduleData.schedule_from_time = changeTimeFormat((scheduleFormData.schedule_from_time).trim());
                scheduleData.schedule_to_time = changeTimeFormat((scheduleFormData.schedule_to_time).trim());
                scheduleData.schedule_day = scheduleCounter;
                scheduleData.schedule_course_id = $('#schedule_course_id_' + mainCounter).val();
                mainDataArray.push(scheduleData);
            }
            scheduleCounter++;
            dateobj.setDate(dateobj.getDate() + 1);
            ScheduleDate = dateTo_YYYY_MM_DD(dateobj);
        }
        if ($.isEmptyObject(mainDataArray)) {
            showError('Select Atleast One Day !');
            return false;
        }
        var that = this;
        $('#save_schedule_btn').hide();
        $('#schedule_processing_btn').show();
        $.ajax({
            type: 'POST',
            url: 'schedule/save_schedule',
            data: {'schedule_data': mainDataArray},
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData.success == false) {
                    showError(parseData.message);
                    return false;
                }
                showSuccess(parseData.message);
                $.each(parseData.schedule_data, function (index, scheduleRowData) {
                    var counter = dateTo_DD_MM_YYYYWithID(new Date(ddmmyyToDate(scheduleRowData.schedule_date)));
                    that.addScheduleRow(scheduleRowData, counter);
                });
                $('.schedule_from').each(function () {
                    var that = $(this);
                    var itemId = that.find('.counter').val();
                    that.find('.schedule_course_id').val('').trigger('change');
                    $('#select_date_' + itemId).html('');
                });
                $('#save_schedule_btn').show();
                $('#schedule_processing_btn').hide();
            }
        });
    },
    deleteSchedule: function (scheduleId, mainCounter, scheduleDate, attendanceScheduleId) {
        getConfirm(function (result) {
            if (result === false) {
                return false;
            }
            if (attendanceScheduleId != 0) {
                showError('Schedule can not be deleted as it is attended by someone');
                return false;
            }
            $.ajax({
                type: 'post',
                url: 'schedule/delete_schedule',
                data: {
                    "schedule_id": scheduleId
                },
                success: function (data) {
                    var parseData = JSON.parse(data);
                    if (parseData.success == false) {
                        return false;
                    }
                    showSuccess(parseData.message);
                    $('#schedule_row_' + scheduleId).remove();
                }
            });
        });
    },
    saveCustomSchedule: function () {
        var mainDataArray = [];
        var scheduleData = {};

        if ($('#schedule_custom_course_id').val().trim() == '') {
            showError('Please select a Course');
            return false;
        }

        var scheduleCustomCourseId = $('#schedule_custom_course_id').val();
        $('.custom_schedule').each(function () {
            scheduleData = {};
            if ($(this).find('.schedule_date').val().trim() != '') {
                scheduleData.schedule_date = dateTo_YYYY_MM_DD(ddmmyyToDate($(this).find('.schedule_date').val()));
                scheduleData.schedule_from_time = changeTimeFormat($(this).find('.schedule_from_time').val());
                scheduleData.schedule_to_time = changeTimeFormat($(this).find('.schedule_to_time').val());
                scheduleData.schedule_day = $(this).find('.schedule_day').val();
                scheduleData.schedule_course_id = scheduleCustomCourseId;
                mainDataArray.push(scheduleData);
            }
        });
        console.log(mainDataArray);
        $.ajax({
            type: 'POST',
            url: 'schedule/save_schedule',
            data: {'schedule_data': mainDataArray},
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData.success == false) {
                    showError(parseData.message);
                    return false;
                }
                showSuccess(parseData.message);
            }});
    }
});