<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_enrollment_model extends CI_Model {

    function save_enrollment($student_enrollment) {
        $student_enrollment['enrollment_created_by'] = get_from_session('ccm_user_id');
        $this->db->insert('enrollment', $student_enrollment);
        return $this->db->insert_id();
    }

    function save_enrollment_course($student_enrollment_course) {
        $this->db->insert('enrollment_course', $student_enrollment_course);
        return $this->db->insert_id();
    }

    function get_discount($no_of_course) {
        $sql = "SELECT * FROM package where (no_of_course + no_of_free_course)='" . $no_of_course . "' AND (validity>=CURDATE() OR validity = '1970-01-01')";
        $recs = $this->db->query($sql);
        return $recs->row_array();
    }

    function get_enrollment_details($student_id, $from_date, $to_date, $validity_date) {
        $this->db->select('e.enrollment_id ,DATE(e.enrollment_created_date) AS enrollment_created_date,DATE(e.enrollment_validity_date) AS enrollment_validity_date,e.student_id,e.sub_total,sum(p.payment_amount) as payment_amount,e.due_amounts,e.discount,e.enrollment_yearly_membership');
        $this->db->from('enrollment as e');
        $this->db->join('payment p', 'e.enrollment_id=p.enrollment_id', 'left');
        $this->db->where('e.student_id', $student_id);
        $this->db->where('e.is_delete', ISDELETEYES);
        if ($from_date != '') {
            $this->db->where('enrollment_created_date >="' . $from_date . ' 00:00:00"');
        }
        if ($to_date != '') {
            $this->db->where('enrollment_created_date <="' . $to_date . ' 23:59:59"');
        }
        if ($validity_date != '') {
            $this->db->where('enrollment_validity_date', $validity_date);
        }
        $this->db->group_by('e.enrollment_id,p.student_id');
        $this->db->order_by('e.enrollment_created_date', 'desc');
        return $this->db->get()->result_array();
    }

    function get_enrollment_course_details($enrollment_id) {
        $this->db->select('c.course_title,c.course_id,c.course_fees,ec.enrollment_course_amount');
        $this->db->from('course AS c');
        $this->db->join('enrollment_course AS ec', 'ec.course_id=c.course_id');
        $this->db->join('enrollment AS e', 'e.enrollment_id=ec.enrollment_id');
        $this->db->where('e.enrollment_id', $enrollment_id);
        return $this->db->get()->result_array();
    }

    function get_enrollment_detail_by_id($enrollment_id) {
        $this->db->select('e.enrollment_id,DATE(e.enrollment_created_date) AS enrollment_created_date,DATE(e.enrollment_validity_date) AS enrollment_validity_date,e.sub_total,e.enrollment_yearly_membership,sum(p.payment_amount) as payment_amount,e.due_amounts,e.discount,'
                . 'e.additional_discount_percentage,e.additional_discount_amount,e.total_discount,e.payable_amount,e.enrollment_discount_note');
        $this->db->from('enrollment AS e');
        $this->db->join('payment AS p', 'p.enrollment_id=e.enrollment_id', 'left');
        $this->db->where('e.enrollment_id', $enrollment_id);
        $this->db->group_by('e.enrollment_id');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function enrollment_course_detail_by_id($enrollment_id) {
        $this->db->select('enrollment_id,course_id,enrollment_course_id,enrollment_course_name,enrollment_course_amount');
        $this->db->from('enrollment_course');
        $this->db->where('enrollment_id', $enrollment_id);
        return $this->db->get()->result_array();
    }

    function update_enrollment($enrollment_data, $enrollment_id) {
        $enrollment_data['enrollment_updated_date'] = date('Y-m-d h:i:s');
        $enrollment_data['enrollment_updated_by'] = get_from_session('ccm_user_id');
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->update('enrollment', $enrollment_data);
    }

    function delete_old_enrollment_course($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->delete('enrollment_course');
    }

    function get_enrollment_validity($package_validity_no) {
        $this->db->where('(no_of_course + no_of_free_course)=', $package_validity_no);
        $this->db->where('validity >=', 'CURDATE()', FALSE);
        return $this->db->get('package')->row_array();
    }

    function check_enrollment_payment_exist($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        return $this->db->get('payment')->result_array();
    }

    function delete_enrollment_course($enrollment_id) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->delete('enrollment_course');
    }

    function delete_enrollment($enrollment_id, $enrollment_data) {
        $this->db->where('enrollment_id', $enrollment_id);
        $this->db->update('enrollment', $enrollment_data);
    }

    function get_all_enrollment_details() {
        $resc = $this->db->get('enrollment');
        return $resc->result_array();
    }

    function calculate_student_course_revenue($enrollment_id) {
        $this->db->select('count(ec.enrollment_course_id) as no_of_courses,sum(enrollment_course_amount)/count(ec.enrollment_course_id) as average_amount');
        $this->db->from('enrollment AS e');
        $this->db->join('enrollment_course AS ec', 'ec.enrollment_id=e.enrollment_id');
        $this->db->where('e.enrollment_id', $enrollment_id);
        return $this->db->get()->row_array();
    }

    function check_enrollment_exist($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->where('is_delete', ISDELETEYES);
        $result = $this->db->get('enrollment');
        return $result->result_array();
    }

    function get_enrollment_details_by_id($course_id, $student_id) {
        $this->db->where('ec.course_id', $course_id);
        $this->db->where('e.student_id', $student_id);
        $this->db->join('enrollment_course as ec', 'ec.enrollment_id = e.enrollment_id');
        $this->db->order_by('e.enrollment_created_date');
        return $this->db->get('enrollment as e')->result_array();
    }

}

/**
 * EOF: ./application/models/Courses_model.php
 */
