<?php

class Main extends CI_Controller {

    public function __construct() {
        parent::__construct();
        check_authenticated();
        $this->load->model('courses_model');
        $this->load->model('config_model');
        $this->load->model('call_log_model');
    }

    public function index() {
        $data['allCourseData'] = json_encode(generate_array_for_id_object($this->courses_model->is_course_exist(), 'course_id'));
        $result = generate_array_for_id_object($this->config_model->get_all_data(), 'config_key');
        $data['package_validity_duration'] = json_encode($result['PACKAGE_VALIDITY_DURATION']['config_value']);
        $data['total_reminder'] = $this->call_log_model->get_total_reminder()['total_reminder']; 
        $this->load->view('common/header', $data);
        $this->load->view('main/main');
        $this->load->view('common/footer');
        $this->load->view('common/backbone_footer');
    }

    function check_authenticated_for_ajax() {
        $session_msg = check_session();
        if ($session_msg != '') {
            echo json_encode(array('success' => false, 'message' => $session_msg));
        } else {
            echo json_encode(array('success' => true, 'message' => ""));
        }
    }

}
