<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cron_ccm extends CI_Controller {

    public function __construct() {
        parent::__construct();
        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('cron_ccm_model');
        $this->load->model('attendance_model');
        $this->load->model('interest_model');
    }   

    function send_birthday_wish() {
        $month = date("m");
        $day = date("d");
        $student = $this->cron_ccm_model->get_birthday_students($month,$day);

        $this->load->model('config_model');
        $message = $this->config_model->get_config_value('BIRTHDAY_WISH_MESSAGE_FORMAT')['config_value'];

        if(!empty($student))
        {

            $message_type = "BIRTHDAY MESSAGE ".date('d-M-Y h:i:s');
            $this->append_text($message_type,'');

            foreach ($student as $row) 
            {
                $student_name = $row['student_first_name'].' '.$row['student_last_name'];
                $send_message = str_replace("{student_name}",$student_name,$message);
                $send_message = strip_tags($send_message);

                if($row['student_interestedin_email'] == YES && $row['student_email'] != '')
                {                    
                    $row['student_message'] = $send_message;
                    //$this->_send_birthday_mail($row);
                }
                
                if($row['student_interestedin_message'] == YES && $row['student_mobile'] != '')
                {
                    $student_mobile = $row['student_mobile'];
                    //send_SMS($send_message, $student_mobile);
                    $this->append_text('',$send_message);
                }
            }
        }     
    }
    function _send_birthday_mail($data) {
        $data['subject'] = 'SWAD INSTITUTE NOTIFICATION';
        $this->load->library('email');
        $email = ($data['student_email']);
        send_email($data, $email);
    }    
    function send_schedule_msg()
    {
        $today = date('Y-m-d');       
        
        $schedule = $this->attendance_model->get_course_schedule($today);

        $main_attendance = array();

        foreach ($schedule as $value) {

            if($value['schedule_day'] == 1)
            {
                $attendance = array();
                
                $result = $this->cron_ccm_model->get_student_for_message($value['course_id'],$value['schedule_id'],$today);

                $main_array = array();

                 foreach ($result as $course_data) {

                    $student_id = $course_data['student_id'];
                    $course_data['course_duration'] = 0;
                    $course_duration = $this->attendance_model->get_course_duration_by_student($value['schedule_id'], $course_data['enrollment_id']);
                    if (!empty($course_duration)) {
                        $course_data['course_duration'] = $course_duration['total_course_duration'];
                    }

                    $course_data['student_attendance'] = 0;
                    $student_attendance = $this->attendance_model->get_attendence_by_student($value['course_id'], $course_data['enrollment_id']);
                    if (!empty($student_attendance)) {
                        $course_data['student_attendance'] = $student_attendance['total_attendance'];
                    }

                    $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $today, $course_data['enrollment_id']);               
                    if (empty($attendance_data)) {
                        $course_data['absent_or_present'] = NO;                    
                        if ($course_data['student_attendance'] == 0) {
                            array_push($main_array, $course_data);
                        }                 
                    } else {
                        $course_data['absent_or_present'] = YES;
                    }

                    $select_confirm = $this->interest_model->get_confirm_student($value['course_id']);

                    $select_confirm1 = array(); 

                    foreach ($main_array as $r) {

                        $res = $this->interest_model->check_intrest($value['course_id'],$r['student_id']);

                        if(!empty($res))
                        {
                            if($res['status'] == 1)
                            {
                                $select_confirm1[]=$r;
                            }
                        }
                    }
                    $new_main_array = array_merge($select_confirm1,$select_confirm);
                }
                $row['course']=$value;
                $row['student']=$new_main_array;
                $main_attendance[] = $row;
            }
        }

        $this->load->model('config_model');
        $message = $this->config_model->get_config_value('SCHEDULE_MESSAGE_FORMAT')['config_value'];

        if(!empty($main_attendance))
        {
            foreach ($main_attendance as $r) {

                $course_title = $r['course']['course_title'];
                $from_time = date('h:i A', strtotime($r['course']['schedule_from_time'].' '.$today));
                $to_time = date('h:i A', strtotime($r['course']['schedule_to_time'].' '.$today));     

                $message_type = "SCHEDULE MESSAGE ".$course_title." ".date('d-M-Y h:i:s')." (".$from_time." TO ".$to_time.")";
                $this->append_text($message_type,'');                                       
                
                if(!empty($r['student']))
                {
                    foreach($r['student'] as $stud)
                    {
                        $student_name = $stud['student_first_name'].' '.$stud['student_last_name'];
                        $send_message = str_replace("{student_name}",$student_name,$message);
                        $send_message = str_replace("{course_title}",$course_title,$send_message);
                        $send_message = str_replace("{from_time}",$from_time,$send_message);
                        $send_message = str_replace("{to_time}",$to_time,$send_message);
                        $send_message = strip_tags($send_message);
                        //send_SMS($send_message, $stud['student_mobile']);
                        //echo $send_message.'<br><br>';
                        $this->append_text('',$send_message);
                    }                   
                }
            }
        }
    }
    function send_feedback_msg()
    {
        $today = date('Y-m-d');
        
        $schedule = $this->attendance_model->get_course_schedule($today);

        $main_attendance = array();

        foreach ($schedule as $value) {

            if($value['course_duration'] == $value['schedule_day'])
            {

                $attendance = array();
                
                $result = $this->cron_ccm_model->get_student_for_message($value['course_id'],$value['schedule_id'],$today);

                $main_array = array();

                 foreach ($result as $course_data) {

                    $student_id = $course_data['student_id'];
                    $course_data['course_duration'] = 0;
                    $course_duration = $this->attendance_model->get_course_duration_by_student($value['schedule_id'], $course_data['enrollment_id']);
                    if (!empty($course_duration)) {
                        $course_data['course_duration'] = $course_duration['total_course_duration'];
                    }

                    $course_data['student_attendance'] = 0;
                    $student_attendance = $this->attendance_model->get_attendence_by_student($value['course_id'], $course_data['enrollment_id']);
                    if (!empty($student_attendance)) {
                        $course_data['student_attendance'] = $student_attendance['total_attendance'];
                    }

                    $attendance_data = $this->attendance_model->get_student_present_or_absent($student_id, $value['schedule_id'], $today, $course_data['enrollment_id']);               
                    if (!empty($attendance_data)) 
                    {               
                        $course_data['absent_or_present'] = YES;
                        array_push($main_array, $course_data);   
                    }
                }

                $row['course']=$value;
                $row['student']=$main_array;
                $main_attendance[] = $row;
            }

        }       

        date_default_timezone_set('Asia/Kolkata');
        $this->load->model('config_model');
        $message = $this->config_model->get_config_value('FEEDBACK_MESSAGE_FORMAT')['config_value'];

        if(!empty($main_attendance))
        {
            foreach ($main_attendance as $r) {

                
                $course_title = $r['course']['course_title'];
                $from_time = date('h:i A', strtotime($r['course']['schedule_from_time'].' '.$today));
                $to_time = date('h:i A', strtotime($r['course']['schedule_to_time'].' '.$today));

                $message_type = "FEEDBACK MESSAGE ".$course_title." ".date('d-M-Y h:i:s')." (".$from_time." TO ".$to_time.")";
                $this->append_text($message_type,'');   

                $current_time  = date("H:i:s");
                $current_half_hour  = date("H:i:s", strtotime('+30 minutes'));

                if($current_time <= $r['course']['schedule_to_time'] && $current_half_hour >= $r['course']['schedule_to_time'])
                {
                    if(!empty($r['student']))
                    {
                        foreach($r['student'] as $stud)
                        {
                            $student_name = $stud['student_first_name'].' '.$stud['student_last_name'];
                            $send_message = str_replace("{student_name}",$student_name,$message);
                            $send_message = str_replace("{course_title}",$course_title,$send_message);
                            $send_message = str_replace("{from_time}",$from_time,$send_message);
                            $send_message = str_replace("{to_time}",$to_time,$send_message);
                            $send_message = strip_tags($send_message);                            
                            //send_SMS($send_message, $stud['student_mobile']);
                            //echo $send_message.'<br><br>';
                            $this->append_text('',$send_message);
                        }
                    }
                }
                else
                {
                    $this->append_text('','not send right now');
                    //echo 'not send right now';
                }
            }
        }
    }
    function append_text($message_type='',$message='')
    {
        $file = APPEND_FILE_PATH;

        if($message_type != '')
        {
            file_put_contents($file,"<----------------------------- ".$message_type." ----------------------------->\n".PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        else
        {
            file_put_contents($file,$message."\n".PHP_EOL , FILE_APPEND | LOCK_EX);
        }        
    }    
    //for add interest
    function set_intrest()
    {
        $result = $this->cron_ccm_model->get_enroll_student();

        foreach ($result as $key => &$value) {
                
            $student_attendance = $this->cron_ccm_model->get_attendance($value['enrollment_id'],$value['course_id'],$value['student_id']);

            if($student_attendance)
            {
                $value['attend_day'] = count($student_attendance);
                if(count($student_attendance) > 0)
                {
                    //echo "ss<pre>";
                    //print_r($value);
                    $this->cron_ccm_model->set_interest($value['course_id'],$value['student_id'],$value['enrollment_course_id']);
                }
            }            
            
        }
    }
    function get_invoice_no()
    {
        $res = $this->cron_ccm_model->get_invoice_no(2019,05);
        $c = 1;
        foreach ($res as $key => $value) {
            $this->cron_ccm_model->set_invoice_no($value['payment_id'],$c);
            $c++;
        }

        $res = $this->cron_ccm_model->get_invoice_no(2019,06);
        $c = 1;
        foreach ($res as $key => $value) {
            $this->cron_ccm_model->set_invoice_no($value['payment_id'],$c);
            $c++;
        }
    }
}
