<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Config extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('config_model');
        check_authenticated();
    }

    function update_config() {
        $header_data = $this->input->post('header_template');
        $footer_data = $this->input->post('footer_template');
        $back_data = $this->input->post('back_template');
        $header_template['config_value'] = $header_data;
        $footer_template['config_value'] = $footer_data;
        $back_template['config_value'] = $back_data;
        $this->config_model->update_config('HEADER_TEMPLATE', $header_template);
        $this->config_model->update_config('FOOTER_TEMPLATE', $footer_template);
        $this->config_model->update_config('BACK_TEMPLATE', $back_template);
        echo json_encode(array('success' => TRUE, 'message' => 'Configuration Template Updated Successfully'));
    }

    function get_all_data() {
        $result = generate_array_for_id_object($this->config_model->get_all_data(), 'config_key');
        echo json_encode($result);
    }

    function update_discount() {
        $discount_data = $this->input->post('discount_template_from');
        $json_data['config_value'] = json_encode($discount_data);
        $this->config_model->update_config('YEARLY_MEMBER', $json_data);
        echo json_encode(array('success' => TRUE, 'message' => 'Discount Updated Successfully'));
    }

    function update_package_validity() {
        $package_data = $this->input->post('package_template_from');
        $pack_data['config_value'] = json_encode($package_data);
        $this->config_model->update_config('PACKAGE_VALIDITY_DURATION', $pack_data);
        $result = generate_array_for_id_object($this->config_model->get_all_data(), 'config_key');
        $data = json_encode($result['PACKAGE_VALIDITY_DURATION']['config_value']);
        echo json_encode(array('success' => TRUE, 'message' => 'Package Validity Updated Successfully!', 'package_validity_data' => $data));
    }

    function update_other_config() {
        $smtp_setting_data = $this->input->post('other_configuration_smtp_template_form');
        $sms_configuration_data = $this->input->post('other_configuration_sms_template_form');
        $smtp_data['config_value'] = json_encode($smtp_setting_data);
        $sms_config_data['config_value'] = json_encode($sms_configuration_data);
        $this->config_model->update_config('SMTP_SETTING', $smtp_data);
        $this->config_model->update_config('SMS_SETTING', $sms_config_data);
        $result = generate_array_for_id_object($this->config_model->get_all_data(), 'config_key');
//        $data[smtp] = json_encode($result['SMTP_SETTING']['config_value']);
//        $data[sms] = json_encode($result['SMS_SETTING']['config_value']);
        echo json_encode(array('success' => TRUE, 'message' => 'Other Configuration Template Updated Successfully!'));
    }

    function update_schedule_message_format() {

        $message_format = $this->input->post('schedule_message_format');
        $schedule_message_format['config_value'] = $message_format;
        $this->config_model->update_config('SCHEDULE_MESSAGE_FORMAT', $schedule_message_format);
        echo json_encode(array('success' => TRUE, 'message' => 'Schedule Message Format Updated Successfully'));
    }
    function update_feedback_message_format() {
        
        $message_format = $this->input->post('feedback_message_format');
        $feedback_message_format['config_value'] = $message_format;
        $this->config_model->update_config('FEEDBACK_MESSAGE_FORMAT', $feedback_message_format);
        echo json_encode(array('success' => TRUE, 'message' => 'Feedback Message Format Updated Successfully'));
    }
    function update_payment_message_format() {
        
        $message_format = $this->input->post('payment_message_format');
        $payment_message_format['config_value'] = $message_format;
        $this->config_model->update_config('PAYMENT_MESSAGE_FORMAT', $payment_message_format);
        echo json_encode(array('success' => TRUE, 'message' => 'Payment Message Format Updated Successfully'));
    }    
    function update_payment_refund_message_format() {
        
        $message_format = $this->input->post('payment_refund_message_format');
        $payment_refund_message_format['config_value'] = $message_format;
        $this->config_model->update_config('PAYMENT_REFUND_MESSAGE_FORMAT', $payment_refund_message_format);
        echo json_encode(array('success' => TRUE, 'message' => 'Payment Refund Message Format Updated Successfully'));
    }
    function update_birthday_wish_message_format() {
        
        $message_format = $this->input->post('birthday_wish_message_format');
        $birthday_wish_message_format['config_value'] = $message_format;
        $this->config_model->update_config('BIRTHDAY_WISH_MESSAGE_FORMAT', $birthday_wish_message_format);
        echo json_encode(array('success' => TRUE, 'message' => 'Birthday Wish Message Format Updated Successfully'));
    }

}
