<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Attendance_model extends CI_Model {

    function get_course_schedule($attendance_date) {
        $sql = "select DISTINCT s.schedule_id,s.schedule_date,s.schedule_course_id,s.schedule_from_time,s.schedule_to_time,s.schedule_day,c.course_id,c.course_fees,c.course_title,c.course_duration  from schedule as s join course as c on s.schedule_course_id=c.course_id where s.schedule_date='" . $attendance_date . "' GROUP BY s.schedule_date,s.schedule_course_id,s.schedule_from_time,s.schedule_to_time,s.schedule_id";
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    function get_student_record_by_course_schedule($course_id, $enrollment_id) {
        $this->db->select('s.student_id,s.student_reference,s.student_mobile,s.student_first_name,s.student_last_name,s.student_interestedin_email,s.student_interestedin_message,s.lang_preference,e.enrollment_id,e.sub_total,e.due_amounts,e.average_amount,sum(payment_amount) as payment_amount,max(e.enrollment_validity_date) as enrollment_validity_date');
        $this->db->from('enrollment_course   AS ec');
        $this->db->join('enrollment  AS e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master   AS s', 's.student_id=e.student_id');
        $this->db->join('payment   AS p', 'p.enrollment_id=e.enrollment_id', 'left');
        $this->db->where('ec.course_id', $course_id);
        $this->db->where('s.discontinue', DISCONTINUENO);
        if ($enrollment_id != '') {
            $this->db->where('e.enrollment_id', $enrollment_id);
        }
        $this->db->group_by('s.student_id,e.sub_total,e.due_amounts,e.average_amount,e.enrollment_id');
        $this->db->order_by('e.enrollment_validity_date, s.student_id', 'desc');
        if ($enrollment_id != '') {
            return $this->db->get()->row_array();
        } else {
            return $this->db->get()->result_array();
        }
    }
    function get_student_record_by_course_schedule1($course_id, $enrollment_id) {
        $this->db->select('s.*,s.student_id,e.enrollment_id,e.sub_total,e.due_amounts,e.average_amount,sum(payment_amount) as payment_amount,max(e.enrollment_validity_date) as enrollment_validity_date,si.student_interest_id,si.food_type,si.next,si.status,ec.enrollment_course_id');
        $this->db->select('(SELECT DATE_FORMAT(call_date, "%d-%m-%Y") FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as call_date');
        $this->db->select('(SELECT note FROM call_log WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as note');
        $this->db->select('(SELECT course.course_title FROM call_log JOIN course ON course.course_id = call_log.course_id  WHERE student_id = s.student_id ORDER BY call_date DESC,call_log_id DESC limit 1) as course_title');
        $this->db->from('enrollment_course   AS ec');
        $this->db->join('enrollment  AS e', 'ec.enrollment_id=e.enrollment_id AND e.is_delete=0');
        $this->db->join('student_master   AS s', 's.student_id=e.student_id');
        $this->db->join('payment   AS p', 'p.enrollment_id=e.enrollment_id', 'left');
        $this->db->join('student_interest  AS si', 'si.student_id=s.student_id AND si.course_id=ec.course_id','left');
        $this->db->where('ec.course_id', $course_id);
        $this->db->where('s.discontinue', DISCONTINUENO);
        if ($enrollment_id != '') {
            $this->db->where('e.enrollment_id', $enrollment_id);
        }
        $this->db->group_by('s.student_id,e.sub_total,e.due_amounts,e.average_amount,e.enrollment_id');
        $this->db->order_by('e.enrollment_validity_date, s.student_id', 'desc');
        if ($enrollment_id != '') {
            return $this->db->get()->row_array();
        } else {
            return $this->db->get()->result_array();
        }
    }

    function save_attendance($student_attendance_data) {
        $student_attendance_data['attendance_created_date'] = date('Y-m-d h:i:s');
        $this->db->insert('student_attendance', $student_attendance_data);
        return $this->db->insert_id();
    }

    function is_attendance_exists($student_attendance_data) {
        $this->db->select('*');
        $this->db->from('student_attendance');
        $this->db->where('attendance_schedule_id', $student_attendance_data['attendance_schedule_id']);
        $this->db->where('attendance_student_id', $student_attendance_data['attendance_student_id']);
        $this->db->where('attendance_enrollment_id', $student_attendance_data['attendance_enrollment_id']);
        $this->db->where('attendance_date', $student_attendance_data['attendance_date']);
        return $this->db->get()->row_array();
    }

    function get_student_present_or_absent($student_id, $student_schedule_id, $student_attendance_date, $attendance_enrollment_id) {
        $this->db->select('sa.*,s.schedule_day');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id=sa.attendance_schedule_id');
        $this->db->where('sa.attendance_student_id', $student_id);
        $this->db->where('sa.attendance_enrollment_id', $attendance_enrollment_id);
        $this->db->where('sa.attendance_schedule_id', $student_schedule_id);
        $this->db->where('sa.attendance_date', $student_attendance_date);
        //$this->db->where('sa.attendance_repeated',0);
        return $this->db->get()->row_array();
    }

    function delete_attendance($student_attendance_data) {
        $this->db->where('attendance_schedule_id', $student_attendance_data['attendance_schedule_id']);
        $this->db->where('attendance_student_id', $student_attendance_data['attendance_student_id']);
        $this->db->where('attendance_enrollment_id', $student_attendance_data['attendance_enrollment_id']);
        $this->db->where('attendance_date', $student_attendance_data['attendance_date']);
        $this->db->delete('student_attendance');
        return $this->db->affected_rows();
    }

    function delete_attendance_by_id($attendance_id) {
        $this->db->where('attendance_id', $attendance_id);
        $this->db->delete('student_attendance');
        return $this->db->affected_rows();
    }

    function get_attendance_by_student($student_id) {
        $this->db->select('*');
        $this->db->from('student_attendance as sa');
        $this->db->join('student_master  AS sm', 'sm.student_id=sa.attendance_student_id');
        $this->db->join('schedule AS s', 's.schedule_id=sa.attendance_schedule_id ');
        $this->db->join('course AS c', 'c.course_id=s.schedule_course_id ');
        $this->db->where('student_id', $student_id);
        return $this->db->get()->result_array();
    }

    function get_course_duration_by_student($schedule_id, $enrollment_id) {
        $sql = "select sm.student_id, sum(c.course_duration) as total_course_duration from schedule as s join course as c on c.course_id = s.schedule_course_id join enrollment_course as ec on ec.course_id = c.course_id join enrollment as e on e.enrollment_id = ec.enrollment_id join student_master as sm on sm.student_id = e.student_id where s.schedule_id ='" . $schedule_id . "' and e.enrollment_id = '" . $enrollment_id . "' group by sm.student_id";
        $recs = $this->db->query($sql);
        return $recs->row_array();
    }

    function get_attendence_by_student_bkp($course_id) {
        $sql = "select count(sa.attendance_id) as total_attendance,sa.attendance_student_id as student_id  from student_attendance sa where sa.attendance_schedule_id in(select schedule_id from schedule where schedule_course_id='" . $course_id . "') group by sa.attendance_student_id";
        $recs = $this->db->query($sql);
        return $recs->result_array();
    }

    // function get_attendence_by_student($course_id, $enrollment_id) {
    //     $sql = "select GROUP_CONCAT(s.schedule_day) as schedule_day,GROUP_CONCAT(s.schedule_date) as schedule_date,count(sa.attendance_id) as total_attendance,sa.attendance_student_id as student_id 
    //         from student_attendance sa
    //        join schedule as s on s.schedule_id = sa.attendance_schedule_id
    //         where  s.schedule_course_id='" . $course_id . "'
    //         and sa.attendance_enrollment_id ='" . $enrollment_id . "' and sa.attendance_repeated = 0
    //        group by sa.attendance_student_id";
    //     $recs = $this->db->query($sql);
    //     return $recs->row_array();
    // }

    function get_attendence_by_student($course_id, $enrollment_id) 
    {
        //$this->db->select('GROUP_CONCAT(s.schedule_day) as schedule_day,GROUP_CONCAT(s.schedule_date) as schedule_date,count(sa.attendance_id) as total_attendance,sa.attendance_student_id as student_id');
        $this->db->select('GROUP_CONCAT(s.schedule_date) as schedule_date,sa.attendance_student_id as student_id');
        $this->db->select('(SELECT GROUP_CONCAT(schedule.schedule_day) as schedule_day FROM student_attendance JOIN schedule ON schedule.schedule_id = student_attendance.attendance_schedule_id WHERE schedule.schedule_course_id = s.schedule_course_id AND student_attendance.attendance_enrollment_id = sa.attendance_enrollment_id ) as schedule_day');
        $this->db->select('(SELECT count(student_attendance.attendance_id) as total_attendance FROM student_attendance JOIN schedule ON schedule.schedule_id = student_attendance.attendance_schedule_id WHERE schedule.schedule_course_id = s.schedule_course_id AND student_attendance.attendance_enrollment_id = sa.attendance_enrollment_id ) as total_attendance');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id = sa.attendance_schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);
        $this->db->where('sa.attendance_repeated',0);
        $this->db->group_by('sa.attendance_student_id');
        return $this->db->get()->row_array();
    }

    function get_total_attendance_without_repeat($course_id, $enrollment_id) 
    {        
        $this->db->select('count(sa.attendance_id) as total_attendance');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id = sa.attendance_schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);
        $this->db->where('sa.attendance_repeated',0);
        $this->db->group_by('sa.attendance_student_id');
        return $this->db->get()->row_array();
    }

    function check_day_attend_or_not($student_id,$course_id,$enrollment_id,$schedule_day)
    {
        $this->db->select('sa.attendance_student_id');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id = sa.attendance_schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('s.schedule_day',$schedule_day);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);
        $this->db->where('sa.attendance_student_id',$student_id);
        $this->db->where('sa.attendance_repeated',0);
        return $this->db->get()->row_array();

    }

    function get_attendance_details() {
        return $this->db->get('student_attendance')->result_array();
    }

    function get_attendance_detail_by_id($enrollment_id, $course_id) {
        $this->db->select('count(*) as attendance_cnt');
        $this->db->join('schedule AS s', 's.schedule_id=sa.attendance_schedule_id ');
        $this->db->where('sa.attendance_enrollment_id', $enrollment_id);
        $this->db->where('s.schedule_course_id', $course_id);
        return $this->db->get('student_attendance AS sa')->row_array();
    }

    function update_attendance($attendance_id, $enrollment_id) {
        $this->db->where('attendance_id', $attendance_id);
        $this->db->set('attendance_enrollment_id', $enrollment_id);
        $this->db->update('student_attendance');
    }

    function get_attendance_details_by_id($enrollment_id, $course_id) {
        $this->db->select('s.schedule_date,s.schedule_day');
        $this->db->join('schedule AS s', 's.schedule_id=sa.attendance_schedule_id ');
        $this->db->where('sa.attendance_enrollment_id', $enrollment_id);
        $this->db->where('s.schedule_course_id', $course_id);
        $this->db->order_by('s.schedule_date','asc');
        return $this->db->get('student_attendance AS sa')->result_array();
    }

    function get_last_attend_day($student_id,$course_id,$schedule_day,$schedule_date,$enrollment_id)
    {        
        $this->db->select('s.*,a.*');
        $this->db->from('schedule s');
        $this->db->join('student_attendance a','a.attendance_schedule_id=s.schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('s.schedule_day',$schedule_day);
        //$this->db->where('s.schedule_date <=',$schedule_date);
        $this->db->where('a.attendance_student_id',$student_id);
        $this->db->where('a.attendance_enrollment_id',$enrollment_id);
        $this->db->where('a.attendance_repeated',0);
        $this->db->order_by('s.schedule_date DESC');
        $res = $this->db->get();
        return $res->row_array();
    }
    function get_food_pref($student_id,$course_id)
    {
        $this->db->select('*');
        $this->db->from('student_interest');
        $this->db->where('student_id',$student_id);
        $this->db->where('course_id',$course_id);
        $this->db->order_by('student_interest_id DESC');
        return $this->db->get()->row_array();
    }
    function get_all_repeated_day($student_id,$enrollment_id,$course_id)
    {
        $this->db->select('sa.*,s.schedule_day, DATE_FORMAT(sa.attendance_date,"%d-%m-%Y") as attendance_date');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s', 's.schedule_id=sa.attendance_schedule_id ');
        $this->db->where('sa.attendance_student_id',$student_id);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);        
        $this->db->where('sa.attendance_repeated',1);
        $this->db->where('s.schedule_course_id',$course_id);
        return $this->db->get()->result_array();
    }

}
