<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Payment extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('payment_model');
        $this->load->model('student_master_model');
        $this->load->model('student_enrollment_model');
        check_authenticated();
    }

    function get_by_payment_id() {
        $student_id = $this->input->post('student_id');       

        $payment_details = $this->data_lib->get_payment_detail($student_id);        

        foreach ($payment_details as &$payment_data) {

            $payment_data['course_data'] = $this->student_enrollment_model->get_enrollment_course_details($payment_data['enrollment_id']);            

            if(!empty($payment_data['course_data']))
            {
                foreach ($payment_data['course_data'] as $key => &$value) {

                    $result = $this->student_enrollment_model->get_attendance($payment_data['enrollment_id'],$value['course_id'],$payment_data['student_id']);
                    if(!empty($result))
                    {
                        $value['attend_day'] = date_format(date_create($result['attendance_date']),'d-m-Y');
                    }
                    else
                    {
                        $value['attend_day'] = '-';
                    }

                }
            }
        }       

        echo json_encode($payment_details);
    }

    function get_student_name_with_total() {
        $student_id = $this->input->post('student_id');
        $student_data = $this->student_master_model->get_by_student_id($student_id);
        $payment_details = $this->data_lib->get_payment_detail($student_id);
        $total = 0;
        $paid = 0;
        $due = 0;
        $discount = 0;
        foreach ($payment_details as $r) {
            $total += $r['sub_total'];
            $paid += $r['pay_amount'];
            $due += $r['due_amounts'];
            $discount += $r['discount'];
            $total_discount += $r['total_discount'];
        }
        $student_data['total'] = $total;
        $student_data['paid'] = $paid;
        $student_data['due'] = $due;
        $student_data['discount'] = $discount;
        $student_data['total_discount'] = $total_discount;
        echo json_encode($student_data);
    }

    function save_payment() {
        $payment_data = $this->_get_payment_from_post();
        $validation_message = $this->_validate_payment($payment_data);
        if ($validation_message != '') {
            echo json_encode(array('success' => false, 'message' => $validation_message));
            return;
        }



        $this->payment_model->update_due_amount($payment_data['student_id'], $payment_data['enrollment_id'], $payment_data['payment_amount']);
        $this->payment_model->create($payment_data);
        echo json_encode(array('success' => TRUE, 'message' => 'Payment Successflly'));
    }

    function _get_payment_from_post() {
        $pay_date = new DateTime($this->input->post('pay_date'));
        $new_pay_date = $pay_date->format('Y-m-d');

        $payment_type= $this->input->post('payment_type');
        $total_amount = $this->input->post('student_pay');

        if($payment_type == 'refund')
        {
            $total_amount = '-'.$total_amount;
        }
        
        return array(
            'enrollment_id' => $this->input->post('enrollment_id'),
            'student_id' => $this->input->post('student_id'),
            'payment_amount' => $total_amount,
            'payment_date' => $new_pay_date,
            'payment_mode' => $this->input->post('payment_mode'),
            'payment_reference_number' => $this->input->post('payment_reference_number'),
            'payment_remarks' => $this->input->post('payment_remarks'),
        );
    }

    function _validate_payment($payment_data) {
        if ($payment_data['payment_amount'] == '' || $payment_data['payment_amount'] == 0) {
            return 'Please Enter Amount.';
        }
        if ($payment_data['payment_date'] == '') {
            return 'Please Enter Date.';
        }
        if ($payment_data['payment_mode'] == '') {
            return 'Please Enter Payment mode.';
        }
        return '';
    }

    function delete_payment() {
        $payment_id = $this->input->post('payment_id');
        $payment_data = $this->payment_model->get_payment_by_payment_id($payment_id);
        $this->payment_model->update_due_amount_for_delete($payment_data['enrollment_id'], $payment_data['student_id'], $payment_data['payment_amount']);
        $this->payment_model->delete_payment_by_id($payment_id);
        echo json_encode(array('success' => TRUE, 'message' => 'Payment Deleted succefully'));
    }

    function generate_bill_pdf($payment_id) {
        $data['payment_data'] = $payment_data = $this->payment_model->get_bill_pdf_data_by_payment_id($payment_id);
        $output = $this->load->view('student_master/bill_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', 0, 0, 10, 5, 10);
        $mpdf->WriteHTML($output);
        $mpdf->Output($payment_id . '_bill' . ".pdf", 'I');
    }

}

/**
     * EOF: ./application/controllers/Payment.php
     */
    