var studentAttendanceFormTemlate = Handlebars.compile($('#attendance_form_template').html());
var studentAttendanceListTemplate = Handlebars.compile($('#attendance_list_template').html());
var studentAttendanceTableTemplate = Handlebars.compile($('#student_attendance_table_template').html());
var studentAttendanceActionTemplate = Handlebars.compile($('#student_attendance_action_template').html());
var studentAttendanceAbsentPresentTemplate = Handlebars.compile($('#student_attendance_absent_present_template').html());
var studentAttendanceTemplate = Handlebars.compile($('#student_attendance_template').html());
var studentAttendanceList = Handlebars.compile($('#student_attendance_list_template').html());
var studentAttendanceTableListTemplate = Handlebars.compile($('#student_attendance_table_list_template').html());
var addStudentActionButtonsTemplate = Handlebars.compile($('#add_student_action_template').html());
var addStudentAttendenceTableTemplate = Handlebars.compile($('#add_student_attendance_table_template').html());
var attendanceCnt = 0;
var allScheduleAndCourseData = [];
// TODO: find a better solution for the dirty patch written below
var studentAttendanceDataTable = {
    destroy: function () {
        console.log('Do Nothing, this is a dirty patch written by Chitrang Shah');
    }
};

var StudentAttendance = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
StudentAttendance.Router = Backbone.Router.extend({
    routes: {
        'attendance/list': 'renderList',
        'attendance/:id': 'renderAttendance'
    },
    renderList: function () {
        StudentAttendance.listview.listAttendance();
        StudentAttendance.router.navigate('attendance/list', {trigger: true});
    },
    renderAttendance: function (studentId) {
        StudentAttendance.listview.getStudentAttendance(studentId);
    }
});
StudentAttendance.listView = Backbone.View.extend({
    el: 'div#main_container',
    events: {
        'click #ref_btn': 'showHideRefDiv'
    },
    getMessageData: function (type, title, come_from_module) {

        var schedule_id = $('#student_course_schedule').val();
        var checkboxValues = [];
        var is_message = false;
        var is_email = false;
        var title = '';
        if (type == 'message') {
            $('input[name=attendance_sms_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
            is_message = true;
            title = 'Send Message';
        }
        if(type == 'email') {
            $('input[name=attendance_email_chack_box]:checked').map(function () {
                checkboxValues.push($(this).val());
            });
            is_email = true;
            title = 'Send Mail';
        }
        if ($.isEmptyObject(checkboxValues)) {
            showError('Plase Select Any ' + title + ' CheckBox1');
            return false;
        }

        if (type == 'email') {
            $('#send_shedule_mail_information').hide();
            $('#spinner_send_schedule_mail_btn').html(spinnerTemplate);
            $('#spinner_send_schedule_mail_btn').show();
        }
        if (type == 'message') {
            $('#send_shedule_sms_information').hide();
            $('#spinner_send_schedule_sms_btn').html(spinnerTemplate);
            $('#spinner_send_schedule_sms_btn').show();
        }

        var finalData = {
            "schedule_id":schedule_id,
            "sending_type": type,
            "student_array": checkboxValues,
            "title": title
        };

        $.ajax({
            type: 'POST',
            url: 'student_attendance/send_mail_and_sms',
            data: finalData,
            success: function (data) {

                var StudentData = JSON.parse(data);
                if (StudentData.success === false) {
                    showError(StudentData.message);
                    return false;
                }
                showSuccess(StudentData.message);
                if(type == 'message')
                {
                    if(come_from_module == 'attendance_module')
                    {
                        $('input[id=check_student_attendance_message_box]').prop('checked',false);
                        $('input[name=attendance_sms_chack_box]').prop('checked',false);
                    }
                }
                else
                {
                    if(come_from_module == 'attendance_module')
                    {
                        $('input[id=check_student_attendance_email_box]').prop('checked',false);
                        $('input[name=attendance_email_chack_box]').prop('checked',false);
                    }
                }
                generateTinymce('.tinymce');
                if (type == 'email') {
                    $('#send_shedule_mail_information').show();
                    $('#spinner_send_schedule_mail_btn').hide();
                    $('#send_sms_modal').modal('hide');
                }
                if (type == 'message') {
                    $('#send_shedule_sms_information').show();
                    $('#spinner_send_schedule_sms_btn').hide();
                    $('#send_sms_modal').modal('hide');
                }
            }
        });
    },
    showHideRefDiv:function (){

        if($("#ref_div").is(":visible"))
            $( "#ref_div" ).slideUp();
        else
            $( "#ref_div" ).slideDown();

    },
    listAttendance: function (date='') {
        this.$el.html(studentAttendanceListTemplate);
        $('#attendance_form_container').html(studentAttendanceFormTemlate);
        $('.date_picker').datetimepicker({
            format: 'dd-mm-yyyy'
        });
        if(date=='')
        {
            $('#student_attendance_date').val(dateTo_DD_MON_YYYY(new Date()));
        }
        else
        {
            $('#student_attendance_date').val(dateTo_DD_MON_YYYY(new Date(date)));
        }
        if (globalData.schedule_date != '' && globalData.schedule_date != undefined) {
            $('#student_attendance_date').val(globalData.schedule_date);
        }
        $('#attendance_table_container').html(studentAttendanceTableTemplate);
        this.courseSchedule();
    },
    courseSchedule: function () {
        var that = this;
        var attendanceDate = $('#student_attendance_date').val();
        $('#attendance_interested_students_container').html('');
        $.ajax({
            type: 'POST',
            url: 'student_attendance/get_course_schedule',
            data: {'attendance_date': attendanceDate},
            success: function (data) {
                var courseData = JSON.parse(data);
                var dataLength = Object.keys(courseData).length;
                allScheduleAndCourseData = courseData;
                $('#attendance_course_data').html('');
                var counter = 1;
                var firstScheduleId = 0;
                var fees = 0;
                var scheduleId = '';
                $.each(courseData, function (index, value) {
                    if (counter == 1) {
                        firstScheduleId = value.schedule_id;
                        fees = value.course_fees;
                        scheduleId = value.schedule_id;
                    }
                    $('#attendance_course_data').append('<tr class="normal_s_row" id="s_row_' + value.schedule_id + '"><td><a class="schedule_link" id="schedule_link_' + value.schedule_id + '" style="cursor:pointer" onclick="StudentAttendance.listview.loadStudentDetail(' + value.schedule_id + ',' + value.course_fees + ',' + value.schedule_id + ');">' + value.course_title + ' : ' + convert24To12Hours(value.schedule_from_time) + ' to ' + convert24To12Hours(value.schedule_to_time) + ' (Day ' + value.schedule_day + ')</a></td></tr>');
                    counter++;
                });
                if (courseData == '') {
                    $('#attendance_course_data').append('<tr><td style="padding-right: 5px;">No Schedule Available</td></tr>');
                }
                that.loadStudentDetail(firstScheduleId, fees, scheduleId);

                globalData.attendance_page_number = globalData.attendance_page_number || 0;
                studentAttendanceDataTable.page(globalData.attendance_page_number).draw(false);

                $('#student_attendance_data_table').on('page.dt', function () {
                    var info = studentAttendanceDataTable.page.info();
                    studentAttendencePageNumber = info.page;
                });

                // $('#interested_course_student_data_table').on('page.dt', function () {
                //     var info = studentInterestedCourseDataTable.page.info();
                //     studentInterestedCourseDataTablePageNumber = info.page;
                // });

                if (globalData.schedule_date != '' && globalData.schedule_date != undefined) {
                    $('#student_course_schedule').val(scheduleId).trigger('change');
                }
            }
        });
    },
    loadStudentDetail: function (scheduleId, fees, scheduleId) {
        var that = this;
        studentAttendanceDataTable.destroy();
        $('#student_course_schedule').val(scheduleId);
        var attendanceDate = $("#student_attendance_date").val();
        var courseId = '';
        if (scheduleId != null && scheduleId != '') {
            courseId = allScheduleAndCourseData[scheduleId]['schedule_course_id'];
            $('.normal_s_row').css('background-color', ' #f0f0f0');
            $('.schedule_link').css('color', ' #72afd2');
            $('#s_row_' + scheduleId).css('background-color', '#1e90ff');
            $('#schedule_link_' + scheduleId).css('color', '#fff');
//            $('.normal_s_row').css('background-color',' #f0f0f0');
//            $('#s_row_'+scheduleId).css('background-color','#000');
        }
        var attendancData = {
            "course_id": courseId,
            "attendance_date": attendanceDate,
            "schedule_id": scheduleId
        };



        var studentAttendActionRenderer = function (data, type, full, meta) {

            return studentAttendanceActionTemplate({'student_id': data});
        };
        var studentAttendanceRenderer = function (data, type, full, meta) {

            // TODO: addPresentAbsentTemplateData function can be invoked instead
            var checkedNo = (full.absent_or_present == GLOBAL_NO) ? 'checked' : '';
            var checkedYes = (full.absent_or_present == GLOBAL_NO) ? '' : 'checked';
            var add_attendance_repeate = false;

            return studentAttendanceTemplate({'attendance_repeated':full.attendance_repeated,'attendance_id':full.attendance_id,'attendance':full.attendance_arr,'student_id': data, 'enrollment_id': full.enrollment_id, "YES": GLOBAL_YES, "NO": GLOBAL_NO, "checked_no": checkedNo, "checked_yes": checkedYes, "enrollment_validity_date": full.enrollment_validity_date,"schedule_date":full.schedule_date,"schedule_id":full.schedule_id,"full":full,'add_attendance_repeate':add_attendance_repeate});
        };
        var studentNameActionRenderer = function (data, type, full, meta) {
            var attendanceModule = "'attendance_module'";
            var onClockStudentAttendance = '<a target="_blank" href="main#student/view/' + full.student_id + '" class="btn btn-xs pull-right" id="student_details_view" style="cursor: pointer;"> <label class="fa fa-eye label-btn-icon"></label></a>';
            return full.student_first_name + ' ' + full.student_last_name + onClockStudentAttendance;
        };
        var studentPresentAbsentActionRenderer = function (data, type, full, meta) {
            // TODO: addPresentAbsentStatus function can be invoked instead

            var presentNo = (full.absent_or_present == GLOBAL_YES) ? 'display:none;' : '';
            var presentYes = (full.absent_or_present == GLOBAL_YES) ? '' : 'display:none;';
            var course_duration = full.course_duration;
            var student_attendance = full.student_attendance;

            var attend_day = '0';
            if(full.student_attend_day)
            {
                attend_day = full.student_attend_day;
            }

            return studentAttendanceAbsentPresentTemplate({'student_id': data, 'enrollment_id': full.enrollment_id, "present_yes": presentYes, "present_no": presentNo, "course_duration": course_duration, "student_attendance": student_attendance,"attend_day":attend_day});
        };
        var revenueRenderer = function (data, type, full, meta) {

            total_revenue = 0;

            var parts = attendancData.attendance_date.split('-');
            //var newdate = parts[2]+'-'+parts[1]+'-'+(parseInt(parts[0], 10)%100);
            var newdate = parts[2]+'-'+parts[1]+'-'+parts[0];


            //if(full.attendance_arr[0].schedule_date == newdate && full.attendance_arr[0].present == 1 && full.attendance_repeated == false)
            if(full.attendance_arr[0].last_attend_date_format == full.schedule_date && full.attendance_arr[0].present == 1 && full.attendance_repeated == false)
            {
                if(parseFloat(full.average_amount) > parseFloat(full.course_fees))
                {
                    total_revenue = parseFloat(full.course_fees);
                }
                else
                {
                    total_revenue = parseFloat(full.average_amount);
                }
            }
            return Math.round(total_revenue);
        };
        var emailCheckBoxRenderer = function (data, type, full, meta) {
            if (full.student_interestedin_email == GLOBAL_YES) {
                return ' <div class="checkbox checkbox-primary"><input type="checkbox" name="attendance_email_chack_box" id="attendance_email_chack_box_' + data + '" value="' + data + '"><label for="attendance_email_chack_box_' + data + '"></label></div>';
            }
            return '';
        };
        var smsCheckBoxRenderer = function (data, type, full, meta) {
            if (full.student_interestedin_message == GLOBAL_YES) {
                return ' <div class="checkbox checkbox-primary"><input type="checkbox" name="attendance_sms_chack_box" id="attendance_sms_chack_box_' + data + '" value="' + data + '"><label for="attendance_sms_chack_box_' + data + '"></label></div>';
            }
            return '';
        };
        studentAttendanceDataTable = $('#student_attendance_data_table').DataTable({
            ajax: {
                url: 'student_attendance/get_student_record_by_course_schedule',
                dataSrc: "",
                type: "post",
                data: attendancData,
                async: false,
                "dataSrc": function ( json ) {

                    $('#attendance_schedule_id').val(attendancData.schedule_id);
                    $('#attendance_course_id').val(attendancData.course_id);

                    var parts = attendancData.attendance_date.split('-');
                    //var newdate = parts[2]+'-'+parts[1]+'-'+(parseInt(parts[0], 10)%100);
                    var newdate = parts[2]+'-'+parts[1]+'-'+parts[0];

                    total_revenue = 0;
                    json.forEach((element, i) => {


                        //if(element.attendance_arr[0].schedule_date == newdate && element.attendance_arr[0].present == 1 && element.attendance_repeated == false)
                        if(element.attendance_arr[0].last_attend_date_format == element.schedule_date && element.attendance_arr[0].present == 1 && element.attendance_repeated == false)
                        {
                            if(parseFloat(element.average_amount) > parseFloat(element.course_fees))
                            {
                                total_revenue = total_revenue+parseFloat(element.course_fees);
                            }
                            else
                            {
                                total_revenue = total_revenue+parseFloat(element.average_amount);
                            }
                        }

                    });

                    $('#attendance_total_revenue').html(Math.round(total_revenue));

                    StudentAttendance.listview.updateAttendanceCounter(json)

                    return json;
                }
            },
            deferRender: true,
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            columns: [
                {data: 'student_id'},
                {data: 'student_id', 'render': emailCheckBoxRenderer},
                {data: 'student_id', 'render': smsCheckBoxRenderer},
                /*{
                    "className": '',
                    "data": 'enrollment_validity_date',
                    "visible": false
                },*/
                {
                    "className": '',
                    "orderable": false,
                    "render": studentNameActionRenderer
                },
                {data: 'student_mobile'},
                {data: 'sub_total', 'render': roundupAmount, className: "text-right"},
                {data: 'payment_amount', 'render': roundupAmount, className: "text-right"},
                {data: 'due_amounts', 'render': roundupAmount, className: "text-right"},
                {data: 'average_amount', "render": revenueRenderer, className: "text-right"},
                {
                    "className": '',
                    "orderable": false,
                    "data": 'student_id',
                    "render": studentPresentAbsentActionRenderer
                },
                {
                    "className": '',
                    "orderable": false,
                    "data": 'student_id',
                    "render": studentAttendanceRenderer
                },
                {
                    "className": '',
                    "orderable": false,
                    "data": 'student_id',
                    "render": studentAttendActionRenderer
                }

            ],
            "columnDefs": [{
                    "searchable": false,
                    "orderable": false,
                    "targets": 0,
                    "defaultcontent": "-"

                }],
            "dom": '<"col-sm-6"l><"col-sm-6"f><"col-sm-6"i><"col-sm-6"p>rt<"col-sm-6"i><"col-sm-6"p><"clear">',
            "createdRow": function (row, data, dataIndex) {
                if (data['total_enrollment'] == 0) {
                    $(row).css("background-color", "white");
                }
                if (data['total_enrollment'] != 0) {
                    $(row).css("background-color", "#CBE0CB");
                    if ((data['due_amounts'] >= 0) && (data['due_amounts'] != 0)) {
                        $(row).css("background-color", "#F4E2E2"); //green
                    }
                }
                $(row).attr('data-id', data['student_id']);
            },
            /*"order": [[1, 'asc']],*/
            'initComplete':function( settings, json ) {


                if(json.length > 0)
                {
                    var G=0;
                    var E=0;
                    var H=0;

                    var R=0;
                    var J=0;
                    var SJ=0;

                    var total_present = 0;
                    var total_absent = 0;

                    $.each(json, function (index,value) {

                        if(value.lang_preference != '')
                        {
                            lan =JSON.parse(value.lang_preference);

                            if(lan[0] == 'Gujarati')
                            {
                                G++;
                            }
                            else if(lan[0] == 'English')
                            {
                                E++;
                            }
                            else if(lan[0] == 'Hindi')
                            {
                                H++;
                            }
                        }
                        if(value.food_type == 'Regular')
                        {
                            R++;
                        }
                        else if(value.food_type == 'Jain')
                        {
                            J++;
                        }
                        else if(value.food_type == 'Sjain')
                        {
                            SJ++;
                        }


                        if(value.absent_or_present == true)
                        {
                            total_present++;
                        }
                        else
                        {
                            total_absent++;
                        }

                    });

                    $('#a_gujrati').html('G : '+G);
                    $('#a_hindi').html('H : '+H);
                    $('#a_english').html('E : '+E);

                    $('#a_food_regular').html('R : '+R);
                    $('#a_food_jain').html('J : '+J);
                    $('#a_food_sjain').html('SJ : '+SJ);

                    $('#total_student_in_attendance').html('Total : '+json.length);
                    $('#total_present_student_in_attendance').html('Present : '+total_present);
                    $('#total_absent_student_in_attendance').html('Absent : '+total_absent);
                }

                $.ajax({
                    type: 'POST',
                    url: 'student_attendance/get_ref_counter',
                    dataType: 'json',
                    data: attendancData,
                    async: true,
                    success: function (data) {
                        var ref_array_counter = data;
                        var ref_html = '';
                        $.each(ref_array_counter, function (index,value) {
                            ref_html+='<a class="btn btn-app">'+
                                            '<span class="ref_label">'+value.name+'</span><br>'+value.count+
                                       '</a>';
                        });
                        $('#ref_div').html(ref_html);
                    }
                });
            }

        });
        studentAttendanceDataTable.on('order.dt search.dt', function () {
            studentAttendanceDataTable.column(0, {search: 'applied', order: 'applied'}).nodes().each(function (cell, i) {
                cell.innerHTML = i + 1;
            });
        }).draw();
        $('#attendance_course_fees').html(parseFloat(fees).toFixed(2));
        Interest.listview.interestedStudent(courseId, false, $('#attendance_interested_students_container'),'attendance_module');
    },
    updateAttendanceCounter:function (json) {

        // var attendanceDate = $("#student_attendance_date").val();
        // var scheduleId =  $('#attendance_schedule_id').val();
        // var courseId = $('#attendance_course_id').val();

        // var attendancData = {
        //     "course_id": courseId,
        //     "attendance_date": attendanceDate,
        //     "schedule_id": scheduleId
        // }


        // $.ajax({
        //     type: 'POST',
        //     url: 'student_attendance/get_student_record_by_course_schedule',
        //     dataType: 'json',
        //     data: attendancData,
        //     async: false,
        //     success: function (data) {
        //         json = data;
        //     }
        // });

        var G=0;
        var E=0;
        var H=0;

        var R=0;
        var J=0;
        var SJ=0;

        var total_present = 0;
        var total_absent = 0;

        if(json.length > 0)
        {
            $.each(json, function (index,value) {

                if(value.lang_preference != '')
                {
                    lan =JSON.parse(value.lang_preference);

                    if(lan[0] == 'Gujarati')
                    {
                        G++;
                    }
                    else if(lan[0] == 'English')
                    {
                        E++;
                    }
                    else if(lan[0] == 'Hindi')
                    {
                        H++;
                    }
                }
                if(value.food_type == 'Regular')
                {
                    R++;
                }
                else if(value.food_type == 'Jain')
                {
                    J++;
                }
                else if(value.food_type == 'Sjain')
                {
                    SJ++;
                }


                if(value.absent_or_present == true)
                {
                    total_present++;
                }
                else
                {
                    total_absent++;
                }

            });
        }

        $('#a_gujrati').html('G : '+G);
        $('#a_hindi').html('H : '+H);
        $('#a_english').html('E : '+E);

        $('#a_food_regular').html('R : '+R);
        $('#a_food_jain').html('J : '+J);
        $('#a_food_sjain').html('SJ : '+SJ);

        $('#total_student_in_attendance').html('Total : '+json.length);
        $('#total_present_student_in_attendance').html('Present : '+total_present);
        $('#total_absent_student_in_attendance').html('Absent : '+total_absent);
    },
    saveAttendance: function (studentId,validity,enrollmentId,attendance_date,schedule_id,is_attendance,is_repeated) {
        //var is_attendance = $('input[name=is_present_' + enrollmentId + ']:checked').val();
        //var url = is_attendance == 'YES' ? 'save' : 'delete';
        $.ajax({
            type: 'POST',
            // url: 'student_attendance/' + url + '_attendance',
            url: 'student_attendance/save_attendance',
            data: {
                'student_attendence_id': studentId,
                'attendance_enrollment_id': enrollmentId,
                'student_attendance_date': attendance_date,
                // 'attendance_schedule_id': allScheduleAndCourseData[$('#student_course_schedule').val()]['schedule_id'],
                'attendance_schedule_id': schedule_id,
                'attendance_repeated': is_repeated,
                'enrollment_validity': validity
            },
            success: function (data) {

                var parseData = JSON.parse(data);
                if (parseData.success == false) {
                    showError(parseData.message);
                    studentAttendanceDataTable.ajax.reload();
                    studentAttendanceDataTable.page(studentAttendencePageNumber).draw(false);
                    return false;
                }
                if (is_attendance == GLOBAL_NO) {
                    $('#present_' + enrollmentId).hide();
                    $('#absent_' + enrollmentId).show();
                } else {
                    $('#present_' + enrollmentId).show();
                    $('#absent_' + enrollmentId).hide();
                }
                showSuccess(parseData.message);
                studentAttendanceDataTable.ajax.reload();
                studentAttendanceDataTable.page(studentAttendencePageNumber).draw(false);
                //StudentAttendance.listview.updateAttendanceCounter();

                if(current_list_type != 3)
                {
                    studentInterestedCourseDataTable.row( $('#quick_attendance_btn_'+studentId).parents('tr') ).remove().draw( true );
                    //studentInterestedCourseDataTable.ajax.reload();
                    Interest.listview.setCounter();
                }
                else
                {
                    Interest.listview.getAllList();
                }

            }
        });
    },
    deleteAttendance: function (attendance_id) {
        $.ajax({
            type: 'POST',
            url: 'student_attendance/delete_attendance_by_id',
            data: {
                'attendance_id': attendance_id
            },
            success: function (data) {

                var parseData = JSON.parse(data);

                showSuccess(parseData.message);
                studentAttendanceDataTable.ajax.reload();
                studentAttendanceDataTable.page(studentAttendencePageNumber).draw(false);
                //StudentAttendance.listview.updateAttendanceCounter();

                if(current_list_type != 3) {
                    studentInterestedCourseDataTable.ajax.reload();
                    //studentInterestedCourseDataTable.page(studentInterestedCourseDataTablePageNumber).draw(false);
                }
                else
                {
                    Interest.listview.getAllList();
                }
            }
        });
    },
    getStudentAttendance: function (studentId,popup=0) {
        var that = this;
        $.ajax({
            type: 'POST',
            data: {'student_id': studentId},
            url: 'student_attendance/get_by_student_id',
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData != '') {
                    var studentName = parseData.student_first_name + ' ' + parseData.student_last_name;

                    if(popup==1)
                    {
                        $('#student_attendance_popup_body').html(studentAttendanceTableListTemplate);
                        $('#student_attendance_popup').modal({"show": true, "backdrop": 'static', "keyboard": false});
                    }
                    else
                    {
                        that.$el.html(studentAttendanceList({'student_name': studentName, "calling_module": callingModule, "course_id": courseIdForBackView}));
                        $('#student_attendance_table_container').html(studentAttendanceTableListTemplate);
                    }

                    var attendanceDay = function (data, type, full, meta) {
                        return 'Day-' + data;
                    };
                    var attendanceTimeActionRenderer = function (data, type, full, meta) {
                        var fromTime = convert24To12Hours(full.schedule_from_time);
                        var toTime = convert24To12Hours(full.schedule_to_time);
                        return fromTime + ' to ' + toTime;
                    };
                    var attendanceDateRenderer = function (data, type, full, meta) {
                        $('.date_picker').datetimepicker({
                            format: 'dd-mm-yyyy'
                        });
                        return dateTo_DD_MM_YYYY(yyyymmddToDate(data));
                    };
                    studentAttendanceListDataTable = $('#student_attendance_list_data_table').DataTable({
                        ajax: {url: 'student_attendance/get_attendance_by_student', dataSrc: "", type: "post", data: {'student_id': studentId}},
                        stateSave: true,
                        lengthMenu: [10, 25, 50, 75, 100 ],
                        pageLength: 75,
                        columns: [
                            {data: 'course_title'},
                            {data: 'attendance_date', 'render': attendanceDateRenderer},
                            {"render": attendanceTimeActionRenderer},
                            {data: 'schedule_day', "render": attendanceDay}
                        ],
                        "dom": '<"col-sm-6"l><"col-sm-6"f><"col-sm-6"i><"col-sm-6"p>rt<"col-sm-6"i><"col-sm-6"p><"clear">',

                    });
                }
            }
        });
    },
    getStudentAttendanceDetail: function (studentId) {
        var that = this;
        $.ajax({
            type: 'POST',
            data: {'student_id': studentId},
            url: 'student_attendance/get_by_student_id',
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData != '') {

                    var attendanceDay = function (data, type, full, meta) {
                        return 'Day-' + data;
                    };
                    var attendanceTimeActionRenderer = function (data, type, full, meta) {
                        var fromTime = convert24To12Hours(full.schedule_from_time);
                        var toTime = convert24To12Hours(full.schedule_to_time);
                        return fromTime + ' to ' + toTime;
                    };
                    var attendanceDateRenderer = function (data, type, full, meta) {
                        $('.date_picker').datetimepicker({
                            format: 'dd-mm-yyyy'
                        });
                        return dateTo_DD_MM_YYYY(yyyymmddToDate(data));
                    };
                    studentAttendanceListDataTable = $('#student_attendance_list_data_table').DataTable({
                        ajax: {url: 'student_attendance/get_attendance_by_student', dataSrc: "", type: "post", data: {'student_id': studentId}},
                        stateSave: true,
                        lengthMenu: [10, 25, 50, 75, 100 ],
                        pageLength: 75,
                        columns: [
                            {data: 'course_title'},
                            {data: 'attendance_date', 'render': attendanceDateRenderer},
                            {"render": attendanceTimeActionRenderer},
                            {data: 'schedule_day', "render": attendanceDay}
                        ],
                        "dom": '<"col-sm-6"l><"col-sm-6"f><"col-sm-6"i><"col-sm-6"p>rt<"col-sm-6"i><"col-sm-6"p><"clear">',

                    });
                }
            }
        });
    },
    selectStudentForAttendence: function () {
        var scheduleId = $("#student_course_schedule").val();
        var attendanceDate = $("#student_attendance_date").val();
        var courseId = '';
        if (scheduleId != null && scheduleId != '') {
            courseId = allScheduleAndCourseData[scheduleId]['schedule_course_id'];
        }
        var attendanceData = {
            "course_id": courseId,
            "attendance_date": attendanceDate,
            "schedule_id": scheduleId
        };
        $('#add_student_container').html(addStudentAttendenceTableTemplate);
        var addStudentActionRenderer = function (data, type, full, meta) {
            return addStudentActionButtonsTemplate({'student_id': data, 'enrollment_id': full.enrollment_id});
        };
        var addStudentNameRenderer = function (data, type, full, meta) {
            // return full.student_first_name + ' ' + full.student_last_name + ' <a  href="#student/view/' + full.student_id + '" class="btn btn-xs pull-right" id="student_details_view" style="cursor: pointer;"><label class="fa fa-eye label-btn-icon"></label></a>';
            // return full.student_first_name + ' ' + full.student_last_name + ' <a  href="#student/view/' + full.student_id + '" class="btn btn-xs pull-right" id="student_details_view" style="cursor: pointer;"><label class="fa fa-eye label-btn-icon"></label></a>';

            var fullName ='<a target="_blank" href="main#student/view/'+full.student_id+'" id="student_view_btn">'+
                            '<label class="fa fa-eye label-btn-icon" style="padding-left: 3px;padding-right: 3px;"></label>'+
                        '</a> ';

            fullName += full.student_first_name + ' ' + full.student_last_name + ' ( Day '+full.schedule_day +' ) ';

            return fullName;
        };
        addStudentAttendanceDataTable = $('#add_student_attendance_data_table').DataTable({
            ajax: {
                url: 'student_attendance/get_all_student_for_attendence',
                type: "post",
                data: attendanceData,
                "dataSrc": function ( json ) {
                    return json;
                }
            },
            bAutoWidth: false,
            stateSave: true,
            ordering: false,
            lengthMenu: [10, 25, 50, 75, 100 ],
            pageLength: 75,
            columns: [
                {
                    "className": '',
//                    "orderable": false,
                    "data": 'enrollment_validity_date',
                    "visible": false
                },
                {
                    "className": '',
                    "render": addStudentNameRenderer
                },
                {
                    "className": '',
                    "data": 'student_id',
                    "render": addStudentActionRenderer
                }
            ]
        });
        $('#add_student_modal').modal("show");
    },
    addStudentForAttendence: function (studentId, enrollmentId) {
        var that = this;
        var validation = false;
        $('.student_attendance_data').each(function () {
            var id = $(this).attr("id");
            if (id == enrollmentId) {
                validation = true;
            }
        });
        if (validation == true) {
            $('#add_student_modal').modal("hide");
            showError('Student Already In List');
            return false;
        }

        var studentCourseSchedule = $("#student_course_schedule").val();
        var courseId = 0;
        var scheduleId = 0;
        if (studentCourseSchedule) {
            courseId = allScheduleAndCourseData[studentCourseSchedule]['schedule_course_id'];
            scheduleId = allScheduleAndCourseData[studentCourseSchedule]['schedule_id'];
        }
        var attendanceDate = $("#student_attendance_date").val();
        var attendancData = {
            "course_id": courseId,
            "attendance_date": attendanceDate,
            "schedule_id": scheduleId,
            "student_id": studentId,
            "enrollment_id": enrollmentId
        };
        $.ajax({
            type: 'POST',
            url: 'student_attendance/get_by_course_schedule_and_student',
            data: attendancData,
            success: function (response) {

                var responseData = JSON.parse(response);

                var parseData = responseData.data;
                if (responseData.success == false) {
                    showError(responseData.message);
                }
                $('#add_student_modal').modal("hide");
                var totalRecords = $("#student_attendance_data_table").DataTable().page.info().recordsTotal;
                if (totalRecords == 0) {



                    $('#student_attendance_data_table').children('tbody').find('tr').remove();

                    // thead_html ='<tr>'+
                    //                 '<th></th><th></th><th></th>'+
                    //                 '<th width="10%">Name</th>'+
                    //                 '<th width="10%">Mobile</th>'+
                    //                 '<th width="10%">Sub Total</th>'+
                    //                 '<th width="10%">Total Paid</th>'+
                    //                 '<th width="20%">Total Due Amount</th>'+
                    //                 '<th width="20%">Revenue</th>'+
                    //                 '<th width="10%">Status</th>'+
                    //                 '<th width="12%">Attendance</th>'+
                    //                 '<th>Actions</th>'+
                    //             '</tr>';

                    // $('#student_attendance_data_table').html(thead_html);
                }

                row_html ='<tr id="' + enrollmentId + '" class="student_attendance_data">'+
                            '<td></td><td></td><td></td>'+
                            '<td>' + parseData[0]['student_first_name'] + ' ' + parseData[0]['student_last_name'] + ' <a  href="#student/view/' + parseData[0]['student_id'] + '" class="btn btn-xs pull-right" id="student_details_view" style="cursor: pointer;"><label class="fa fa-eye label-btn-icon"></label></a></td>'+
                            '<td> '+ parseData[0]['student_mobile'] +' </td>'+
                            '<td class="text-right">' + parseData[0]['sub_total'] + '</td>'+
                            '<td class="text-right">' + parseData[0]['payment_amount'] + '</td>'+
                            '<td class="text-right">' + parseData[0]['due_amounts'] + '</td>'+
                            '<td class="text-right">' + Math.round(parseData[0]['average_amount']) + '</td>'+
                            '<td>' + that.addPresentAbsentStatus(parseData[0]['student_id'], parseData[0]['absent_or_present'], parseData[0]['course_duration'], parseData[0]['student_attendance'], enrollmentId,parseData[0]['student_attend_day']) + '</td>'+
                            '<td>' + that.addPresentAbsentTemplateData(parseData[0]['attendance_arr'],parseData[0]['student_id'], parseData[0]['absent_or_present'], parseData[0]['enrollment_validity_date'], enrollmentId,parseData[0]['schedule_date'],parseData[0]['schedule_id'],parseData[0]) + '</td>'+
                            '<td>' + studentAttendanceActionTemplate({'student_id': parseData[0]['student_id']}) + '</td>'+
                        '</tr>';


                $('#student_attendance_data_table').append(row_html);

                //$('#student_attendance_data_table').append('<tr id="' + enrollmentId + '" class="student_attendance_data"><td>' + parseData[0]['student_first_name'] + ' ' + parseData[0]['student_last_name'] + ' <a  href="#student/view/' + parseData[0]['student_id'] + '" class="btn btn-xs pull-right" id="student_details_view" style="cursor: pointer;"><label class="fa fa-eye label-btn-icon"></label></a></td><td>' + parseData[0]['sub_total'] + '</td><td>' + parseData[0]['payment_amount'] + '</td><td>' + parseData[0]['due_amounts'] + '</td><td>' + Math.round(parseData[0]['average_amount']) + '</td><td>' + that.addPresentAbsentStatus(parseData[0]['student_id'], parseData[0]['absent_or_present'], parseData[0]['course_duration'], parseData[0]['student_attendance'], enrollmentId) + '</td><td>' + that.addPresentAbsentTemplateData(parseData[0]['attendance_arr'],parseData[0]['student_id'], parseData[0]['absent_or_present'], parseData[0]['enrollment_validity_date'], enrollmentId) + '</td><td>' + studentAttendanceActionTemplate({'student_id': parseData[0]['student_id']}) + '</td></tr>');

            }
        });
    },
    addPresentAbsentTemplateData: function (attendance_arr,studentId, status, enrollmentValidityDate, enrollmentId,schedule_date,schedule_id,full) {
        var checkedNo = (status == GLOBAL_NO) ? 'checked' : '';
        var checkedYes = (status == GLOBAL_NO) ? '' : 'checked';
        var attendance_repeated = 'true';
        var add_attendance_repeate = 'true';

        return studentAttendanceTemplate({'attendance': attendance_arr,'student_id': studentId, 'enrollment_id': enrollmentId, "YES": GLOBAL_YES, "NO": GLOBAL_NO, "checked_no": checkedNo, "checked_yes": checkedYes, "enrollment_validity_date": enrollmentValidityDate,"attendance_repeated":attendance_repeated,"schedule_date":schedule_date,"schedule_id":schedule_id,"add_attendance_repeate":add_attendance_repeate,'full':full});
    },
    addPresentAbsentStatus: function (studentId, status, courseDuration, studentAttendance, enrollmentId,student_attend_day) {
        var presentNo = (status == GLOBAL_YES) ? 'display:none;' : '';
        var presentYes = (status == GLOBAL_YES) ? '' : 'display:none;';

        var attend_day = '0';
        if(student_attend_day)
        {
            attend_day = student_attend_day;
        }
        return studentAttendanceAbsentPresentTemplate({'student_id': studentId, 'enrollment_id': enrollmentId, "present_yes": presentYes, "present_no": presentNo, "course_duration": courseDuration, "student_attendance": studentAttendance,"attend_day":attend_day});
    }

});
