<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Cron_ccm_model extends CI_Model {

    function get_all_student_data($field, $interestedin_message, $today_date) {
        $this->db->select('sm.*,e.enrollment_id,s.*');
        $this->db->from('student_master as sm');
        $this->db->join('enrollment as e', 'sm.student_id=e.student_id');
        $this->db->join('enrollment_course as ec', 'e.enrollment_id=ec.enrollment_id');
        $this->db->join('schedule as s', 'ec.course_id=s.schedule_course_id');
        $this->db->where($field, $interestedin_message);
        $this->db->where('schedule_date', $today_date);
        $recs = $this->db->get();
        return $recs->result_array();
    }

    function get_birthday_students($month,$day) {        
        $this->db->where('MONTH(student_birthdate)', $month);
        $this->db->where('DAY(student_birthdate)', $day);
        $this->db->where('discontinue', DISCONTINUENO);
        $this->db->where('is_delete', ISDELETEYES);
        $result = $this->db->get('student_master');
        return $result->result_array();
    }

    function get_student_for_message($course_id,$schedule_id,$today){
        
        $this->db->select('s.student_id,s.student_mobile,s.student_first_name,s.student_last_name,s.student_interestedin_email,s.student_interestedin_message,e.enrollment_id');
        $this->db->from('enrollment_course  AS ec');
        $this->db->join('enrollment  AS e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master AS s', 's.student_id=e.student_id');
        $this->db->join('payment AS p', 'p.enrollment_id=e.enrollment_id', 'left');
        $this->db->where('ec.course_id', $course_id);
        $this->db->where('s.discontinue', DISCONTINUENO);
        $this->db->where('s.student_interestedin_message', YES);
        $this->db->where('s.student_mobile !=', '');
        $this->db->group_by('s.student_id,e.sub_total,e.due_amounts,e.average_amount,e.enrollment_id');
        $this->db->order_by('e.enrollment_validity_date, s.student_id', 'desc');
        return $this->db->get()->result_array();
    }

    function get_course() 
    {
        $this->db->select('course_id,course_title');
        $this->db->from('course');
        $res=$this->db->get();
        return $res->result_array();
    }

    function get_enroll_student()
    {
        $this->db->select('e.enrollment_id,ec.*,c.course_duration,s.student_id,s.student_first_name,s.student_last_name');
        $this->db->from('enrollment e');
        $this->db->join('enrollment_course ec','ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master s','s.student_id=e.student_id');
        $this->db->join('course c','c.course_id=ec.course_id');
        $this->db->where('e.is_delete',ISDELETEYES);
        $this->db->order_by('e.enrollment_id','ASC');
        return $this->db->get()->result_array();
    }

    function get_attendance($enrollment_id,$course_id,$student_id)
    {
        $this->db->select('sa.*');
        $this->db->from('student_attendance sa');
        $this->db->join('schedule s','s.schedule_id = sa.attendance_schedule_id');
        $this->db->where('s.schedule_course_id',$course_id);
        $this->db->where('sa.attendance_enrollment_id',$enrollment_id);
        $this->db->where('sa.attendance_student_id',$student_id);
        return $this->db->get()->result_array();
    }

    function set_interest($course_id,$student_id,$enrollment_course_id)
    {
        $this->db->select('si.*');
        $this->db->from('student_interest si');
        $this->db->where('student_id', $student_id);
        $this->db->where('course_id',$course_id);
        $res = $this->db->get()->result_array();

        if(empty($res))
        {
            $data['student_id'] = $student_id;
            $data['course_id'] = $course_id;
            $data['status'] = 1;
            $data['enrollment_course_id'] = $enrollment_course_id;
            $this->db->insert('student_interest', $data);
        }
        else
        {
            $this->db->where('student_id', $student_id);
            $this->db->where('course_id',$course_id);
            $this->db->set('enrollment_course_id', $enrollment_course_id);
            $this->db->set('status', 1);
            $this->db->update('student_interest');
        }
    }

    function get_invoice_no($year,$month)
    {
        $this->db->select('p.*');
        $this->db->from('payment p');
        $this->db->where('YEAR(p.payment_date)',$year);
        $this->db->where('MONTH(p.payment_date)',$month);
        $this->db->order_by('p.payment_id','ASC');
        return $this->db->get()->result_array();
    }

    function set_invoice_no($payment_id,$c)
    {
        $this->db->set('invoice_no',$c);
        $this->db->where('payment_id',$payment_id);
        $this->db->update('payment');
    }

}
