<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Schedule extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('courses_model');
        $this->load->model('schedule_model');
        $this->load->model('config_model');
        check_authenticated();
    }

    function save_schedule() {
        $schedule_data = $this->input->post('schedule_data');
        $main_array = array();
        foreach ($schedule_data as $single_schedule_data) {
            $schedule_id = $this->schedule_model->create($single_schedule_data);
            $result = $this->schedule_model->get_schedule_by_id($schedule_id);
            $result['schedule_date'] = to_DD_MM_YYYY($result['schedule_date']);
            array_push($main_array, $result);
        }
        echo json_encode(array('success' => TRUE, 'message' => 'Schedule saved successfully', 'schedule_data' => $main_array));
    }

    function get_schedule_data_by_date() {
        $schedule_from_data = to_database_format($this->input->post('schedule_from_date'));
        $schedule_to_data = to_database_format($this->input->post('schedule_to_date'));
//        $result = generate_array_for_id_object($this->schedule_model->get_schedule_by_date($schedule_from_data, $schedule_to_data), 'schedule_date');
        $result = $this->schedule_model->get_schedule_by_date($schedule_from_data, $schedule_to_data);
        foreach ($result as &$schedule_data) {
            $schedule_data['schedule_date'] = to_DD_MM_YYYY($schedule_data['schedule_date']);
        }
        
        echo json_encode(array('success' => TRUE, 'message' => 'Success', 'schedule_data' => $result));
    }

    function delete_schedule() {
        $schedule_id = $this->input->post('schedule_id');
        $this->schedule_model->delete_schedule_by_id($schedule_id);
        echo json_encode(array('success' => true, 'message' => 'Schedule deleted successfully'));
    }

    function generate_config_pdf() {
        $from_date = $this->input->post('from_date');
        $to_date = $this->input->post('to_date');
        $result = generate_array_for_id_object($this->config_model->get_all_data(), 'config_key');
        $data['schedule_date'] = $this->input->post('from_date');
        $data['HEADER_TEMPLATE'] = $result['HEADER_TEMPLATE'];
        $data['FOOTER_TEMPLATE'] = $result['FOOTER_TEMPLATE'];
        $data['BACK_TEMPLATE'] = $result['BACK_TEMPLATE'];
        $data['all_course_data'] = generate_array_for_id_object($this->courses_model->is_course_exist(), 'course_id');
        $data['all_schedule_data'] = $this->schedule_model->get_schedule_data_by_date($from_date, $to_date);
        $output = $this->load->view('schedule/template', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 15, 15, 20, 20, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("swad.pdf", 'I');
    }

}

/**
 * EOF: ./application/controllers/Schedule.php
 */
