<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Report extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('report_model');
        $this->load->model('schedule_model');
        $this->load->model('payment_model');
        $this->load->model('student_master_model');
        $this->load->model('student_enrollment_model');      
        check_authenticated();
    }
 
    function get_schedule_details() {
        $result = $this->_getpayment_record(FALSE);

        // echo "<pre>";
        // print_r($result);

        echo json_encode($result);
    }

    function _getpayment_record($is_from_to_date) {
        $from_date = new DateTime($this->input->post('from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $to_date->modify('+1 day');
        $new_to_date = $to_date->format('Y-m-d');        

        // $new_from_date = '2019-04-01';
        // $new_to_date = '2019-04-30';

        $begin = new DateTime($new_from_date);
        $end = new DateTime($new_to_date);
        $interval = DateInterval::createFromDateString('1 day');
        $period = new DatePeriod($begin, $interval, $end);
        $payment_mode = $this->config->item('payment_mode');

        foreach ($payment_mode as $key => $value) {
            $payment_modes_total[] = array('value'=>$value,'total'=>0);
        }        

        $main_array = array();
        foreach ($period as $dt) {
            $date = $dt->format("Y-m-d");
            $schedule_student_data = $this->report_model->get_student_payment_details($date);

            foreach ($schedule_student_data as $key => $row ) {
                $course_id = $this->report_model->get_student_course_id($row['enrollment_id']);
                $schedule_student_data[$key]['course_id'] = $course_id['course_id'];
            }

            $payment_modes = array();
            foreach ($payment_mode as $key => $value) {
                $payment_modes[] = array('value'=>$value,'total'=>0);
            }

            if (!empty($schedule_student_data)) {
                $sub_total = 0;
                $student_count = 1;
                foreach ($schedule_student_data as &$r) {
                    if (!$r['payment']) {
                        $r['payment'] = 0;
                    }

                    foreach ($payment_modes as $key => $value) {

                        if($value['value'] == $r['payment_mode'])
                        {
                            $payment_modes[$key]['total'] = $payment_modes[$key]['total'] + $r['payment'];
                            $payment_modes_total[$key]['total'] = $payment_modes_total[$key]['total'] + $r['payment'];
                        }
                    }
                    $sub_total += $r['payment'];     

                    $r['sr_no'] = $student_count;

                    $payment_modes_string = implode(' | ', array_map(function ($entry) {
                      return $entry['value'].' : <span class="red_color">'.$entry['total'].'</span>';
                    }, $payment_modes));

                    $payment_modes_total_string = implode(' | ', array_map(function ($entry1) {
                      return $entry1['value'].' : <span class="red_color">'.$entry1['total'].'</span>';
                    }, $payment_modes_total));

                    $student_count++;
                }                

                $schedule_data_array = array();
                $schedule_data_array['date'] = $dt->format("d-m-Y");
                $schedule_data_array['sub_total'] = $sub_total;
                $schedule_data_array['student_data'] = $schedule_student_data;
                $schedule_data_array['payment_mode'] = $payment_modes_string;
                $schedule_data_array['payment_mode_total'] = $payment_modes_total_string;
                array_push($main_array, $schedule_data_array);
            }
        }  

        foreach ($main_array as &$sd) {
            $report_date = new DateTime($sd['date']);
            $new_report_date = $report_date->format('Y-m-d');
            $sd_array = $this->report_model->get_schedule_by_report_date($new_report_date);

            $color = array("#ff5a5a","#ffa75a","#e6b135","#81e04a","#45d197","#45a9d1","#4578d1","#4547d1","#7445d1","#b545d1","#d145bc","#d1457b","#d14545","#d14402","#d10202","#05d102","#026fdb","#023cdb","#6402db","#a7c500");

            $c = 0;       

            foreach ($sd_array as &$schedule_data) {
                
                if($c > count($color))
                {
                    $c = 0;
                }

                $schedule_data['schedule_date'] = to_DD_MM_YYYY($schedule_data['schedule_date']);
                $schedule_data['color'] = $color[$c];
                
                $c++;
            }
            $sd['schedule_data'] = $sd_array;
        }       

        foreach ($main_array as $key1 => $value1) {

            foreach ($value1['student_data'] as $key2 => $value2) {             
            
                $course_id = explode(",",$value2['course_id']);                
                $course_color = array();
                foreach ($value1['schedule_data'] as $key3 => $value3) {

                    if (in_array($value3['schedule_course_id'],$course_id))
                    {                        
                        $course_color[] = $value3['color'];
                    }
                }
                $main_array[$key1]['student_data'][$key2]['color'] = $course_color;
            }
        }        

        foreach ($main_array as $key1 => $value1) {          

            foreach ($value1['schedule_data'] as $key2 => $value2) {                

                $count = 0;

                foreach ($value1['student_data'] as $key3 => $value3) {

                    $course_id = explode(",",$value3['course_id']);
                    if (in_array($value2['schedule_course_id'],$course_id))
                    {                        
                        $count++; 
                    }
                }

                $main_array[$key1]['schedule_data'][$key2]['total_student'] = $count;
            }
        }       

        if ($is_from_to_date) {
            $data['start_date'] = $new_from_date;
            $data['end_date'] = $new_to_date;
            $data['payment_data'] = $main_array;
            return $data;
        } else {
            return $main_array;
        }
    }

    function get_course_revenue() {
        $result = $this->report_model->get_course_revenue();
        echo json_encode($result);
    }

    function get_course_day_wise_data()
    {
        $course_id = $this->input->post('course_id');        

        $result = $this->report_model->get_course_day_wise_data($course_id);

        $date_array=array();

        if(!empty($result))
        {
            foreach ($result as $key => $value) {

                $r['course_id'] = $value['schedule_course_id'];
                $r['schedule_date'] = date_format(date_create($value['schedule_date']),'d-m-Y');
                $result2 = $this->report_model->get_course_day_schedule($value);

                $date = '';
                foreach ($result2 as $key2 => $value2) {
                    
                    $date .= 'Day '.$value2['schedule_day'].' : '.$value2['schedule_date'].' <br>';
                }

                $r['schedule_days'] = $date;
                $date_array[] = $r;            
            }
        }
        echo json_encode($date_array);       
    }

    function generate_revenue_pdf() {
        $data['revenue_data'] = $this->report_model->get_course_revenue();
        $output = $this->load->view('report/revenue_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 15, 15, 20, 20, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("revenue_reports.pdf", 'I');
    }

    function generate_payment_pdf() {
        $data = $this->_getpayment_record(TRUE);
        $output = $this->load->view('report/payment_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 15, 15, 20, 20, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("payment_reports.pdf", 'I');
    }

    function generate_all_invoice() {
        $data = $this->_getpayment_record(TRUE);
        $invoice = '';

        if(!empty($data))
        {
            foreach($data['payment_data'] as $key => $value) 
            {
                if(!empty($value['student_data']))
                {
                    foreach($value['student_data'] as $key => $value1) 
                    {                        
                        //$invoice .= $value1['payment_id']." ".$value1['student_first_name'];
                        $invoice .= $this->generate_receipt($value1['payment_id']);
                        $invoice .= '<pagebreak />';
                    }
                }
            }            
        }        
        
        $this->load->library('mpdf/MPDF');        
        $mpdf = new mPDF('utf-8', 'A4', 0, 0, 5, 5, 5, 1);
        $mpdf->WriteHTML($invoice);
        $mpdf->Output("all_invoice.pdf", 'I');
    }
    function generate_receipt($payment_id) {
            
        $payment_data = $this->payment_model->get_bill_pdf_data_by_payment_id($payment_id);
        $payment_date = date_format(date_create($payment_data['payment_date']),'Y-m-d');

        $all_payment_data = $this->payment_model->get_all_payment_of_enrollment($payment_data['enrollment_id'],$payment_id,$payment_data['payment_date']);

        //gen invoice no
        $invoice_no = 'S';
        $refund = 0;
        if($payment_data['payment_amount'] < 0)
        { 
            $refund = 1;           
            $invoice_no = 'SCN';
            $payment_data['payment_amount'] = str_replace("-","",$payment_data['payment_amount']);
        }

        $year = date_format(date_create($payment_date),'y');
        $month = date_format(date_create($payment_date),'m');

        $invoice_no = $invoice_no.$month.$year;
        
        if($payment_data['invoice_no'] != 0)
        {
            $invoice_no = $invoice_no.$payment_data['invoice_no'];
        }
        else
        {            
            $invoice_no = $invoice_no.$payment_data['payment_id'];
        }
        $payment_data['invoice_no'] = $invoice_no;
        $payment_data['gst_percentage'] = GST_PERCENTAGE;        
        $payment_data['gst_amount'] = round(($payment_data['gst_percentage'] / 100 ) * ($payment_data['payment_amount'] / 1.18));
        $payment_data['amount'] = $payment_data['payment_amount'] - $payment_data['gst_amount'];
        $payment_data['course'] = explode(',',$payment_data['courses']);

        $all_payment = array();

        foreach($all_payment_data as $key => $value) {
            
            if($value['payment_id'] == $payment_id)
            {
                break;
            }
            else
            {
                $all_payment[] = $value;
            }
        }      

        if(empty($all_payment))
        {            
            $total_due_amount =$payment_data['payable_amount']-$payment_data['payment_amount'];
            $total_paid_amount = $payment_data['payment_amount'];                      
        }
        else
        {
            
            $total_due_amount = $payment_data['payable_amount'] - $payment_data['payment_amount'] ;
            $total_paid_amount = $payment_data['payment_amount'];            

            foreach ($all_payment as $key => $value) {

                if($value['payment_amount'] > 0)
                {
                    $total_due_amount = $total_due_amount - $value['payment_amount'];
                    $total_paid_amount = $total_paid_amount + $value['payment_amount'];                
                }
            }
        }
        $payment_data['due'] = $total_due_amount;
        $payment_data['paid'] = $total_paid_amount;
        if($payment_data['payment_amount'] < 0)
        {
            $payment_data['payment_amount'] = str_replace("-","",$payment_data['payment_amount']);
        }
        $data['payment_data'] = $payment_data;
        $data['all_payment'] = $all_payment;        

        if($refund == 1)
        {            
            $output = $this->load->view('student_master/credit_note', $data, TRUE);
        }
        else
        {
            $output = $this->load->view('student_master/cash_receipt', $data, TRUE);
        }        

        return $output;
    }

    function generate_interested_student_pdf() {

         echo "<pre>";
         print_r($this->input->post());
         //exit;

        $this->load->model('courses_model');

        $course_id = $this->input->post('interets_course_id');
        $status = $this->input->post('student_status');
        $modulename = $this->input->post('modulename');
        $current_list_type = $this->input->post('current_list_type');

        if($current_list_type != '3')
        {
            if($modulename== 'attendance_module' && ($status == 2 || $status == 1))
            {
                $schedule_id = $this->input->post('schedule_id');
                $attendance_date = to_database_format($this->input->post('attendance_date'));

                $url = base_url().'student_attendance/get_student_record_by_course_schedule1';
                $post_data = array('course_id' => $course_id, 'status' => $status ,'attendance_date' => $attendance_date, 'schedule_id' => $schedule_id);
            }
            else
            {
                $url = base_url().'interest/get_student_interested_data';
                $post_data = array('course_id' => $course_id, 'status' => $status);
            }

            if($status == 0)
            {
                $list_type = 'Waiting List';
            }
            elseif($status == 1)
            {
                $list_type = 'Confirm List';
            }
            elseif($status == 2)
            {
                $list_type = 'Enrollment List';
            }

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $url,
                CURLOPT_POSTFIELDS => $post_data,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_SSL_VERIFYPEER => 0
            ));

            $output = curl_exec($ch);
            $result = json_decode($output,true);
        }
        else
        {
            $list_type = 'All Students';

            $waiting_list_url = base_url().'interest/get_student_interested_data';
            $waiting_post_data = array('course_id' => $course_id, 'status' => 0);
            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $waiting_list_url,
                CURLOPT_POSTFIELDS => $waiting_post_data,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_SSL_VERIFYPEER => 0
            ));
            $output1 = curl_exec($ch);
            $result1 = json_decode($output1,true);


            $enrolled_list_url = base_url().'student_attendance/get_student_record_by_course_schedule1';
            $enrolled_post_data = array('course_id' => $course_id, 'status' => 2 ,'attendance_date' => $attendance_date, 'schedule_id' => $schedule_id);
            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $enrolled_list_url,
                CURLOPT_POSTFIELDS => $enrolled_post_data,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_SSL_VERIFYPEER => 0
            ));
            $output2 = curl_exec($ch);
            $result2 = json_decode($output2,true);


            $confirm_list_url = base_url().'student_attendance/get_student_record_by_course_schedule1';
            $confirm_post_data = array('course_id' => $course_id, 'status' => 1 ,'attendance_date' => $attendance_date, 'schedule_id' => $schedule_id);
            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => $confirm_list_url,
                CURLOPT_POSTFIELDS => $confirm_post_data,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_SSL_VERIFYHOST => 0,
                CURLOPT_SSL_VERIFYPEER => 0
            ));
            $output3 = curl_exec($ch);
            $result3 = json_decode($output3,true);

            $result = array_merge($result1,$result2,$result3);

        }

        //exit();
        
        $course_info=$this->courses_model->get_by_courses_id($course_id);
        $data['list_type'] = $list_type;
        $data['interested_students'] = $result;
        $data['course_title'] = $course_info['course_title'];
        $data['curr_date'] = date("d-m-Y");              
        $output = $this->load->view('report/interested_student_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 5, 5, 5, 5, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("interested_student_reports.pdf", 'I');
    }

    function get_course_details_by_date() {
        $from_date = new DateTime($this->input->post('from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $new_to_date = $to_date->format('Y-m-d');
        $schedule_data = $this->report_model->get_course_details_by_schedule_date($new_from_date, $new_to_date);
        $main_array = array();
        $course_info = array();
        foreach ($schedule_data as $sd) {
            $enrollment_data = array();
            if (isset($course_info[$sd['schedule_course_id']])) {
                $enrollment_info = $this->report_model->get_enrollment_data(to_database_format($course_info[$sd['schedule_course_id']]), to_database_format($sd['schedule_date']), $sd['schedule_course_id']);
                $enrollment_amount = $this->_get_enrollment_amount($enrollment_info, $sd['course_fees']);
            } else {
                $enrollment_info = $this->report_model->get_enrollment_less_then_date($new_from_date, to_database_format($sd['schedule_date']), $sd['schedule_course_id']);
                $enrollment_amount = $this->_get_enrollment_amount($enrollment_info, $sd['course_fees']);
            }
            $course_info[$sd['schedule_course_id']] = $sd['schedule_date'];
            $enrollment_data['schedule_date'] = $sd['schedule_date'];
            $enrollment_data['course_title'] = $sd['course_title'];

            $enrollment_data['amount'] = $enrollment_amount;
            array_push($main_array, $enrollment_data);
        }
        echo json_encode($main_array);
    }

    function get_course_revenue_by_date() {

        $from_date = new DateTime($this->input->post('from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $new_to_date = $to_date->format('Y-m-d');

        // $new_from_date = '2019-05-30';
        // $new_to_date = '2019-05-31';

        $schedule_data = $this->report_model->get_course_details_by_schedule_date($new_from_date, $new_to_date);

        foreach ($schedule_data as $key => &$value) {
            $schedule_id = $value['schedule_id'];
            $schedule_date = date_format(date_create($value['schedule_date']),'Y-m-d');
            $amount = $this->report_model->get_course_revenue_attendance_wise($schedule_id,$schedule_date);
            $value['revenue_amount'] = 0;
            if(!empty($amount))
            {                
                $revenue_amount = 0;
                foreach ($amount as $key => $a) {
                      
                    if($a['average_amount'] > $value['course_fees'])
                    {
                        $revenue_amount = $value['course_fees'];
                    } 
                    else
                    {
                        $revenue_amount = $a['average_amount'];
                    }

                    $value['revenue_amount'] = $value['revenue_amount'] + $revenue_amount;
                }
            }
        }

        echo json_encode($schedule_data);
    }

    function _get_enrollment_amount($enrollment_info, $course_fees) {
        $total_enrollment_cost = 0;
        foreach ($enrollment_info as &$enrollment) {
            if ($enrollment['is_package_applied'] == IS_PACKAGE_YES) {
                $enrollment_amount = $enrollment['average_amount'];
            } else {
                if (floatval($enrollment['total_discount']) != 0) {
                    $total_discount = $enrollment['total_discount'];
                    $no_of_courses = $enrollment['no_of_courses'];
                    $average_discount = $total_discount / $no_of_courses;
                    $enrollment_amount = $course_fees - $average_discount;
                } else {
                    $enrollment_amount = $course_fees;
                }

                $total_enrollment_cost += $enrollment_amount;
            }
        }
        return $total_enrollment_cost;
    }

    function get_enrollment_data()
    {   
        $from_date = new DateTime($this->input->post('from_date'));
        $from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $to_date = $to_date->format('Y-m-d');

        $sort_by = $this->input->post('sorting_data');
        $sort_by =  explode("-",$sort_by);

        $result = $this->report_model->getEnrollmentDateWise($from_date, $to_date, $sort_by);

        $enrollment_array = array();

        if(!empty($result))
        {
            foreach ($result as $value) {

                $value['enrollment_created_date'] = date_format(date_create($value['enrollment_created_date']),'d-m-Y');

                $total_paid_amount = $value['sub_total'];

                if($value['due_amounts'] != '' && $value['due_amounts'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['due_amounts'];
                }

                if($value['total_discount'] != '' && $value['total_discount'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['total_discount'];
                }
                
                $total_paid_amount = number_format($total_paid_amount, 2, '.', '');
                
                $value['paid_amount'] = $total_paid_amount;

                $enrollment_array[] = $value;
            }
        }

        echo json_encode($enrollment_array);
    }

    function get_payment_collection_data()
    {

        $from_date = new DateTime($this->input->post('from_date'));
        $from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $to_date = $to_date->format('Y-m-d');

        $sort_by = $this->input->post('sorting_data');
        $sort_by =  explode("-",$sort_by);

        $result = $this->report_model->getPaymentCollectionData($from_date, $to_date, $sort_by);

        $enrollment_array = array();

        if(!empty($result))
        {
            foreach ($result as $value) {

                $value['enrollment_created_date'] = date_format(date_create($value['enrollment_created_date']),'d-m-Y');

                $total_paid_amount = $value['sub_total'];

                if($value['due_amounts'] != '' && $value['due_amounts'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['due_amounts'];
                }

                if($value['total_discount'] != '' && $value['total_discount'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['total_discount'];
                }

                $total_paid_amount = number_format($total_paid_amount, 2, '.', '');
                
                $value['paid_amount'] = $total_paid_amount;

                $enrollment_array[] = $value;
            }
        }        
        echo json_encode($enrollment_array);
    }
    function generate_enrollment_student_pdf()
    {
        $from_date = new DateTime($this->input->post('enrollment_from_date'));
        $from_date_new = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('enrollment_to_date'));
        $to_date_new = $to_date->format('Y-m-d');  

        $sort_by = $this->input->post('sorting_value_dropdown');
        $sort_by =  explode("-",$sort_by);      

        $result = $this->report_model->getEnrollmentDateWise($from_date_new, $to_date_new, $sort_by);

        $enrollment_array = array();

        $total_amount = 0.00;
        $total_paid = 0.00;
        $total_due = 0.00;
        $total_discount = 0.00;

        if(!empty($result))
        {
            foreach ($result as $value) {

                $total_amount = $total_amount + $value['sub_total'];
                $total_due = $total_due + $value['due_amounts'];
                $total_discount = $total_discount + $value['total_discount'];

                $value['enrollment_created_date'] = date_format(date_create($value['enrollment_created_date']),'d-m-Y');

                $total_paid_amount = $value['sub_total'];

                if($value['due_amounts'] != '' && $value['due_amounts'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['due_amounts'];
                }

                if($value['total_discount'] != '' && $value['total_discount'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['total_discount'];
                }

                $total_paid_amount = number_format($total_paid_amount, 2, '.', '');

                $value['paid_amount'] = $total_paid_amount;

                $total_paid = $total_paid + $value['paid_amount'];

                $enrollment_array[] = $value;
            }
        }

        $data['enrollment_array'] = $enrollment_array;
        $data['from_date'] = $this->input->post('enrollment_from_date');
        $data['to_date'] = $this->input->post('enrollment_to_date');
        $data['total_amount'] = $total_amount;
        $data['total_paid'] = $total_paid;
        $data['total_due'] = $total_due;
        $data['total_discount'] = $total_discount;

        $output = $this->load->view('report/enrollment_report_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 10, 10, 10, 10, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("payment_reports.pdf", 'I');        
    }
    function generate_payment_collection_pdf()
    {
        $from_date = new DateTime($this->input->post('payment_collection_from_date'));
        $from_date_new = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('payment_collection_to_date'));
        $to_date_new = $to_date->format('Y-m-d');

        $sort_by = $this->input->post('payment_collection_sorting_value_dropdown');
        $sort_by =  explode("-",$sort_by);

        $result = $this->report_model->getPaymentCollectionData($from_date_new, $to_date_new, $sort_by);

        $enrollment_array = array();

        $total_amount = 0.00;
        $total_paid = 0.00;
        $total_due = 0.00;
        $total_discount = 0.00;

        if(!empty($result))
        {
            foreach ($result as $value) {

                $total_amount = $total_amount + $value['sub_total'];
                $total_due = $total_due + $value['due_amounts'];
                $total_discount = $total_discount + $value['total_discount'];

                $value['enrollment_created_date'] = date_format(date_create($value['enrollment_created_date']),'d-m-Y');

                $total_paid_amount = $value['sub_total'];

                if($value['due_amounts'] != '' && $value['due_amounts'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['due_amounts'];
                }

                if($value['total_discount'] != '' && $value['total_discount'] != 0)
                {
                    $total_paid_amount = $total_paid_amount-$value['total_discount'];
                }
                
                $total_paid_amount = number_format($total_paid_amount, 2, '.', '');

                $value['paid_amount'] = $total_paid_amount;

                $total_paid = $total_paid + $value['paid_amount'];

                $enrollment_array[] = $value;
            }
        }

        $data['enrollment_array'] = $enrollment_array;
        $data['total_amount'] = $total_amount;
        $data['total_paid'] = $total_paid;
        $data['total_due'] = $total_due;
        $data['total_discount'] = $total_discount;

        $output = $this->load->view('report/payment_collection_report_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 10, 10, 10, 10, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("payment_reports.pdf", 'I');
    }
    /*function get_student_status()
    {
        $type=$this->input->post('type');
        $reg_date=$this->input->post('reg_date');
        if($reg_date != '')
        {
            $reg_date = date_format(date_create($reg_date),'Y-m-d');
        }

        
        //$type = 'active';

        if($type == 'active')
        {
            $to_date = date('Y-m-d');
            $from_date = date("Y-m-d", strtotime("-6 months", strtotime($to_date)));
        }
        elseif($type == 'inactive')
        {
            $to_date=date("Y-m-d", strtotime("-6 months", strtotime(date('Y-m-d'))));
            $from_date=date("Y-m-d", strtotime("-6 months", strtotime($to_date)));
        }
        elseif($type == 'lost')
        {
            $to_date=date("Y-m-d", strtotime("-12 months", strtotime(date('Y-m-d'))));
            //$from_date=date("Y-m-d", strtotime("-12 months", strtotime($to_date)));
            $from_date = '';            
        }

        $result = $this->report_model->get_student_attendance_wise($from_date,$to_date,$reg_date);

        $student = array();
        
        if(!empty($result))
        {
            if($reg_date == '')
            {
                foreach ($result as $key => $value) {

                    $res = $this->report_model->check_student_attendance_wise($type,$value['student_id'],$from_date,$to_date);
                    
                    if($type == 'inactive')
                    {
                        if($res['total_attendance'] == 0)
                        {
                            $student[]=$value;
                        }
                    }
                    elseif($type == 'lost')
                    {
                        if($res['total_attendance'] == 0)
                        {
                            $student[]=$value;
                        }
                    }
                    else
                    {
                        $student[]=$value;
                    }
                }
            }
            else
            {
                $student = $result;
            }            
        }
        echo json_encode($student);
    }*/
    function get_student_status()
    {
        $type=$this->input->post('type');
        $reg_date=$this->input->post('reg_date');
        if($reg_date != '')
        {
            $reg_date = date_format(date_create($reg_date),'Y-m-d');
        }
        else
        {
            $reg_date = date('Y-m-d');
        }

        if($type == 'lost')
        {
            $r_date = date("Y-m-d", strtotime("-12 months", strtotime($reg_date)));
            $to_date = $reg_date;
            $from_date = $r_date;
        }
        if($type == 'inactive')
        {
            $r_date = date("Y-m-d", strtotime("-6 months", strtotime($reg_date)));            
            $from_date = $r_date;
            $to_date = $reg_date;
        }
        $result = $this->report_model->get_student_attendance_wise($from_date,$to_date,$r_date);        
        
        echo json_encode($result);
    }
    function generate_student_status_pdf()
    {

        $type=$this->input->post('student_type');
        $reg_date=$this->input->post('reg_date');
        if($reg_date != '')
        {
            $reg_date = date_format(date_create($reg_date),'Y-m-d');
        }
        else
        {
            $reg_date = date('Y-m-d');
        }

        $export_type=$this->input->post('export_type');

        if($type == 'lost')
        {
            $r_date = date("Y-m-d", strtotime("-12 months", strtotime($reg_date)));
            $to_date = $reg_date;
            $from_date = $r_date;
            $title = 'Lost Student';
        }
        if($type == 'inactive')
        {
            $r_date = date("Y-m-d", strtotime("-6 months", strtotime($reg_date)));            
            $from_date = $r_date;
            $to_date = $reg_date;
            $title = 'Inactive Student';
        }

        $result = $this->report_model->get_student_attendance_wise($from_date,$to_date,$r_date);        

        $data['student_array'] = $result;
        $data['title'] = $title;

        if($export_type == 'pdf')
        {
            $output = $this->load->view('report/student_status_pdf', $data, TRUE);
            $this->load->library('mpdf/MPDF');
            $mpdf = new mPDF('utf-8', 'A4', '', '', 10, 10, 10, 10, 5, 5);
            $mpdf->WriteHTML($output);
            $mpdf->Output("student_status.pdf", 'I');
        }
        else
        {

            include_once APPPATH . "libraries/PHPExcel/Classes/PHPExcel.php";
            $objPHPExcel = new PHPExcel();
            $objRichText = new PHPExcel_RichText();

            $objPHPExcel->getActiveSheet()->SetCellValue('A1', $title);

            $objPHPExcel->getActiveSheet()->SetCellValue('A3', 'Sr #');
            $objPHPExcel->getActiveSheet()->SetCellValue('B3', 'Student Name');
            $objPHPExcel->getActiveSheet()->SetCellValue('C3', 'Mobile');
            $objPHPExcel->getActiveSheet()->SetCellValue('D3', 'Registration Date');

            $c=4;
            //$i = count($data['student_array']);
            $sr_no = 1;
            foreach ($data['student_array'] as $student) 
            {
                $objPHPExcel->getActiveSheet()->SetCellValue('A'.$c, $sr_no);
                $objPHPExcel->getActiveSheet()->SetCellValue('B'.$c, $student['student_first_name'] . ' ' . $student['student_middle_name'] . ' ' . $student['student_last_name']);
                $objPHPExcel->getActiveSheet()->SetCellValue('C'.$c, $student['student_mobile']);
                $objPHPExcel->getActiveSheet()->SetCellValue('D'.$c, $student['student_registration_date']);
                $c++;
                $sr_no++;
                //$i--;
            }

            $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A1:D1'); // merge cell

            //set bg color
                $objPHPExcel->getActiveSheet()->getStyle('A1')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "538ed5"
                    )
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A3:D3')->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                         'rgb' => "8db4e3"
                    )
                ));
            //set bg color

            //set font color
                $styleArray1 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),
                    'size'  => 13,                
                ));

                $styleArray2 = array(
                'font'  => array(
                    'bold' => true,
                    'color' => array('rgb' => 'ffffff'),                               
                ));

                $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($styleArray1);
                $objPHPExcel->getActiveSheet()->getStyle('A3:D3')->applyFromArray($styleArray2);
            //set font color

            //set autosize
                for($col = 'A'; $col !== 'D'; $col++) {
                    $objPHPExcel->getActiveSheet()
                        ->getColumnDimension($col)
                        ->setAutoSize(true);
                }
            //set autosize

            //set left
                $style = array(
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_LEFT,
                    )
                );
                for($i=2;$i<=$c-1;$i++)
                {
                    $objPHPExcel->getActiveSheet()->getStyle('A'.$i.':D'.$i)->applyFromArray($style);
                }
            //set left

            //set border
                $border_style = array(
                    'borders' => array(
                        'outline' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('rgb' => '538ed5'),
                        ),
                    ),
                );             
                $objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('B3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('C3')->applyFromArray($border_style);
                $objPHPExcel->getActiveSheet()->getStyle('D3')->applyFromArray($border_style);
                              
            //set border

            $filename ='students_excel.xls';
            $objPHPExcel->getActiveSheet()->setTitle('Student');
            $objPHPExcel->setActiveSheetIndex(0);
            header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");            
            header("Content-Disposition: attachment;filename=\"".$filename."\";");
            header("Cache-Control: max-age=1");
            $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
            $objWriter->save('php://output');            
        }        
    }
    function get_all_call_log()
    {
        $from_date = new DateTime($this->input->post('from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('to_date'));
        $new_to_date = $to_date->format('Y-m-d'); 

        //$new_from_date = '2019-06-03';
        //$new_to_date = '2019-06-06';

        $result = $this->report_model->get_call_log_date_wise($new_from_date,$new_to_date);

        echo json_encode($result);       
    }
    function generate_call_log_pdf()
    {
        $from_date = new DateTime($this->input->post('call_log_from_date'));
        $new_from_date = $from_date->format('Y-m-d');
        $to_date = new DateTime($this->input->post('call_log_to_date'));
        $new_to_date = $to_date->format('Y-m-d'); 


        $result = $this->report_model->get_call_log_date_wise($new_from_date,$new_to_date);

        $data['call_log'] = $result;

        $output = $this->load->view('report/call_log_report_pdf', $data, TRUE);
        $this->load->library('mpdf/MPDF');
        $mpdf = new mPDF('utf-8', 'A4', '', '', 10, 10, 10, 10, 5, 5);
        $mpdf->WriteHTML($output);
        $mpdf->Output("call_log.pdf", 'I');
    }

}

?>