var reportMasterTemplate = Handlebars.compile($('#report_master_template').html());
var reporttableTemplate = Handlebars.compile($('#report_table_template').html());
var revenueReportMasterTemplate = Handlebars.compile($('#revenue_report_master_template').html());
var revenueReporttableTemplate = Handlebars.compile($('#revenue_report_table_template').html());
var courseRevenueReportListTemplate = Handlebars.compile($('#course_revenue_report_list_template').html());
var courseRevenueReportTableTemplate = Handlebars.compile($('#course_revenue_report_table_template').html());
var Report = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
Report.Router = Backbone.Router.extend({
    routes: {
        'report/list': 'renderList',
        'report/revenue_report': 'renderRevenueReportList',
        'report/course_revenue_report': 'renderCourseRevenueReportList',
    },
    renderList: function () {
        Report.listview.listPage();
    },
    renderRevenueReportList: function () {
        Report.listview.revenueListPage();
    },
    renderCourseRevenueReportList: function () {
        Report.listview.courseRevenueListPage();
    }
});
Report.listView = Backbone.View.extend({
    el: 'div#main_container',
    listPage: function () {
        this.$el.html(reportMasterTemplate);
        $('.date_picker').datetimepicker({
            format: 'dd-mm-yyyy',
        });
        var totalAmount = 0;
        $('#total_amount').html(totalAmount);
//        this.generateReport();
    },
    revenueListPage: function () {
        this.$el.html(revenueReportMasterTemplate);
        $('#revenue_report_table_container').html(revenueReporttableTemplate);
        var averageAmountRenderer = function (data, type, full, meta) {
            return numberToIndianRupeesCo(Math.round(data));
//            return Math.round(data);
        };
        revenueMasterDataTable = $('#revenue_report_table').DataTable({
            ajax: {url: 'report/get_course_revenue', dataSrc: "", type: "post"},
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            pageLength: 25,
            columns: [
                {data: 'course_title'},
                {data: 'average_amount', 'render': averageAmountRenderer}
            ],
            drawCallback: function () {
                var api = this.api(), data;
                var intVal = function (i) {
                    return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '') * 1 :
                            typeof i === 'number' ?
                            i : 0;
                };
                data = api.column(1).cache('search');
                var total = data.length ?
                        data.reduce(function (a, b) {
                            return intVal(a) + intVal(b);
                        }) :
                        0;
                $('#total_revenue').html(Math.round(total));
            }
        });
    },
    generateReport: function () {
        var that = this;
        var paymentFromDate = $('#payment_from_date').val();
        var paymentToDate = $('#payment_to_date').val();
        if (paymentFromDate == '') {
            showError('Please Select From Date ');
            return false;
        }
        if (paymentToDate == '') {
            showError('Please Select To Date ');
            return false;
        }
        var FromDate = ddmmyyToDate(paymentFromDate);
        var ToDate = ddmmyyToDate(paymentToDate);
        if (FromDate.getTime() > ToDate.getTime()) {
            showError('Please Select To Date Greater Than From Date');
            return false;
        }

        FromDate = FromDate.setHours(0, 0, 0, 0);
        ToDate = ToDate.setHours(0, 0, 0, 0);
        var diffDays = parseInt((ToDate - FromDate) / (1000 * 60 * 60 * 24));
        if (diffDays > 32) {
            showError('Please Select Only One Month');
            return false;
        }

        $.ajax({
            type: 'POST',
            url: 'report/get_schedule_details',
            data: {
                'from_date': paymentFromDate,
                'to_date': paymentToDate
            },
            success: function (data) {
                var paymentData = JSON.parse(data);
                if ($.isEmptyObject(paymentData)) {
                    $('#report_table_container').html(reporttableTemplate);
                    $('#daily_report_table').append('<tr><td colspan="3" style="text-align:center">No data available in table</td</tr>');
                    return false;
                }
                that.loadReportData(paymentData);
            }
        });
    },
    loadReportData: function (paymentData) {
        $('#report_table_container').html(reporttableTemplate);
        var finalTotal = 0;
        $.each(paymentData, function (index, paymentDataObj) {
            var rowspan_cnt = (paymentDataObj.student_data).length;
            var courseTotalAmountCollected = paymentDataObj.student_data;
            var row = '';
            $.each(courseTotalAmountCollected, function (index1, amountData) {
                row += '<tr>';
                if (index1 == 0) {
                    row += '<td rowspan="' + rowspan_cnt + '">' + paymentDataObj.date;
                    $.each(paymentDataObj.schedule_data, function (index2, sd) {
                        row += '<div class="box-body" id="schedule_row_' + sd.schedule_id + '" style="background-color: #eee;margin: 0px 0px 3px 0px; margin-top: 0px;">';
                        row += '<input type="hidden" id="attendance_schedule_id_' + sd.schedule_id + '" value="' + sd.attendance_schedule_id + '">';
                        row += '<div class="row" style="margin-left: 0px;margin-right: 0px;position: relative;">';
                        row += '<div style="font-weight: bold;">' + sd.course_title + '</div>';
                        row += '<div style="font-size: 11px;">' + convert24To12Hours(sd.schedule_from_time) + ' to ' + convert24To12Hours(sd.schedule_to_time) + ' ( Day - ' + sd.schedule_day + ' )</div></div></div>';
                    });
                    row += '</td>';
                }
                row += '<td>' + amountData.student_first_name + ' ' + amountData.student_middle_name + ' ' + amountData.student_last_name + '</td>';
                row += '<td class="text-right">' + roundupAmount(amountData.payment) + '</td>';
                row += '</tr>';
            });
            finalTotal += paymentDataObj.sub_total;
            row += '<tr bgcolor="#efefef">';
            row += '<td class="text-right" colspan="2"><b>Sub Total:</b></td>';
            row += '<td class="text-right"><b>' + roundupAmount(paymentDataObj.sub_total) + '</b></td>';
            row += '</tr>';
            $('#daily_report_table').find('tbody').append(row);
        });
        $('#daily_report_table').find('tfoot').append('<tr bgcolor="#c0c0c0"><td colspan="2" class="text-right"><b>Total:</b></td><td class="text-right">' + roundupAmount(finalTotal) + ' <span class="fa fa-inr"></span></td></tr>');
    },
    exportToPdfRevenueReport: function () {
        window.open(baseUrl + 'report/generate_revenue_pdf/', "_blank");
    },
    exportToPdfPaymentReport: function () {
        var fromDate = ddmmyyToDate($('#payment_from_date').val());
        var toDate = ddmmyyToDate($('#payment_to_date').val());
        var firstDay = new Date(fromDate.getFullYear(), fromDate.getMonth(), 1);
        var lastDay = new Date(fromDate.getFullYear(), fromDate.getMonth() + 1, 0);
        if (fromDate > toDate) {
            showError('Please Select To Date greater Than From Date');
            return false;
        }
        if (!(fromDate >= firstDay && fromDate <= lastDay)) {
            showError('From Date and To Date must be of same month1');
            return false;
        }
        if (!(toDate >= firstDay && toDate <= lastDay)) {
            showError('From Date and To Date must be of same month');
            return false;
        }
        $('#from_date').val($('#payment_from_date').val());
        $('#to_date').val($('#payment_to_date').val());
        $('#print_payment_report_form').submit();
    },
    exportToPdfinterestedstudentReport: function () {
        $('#print_interested_student_report_form').submit();
    },
    courseRevenueListPage: function () {
        this.$el.html(courseRevenueReportListTemplate);
        $('.date_picker').datetimepicker({
            format: 'dd-mm-yyyy',
        });
    },
    generateCourseRevenueReport: function () {
        var that = this;
        var scheduleFromDate = $('#schedule_from_date').val();
        var scheduleToDate = $('#schedule_to_date').val();
        if (scheduleFromDate == '') {
            showError('Please Select From Date ');
            return false;
        }
        if (scheduleToDate == '') {
            showError('Please Select To Date ');
            return false;
        }
        var ScheduleFromDate = ddmmyyToDate(scheduleFromDate);
        var ScheduleToDate = ddmmyyToDate(scheduleToDate);
        if (ScheduleFromDate.getTime() > ScheduleToDate.getTime()) {
            showError('Please Select To Date Greater Than From Date');
            return false;
        }

        ScheduleFromDate = ScheduleFromDate.setHours(0, 0, 0, 0);
        ScheduleToDate = ScheduleToDate.setHours(0, 0, 0, 0);
        var diffDays = parseInt((ScheduleToDate - ScheduleFromDate) / (1000 * 60 * 60 * 24));
        if (diffDays > 32) {
            showError('Please Select Only One Month');
            return false;
        }
        $.ajax({
            type: 'POST',
            url: 'report/get_course_details_by_date',
            data: {
                'from_date': scheduleFromDate,
                'to_date': scheduleToDate
            },
            success: function (data) {
                var courseData = JSON.parse(data);
//                console.log(courseData);
                if ($.isEmptyObject(courseData)) {
                    $('#course_revenue_report_table_container').html(courseRevenueReportTableTemplate);
                    $('#course_revnue_report_table').append('<tr><td colspan="3" style="text-align:center">No data available in table</td</tr>');
                    return false;
                }
                that.loadCourseRevenueReportData(courseData);
            }
        });
    },
    loadCourseRevenueReportData: function (courseData) {
        $('#course_revenue_report_table_container').html(courseRevenueReportTableTemplate);
        var row = '';
        $.each(courseData, function (index, courseDataObj) {
            row += '<tr>';
            row += '<td>' + courseDataObj.schedule_date + '</td>';
            row += '<td>' + courseDataObj.course_title + '</td>';
            row += '<td class="text-right">' + roundupAmount(courseDataObj.amount) + '</td>';
            row += '</tr>';
        });
        $('#course_revnue_report_table').find('tbody').append(row);
    }
});