var paymentListTemplate = Handlebars.compile($('#student_payment_list_template').html());
var paymentTableTemplate = Handlebars.compile($('#student_payment_table_template').html());
var actionButtonTemplate = Handlebars.compile($('#action_buttons_template').html());
var addPaymentTemplate = Handlebars.compile($('#add_payment_modal').html());
var showPaymentsBtnCollapseTemplate = Handlebars.compile($('#show_payment_btn_collapse_template').html());
var childPaymentTableTemplate = Handlebars.compile($('#child_payment_table_template').html());
var Payment = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
Payment.Router = Backbone.Router.extend({
    routes: {
        'student/payment/:id': 'renderList'
    },
    renderList: function (student_id) {
        Payment.listview.listPage(student_id, '');
    }
});
Payment.listView = Backbone.View.extend({
    el: 'div#main_container',
    events: {
//     'click #save_pay_btn': 'paymentSave'
    },
    listPage: function (studentId) {
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'payment/get_student_name_with_total',
            data: {'student_id': studentId},
            success: function (data) {
                var parsedata = JSON.parse(data);
                that.$el.html(paymentListTemplate({"parsedata": parsedata, 'calling_module': callingModule, "course_id": courseIdForBackView}));
                $('#payment_table').html(paymentTableTemplate());
                that.loadPayment(studentId);
                //  this.viewDetail(studentId);
            }
        });
    },
    loadPayment: function (studentId) {
        var that = this;
        var showPaymentsRenderer = function (data, type, full, meta) {
            if (!$.isEmptyObject(full.payment_details)) {
                return showPaymentsBtnCollapseTemplate({'student_id': data, 'enrollment_id': full.enrollment_id});
            } else {
                return '';
            }
        };
        var paymentActionRenderer = function (data, type, full, meta) {
            if (full.due_amounts != '' && full.due_amounts != 0) {
                return actionButtonTemplate({"student_id": full.student_id, "enrollment_id": full.enrollment_id, "due_amounts": full.due_amounts});
            } else {
                return '';
            }
        };
        paymentDataTable = $('#student_payment_table').DataTable({
            ajax: {url: 'payment/get_by_payment_id', dataSrc: "", type: "post", data: {'student_id': studentId}},
            bAutoWidth: false,
            ordering: true,
            stateSave: true,
            pageLength: 25,
            columns: [
                {data: 'null', 'render': showPaymentsRenderer, "width": "10px"},
                {data: 'course_data', 'render': courseRenderer},
                {data: 'enrollment_created_date'},
                {data: 'sub_total', className: "text-right", 'render': roundupAmount},
                {data: 'pay_amount', className: "text-right", 'render': roundupAmount},
                {data: 'discount', className: "text-right", 'render': roundupAmount},
                {data: 'due_amounts', className: "text-right", 'render': roundupAmount},
                {
                    "className": '',
                    "orderable": true,
                    "data": 'student_id',
                    "render": paymentActionRenderer
                }
            ],
            "createdRow": function (row, data, dataIndex) {
                if ((data['due_amounts'] >= 0) && (data['due_amounts'] != 0)) {
                    $(row).css("background-color", "#fff7f8");
//                    $(row).addClass("danger");
                }
            },
            "fnDrawCallback": function (nRow) {
                $('.payment_btn').each(function () {
                    Payment.listview.paidPaymentDetails($(this));
                });
                $('.payment_date').datepicker();
            }
        });
        if ($('#due_amounts').val() == '0') {
            $('.pay').hide();
        }
    },
    Payment: function (studentId, enrollmentId, dueAmount) {
        $('#add_payment_container').html(addPaymentTemplate({"student_id": studentId, "enrollment_id": enrollmentId, "due_amounts": dueAmount}));
        renderOptionsForTwoDimensionalArray_payment_mode(paymentModeArray, 'payment_mode', true);
        $('#payment_mode option[value="Cash"]').prop('selected', true);
        $('#payment_modal').modal({"show": true, "backdrop": 'static', "keyboard": false});
        $('.payment_date').val(dateTo_DD_MON_YYYY(new Date()));
        $('.payment_date').datepicker({'format': 'dd-mm-yyyy', autoclose: true});
        $('.select2').select2({"allowClear": true});
    },
    showYearlyMembershipCoursePayment: function (buttonObj) {
        var tr = buttonObj.closest('tr');
        var row = paymentDataTable.row(tr);
        var enrollmentData = row.data();
        var course_name = (enrollmentData.course_name).split(",");
        $('#yearlymember_container').html(courseNameTemplate());
        $.each(course_name, function (key, value) {
            $('#yearlymember_row').append('<li class="list-group-item">' + value + '</li>');
        });
        $('#yearlymember_model').modal({"show": true, "backdrop": 'static', "keyboard": false});
    },
    paymentSave: function () {
        var that = this;
        var currDate = new Date().setHours(0, 0, 0, 0);
        var paymentFormData = $('#add_payment_from').serializeFormJSON();
        if (paymentFormData.student_pay == '') {
            showError('Please Enter Amount.');
            return false;
        }
        if (paymentFormData.pay_date == '') {
            showError('Please Enter Date.');
            return false;
        }
        if (paymentFormData.payment_mode == '') {
            showError('Please Enter Payment mode.');
            return false;
        }
        var payDateObject = ddmmyyToDate(paymentFormData.pay_date).setHours(0, 0, 0, 0);
        if (payDateObject < currDate) {
            getConfirmPassword(function (result) {
                if (result === false) {
                    return false;
                }
                var tempPassword = $('#temp_password').val();
                if (tempPassword == 'sw@d') {
                    that.savePaid(paymentFormData);
                    $('#temp_password').val('');
                } else {
                    showError("Please Enter Correct Password");
                    $('#temp_password').val('');
                }
            });
        } else {
            that.savePaid(paymentFormData);
        }
    },
    savePaid: function (paymentFormData) {
        $.ajax({
            type: 'POST',
            url: 'payment/save_payment',
            data: paymentFormData,
            success: function (data) {
                var paymentData = JSON.parse(data);
                if (paymentData.success == false) {
                    showError(paymentData.message);
                    return false;
                }
                $("#payment_modal").modal("hide");
                Payment.listview.listPage(paymentFormData.student_id, '');
                showSuccess(paymentData.message);
            }
        });
    },
    paidPaymentDetails: function (obj) {
        var tr = obj.parents('tr');
        var row = paymentDataTable.row(tr);
        var that = this;
        var detailsIconLink = tr.find('.show-payment-details-control');
        if (row.child.isShown()) {
            // This row is already open - close it
            row.child.hide();
            tr.removeClass('shown');
            detailsIconLink.removeClass('fa-minus').addClass('fa-plus');
        } else {
            // Open this row
            row.child(that.formatPayment(row.data())).show();
            tr.addClass('shown');
            detailsIconLink.removeClass('fa-plus').addClass('fa-minus');
        }
    },
    formatPayment: function (payment_details) {
        // `d` is the original data object for the row
        if (payment_details != undefined) {
            return childPaymentTableTemplate({'payments': payment_details.payment_details});
        }
        return "";
    },
    deletePayment: function (paymentId) {
        getConfirmPassword(function (result) {
            if (result === false) {
                return false;
            }
            var tempPassword = $('#temp_password').val();
            if (tempPassword == 'sw@d') {
                var that = this;
                $.ajax({
                    type: 'post',
                    url: 'payment/delete_payment',
                    data: {
                        "payment_id": paymentId
                    },
                    success: function (data) {
                        var parseData = JSON.parse(data);
                        if (parseData.success == false) {
                            return false;
                        }
                        $('#' + paymentId).remove();
                        showSuccess(parseData.message);
                        $('#temp_password').val('');
                        paymentDataTable.ajax.reload();
                    }
                });
            } else {
                showError("Please Enter Correct Password");
                $('#temp_password').val('');
            }
        });
    },
    exportToPdfPrintBill: function (paymentId) {
        window.open(baseUrl + 'payment/generate_bill_pdf/' + paymentId, "_blank");
    }
});