var packagesTemplate = Handlebars.compile($('#packages_template').html());
var packagesItemTemplate = Handlebars.compile($('#packages_item_template').html());
var packagesListTemplate = Handlebars.compile($('#packages_list_template').html());
var packagesTableTemplate = Handlebars.compile($('#packages_table_template').html());
var packagesActionsButtonsTemplate = Handlebars.compile($('#packages_action_buttons_template').html());
var packagesCnt = 0;
var Packages = {
    run: function () {
        this.router = new this.Router();
        this.listview = new this.listView();
    }
};
Packages.Router = Backbone.Router.extend({
    routes: {
        'packages/list': 'renderList'
    },
    renderList: function () {
        Packages.listview.listPage();
        this.navigate('packages/list');
    },
    renderPackages: function () {
        Packages.listview.packageCourses();
        this.navigate('packages/list');
    }
});
Packages.listView = Backbone.View.extend({
    el: 'div#main_container',
    events: {
        'click #save_packages_btn': 'savePackagesItem',
        'click #edit_packages_btn_': 'editPackage',
        'click #update_packages_btn': 'updatePackages'
    },
    listPage: function () {
        this.$el.html(packagesListTemplate);
        $('#package_table_container').html(packagesTableTemplate);
        this.loadPackageTable(false);
    },
    packageCourses: function (isEdit, packageData) {
        packagesCnt = 0;
        $('#package_form_container').html(packagesTemplate);

        this.addPackages(isEdit, packageData, true);
        if (isEdit) {
            $('.packages_remove_btn').hide();
            $('.packages_add_btn').hide();
            $('.save_packages_btn').hide();
            $('.update_packages_btn').show();
        } else {
            $('.packages_remove_btn').hide();
            $('.packages_add_btn').show();
            $('.save_packages_btn').show();
            $('.update_packages_btn').hide();
        }

    },
    addPackages: function (isEdit, packageData, isFirst) {
        packagesCnt++;
        $('#package_add').hide();
        var templateData = {
            'packages_counter': packagesCnt,
            'package_data': packageData
        };
        $('#packages_item_container').append(packagesItemTemplate(templateData));
//        $('.packages_remove_btn').hide();
        if (isFirst) {
            $('.packages_remove_btn').hide();
            $('.packages_add_btn').show();
        } else {
            $('.packages_remove_btn').show();
            $('.packages_add_btn').hide();
            $('#packages_remove_btn_' + packagesCnt).show();
        }
//        $('.packages_remove_btn').hide();
        $('#packages_add_btn_' + packagesCnt).show();
        $('#packages_remove_btn_' + packagesCnt).hide();
        $('.date_picker').datepicker({
            'format': 'dd-mm-yyyy',
            autoclose: true
        });

    },
    removePackageItem: function (counter) {
        $('#packages_item_div_' + counter).remove();
    },
    savePackagesItem: function () {
        var packagesArray = this.getPackageData();
        if (!packagesArray) {
            return false;
        }
        $.ajax({
            type: 'POST',
            url: 'packages/save_packages',
            data: {'packages_form_data': packagesArray},
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData.package_validity_no == 0) {
                    parseData.package_validity_no = ' - ';
                }
                if (parseData.success == false) {
                    showError(parseData.message);
                    return false;
                }
                showSuccess(parseData.message);
                Packages.listview.listPage();
            }
        });
    },
    getPackageData: function () {
        var packagesArray = [];
        var isPackageDataValidation;
        $('.packages_item').each(function () {
            var itemCounter = $(this).find('.item_counter').val();
            var packagesFormData = $('#packages_form_' + itemCounter).serializeFormJSON();
            if (packagesFormData.no_of_course === '' || packagesFormData.no_of_course == 0) {
                showError('Please Enter No of Courses');
                $('#no_of_course_' + itemCounter).focus();
                isPackageDataValidation = true;
                return false;
            }
            if (packagesFormData.no_of_free_course === '' || packagesFormData.no_of_free_course == 0) {
                showError('Please Enter No of Free Courses');
                $('#no_of_free_course_' + itemCounter).focus();
                isPackageDataValidation = true;
                return false;
            }
            if (packagesFormData.validity === '') {
                packagesFormData.validity = '01-01-1970';
            }
            if (packagesFormData.package_validity_no === '') {
                packagesFormData.package_validity_no = '-';
                packagesFormData.package_validity_duration = '-';
            }
            packagesArray.push(packagesFormData);
        });
        if (isPackageDataValidation) {
            return false;
        }
        return packagesArray;
    },
    loadPackageTable: function (isDestroy) {
        if (isDestroy) {
            packageDataTable.destroy();
        }
        var packagesActionsrender = function (data, type, full, meta) {
            return packagesActionsButtonsTemplate({"package_id": data});
        };
        var getDurationDataRenderer = function (data, type, full, meta) {
            return full.package_validity_no == 0 ? '-' : full.package_validity_no + ' ' + full.package_validity_duration;
        };
        var displayDateRenderer = function (data, type, full, meta) {
            return full.validity == '1970-01-01' ? '-' : dateTo_DD_MM_YYYY(yyyymmddToDate(data));
        };

        packageDataTable = $('#package_data_table').DataTable({
            ajax: {url: 'packages/view_packages', dataSrc: "", type: "post",
                error: function (xhr, textStatus, error) {
                }
            },
            bAutoWidth: false,
            ordering: false,
            stateSave: true,
            pageLength: 25,
            columns: [
                {data: 'no_of_course'},
                {data: 'no_of_free_course'},
//                {data: 'validity', 'render': displayDateRenderer, type: 'date-eu'},
                {data: 'validity', 'render': displayDateRenderer, type: 'date-eu'},
                {data: 'package_validity_no', 'render': getDurationDataRenderer},
                {
                    "className": '',
                    "orderable": false,
                    "data": 'package_id',
                    "render": packagesActionsrender
                }
            ]
        });
    },
    editPackage: function (packageId) {
        $('#edit_packages_btn_' + packageId).hide();
        $('#spinner_edit_packages_btn_' + packageId).show();
        document.body.scrollTop = 2;
        var that = this;
        $.ajax({
            type: 'POST',
            url: 'packages/get_by_id/' + packageId,
            data: {'package_id': packageId},
            success: function (data) {
                var parseData = JSON.parse(data);
                that.packageCourses(true, parseData);
                $('#edit_packages_btn_' + packageId).show();
                $('#spinner_edit_packages_btn_' + packageId).hide();
                if (parseData.validity == '01-01-1970') {
                    $('#validity_' + packagesCnt).val('');
                    return false;
                }
                $('#package_validity_duration').val(parseData.package_validity_duration);
                $('.date_picker').datepicker({
                    'format': 'dd-mm-yyyy',
                    autoclose: true
                });
            }
        });
    },
    updatePackages: function () {
        var packagesFormData = $('#packages_form_' + 1).serializeFormJSON();
        if (packagesFormData.no_of_course === '' || packagesFormData.no_of_course == 0) {
            showError('Please Enter No of Courses');
            $('#no_of_course_' + 1).focus();
            return false;
        }
        if (packagesFormData.no_of_free_course === '' || packagesFormData.no_of_free_course == 0) {
            showError('Please Enter No of Free Courses');
            $('#no_of_free_course_' + 1).focus();
            return false;
        }
        if (packagesFormData.validity === '') {
            packagesFormData.validity = '01-01-1970';
        }
        if (packagesFormData.package_validity_no === '') {
            packagesFormData.package_validity_no = '-';
            packagesFormData.package_validity_duration = '-';
        }
        $.ajax({
            type: 'POST',
            url: 'packages/update',
            data: packagesFormData,
            success: function (data) {
                var parseData = JSON.parse(data);
                if (parseData.success == false) {
                    showError(parseData.message);
                    return false;
                }
                showSuccess(parseData.message);
                Packages.listview.listPage();
            }
        });
    },
    deletePackage: function (packageId) {
        getConfirm(function (result) {
            if (result === false) {
                return false;
            }
            var that = this;
            $.ajax({
                type: 'post',
                url: 'packages/delete_packages',
                data: {
                    "package_id": packageId
                },
                success: function (data) {
                    var parseData = JSON.parse(data);
                    if (parseData.success == false) {
                        return false;
                    }
                    showSuccess(parseData.message);
                    that.loadPackageTable(true);
                }
            });
        });
    }
});

 