<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Student_master_model extends CI_Model {

    function create($student) {
        $student['student_created_date'] = date('Y-m-d h:i:s');
        $this->db->insert('student_master', $student);
        return $this->db->insert_id();
    }

    /**
     * get student info by student data
     * @param type $student
     * @return type
     */
    function get_student_info($student) {
        $this->db->where('student_mobile', $student['student_mobile']);
        if ($student['student_id'] != '') {
            $this->db->where('student_id !=' . $student['student_id']);
        }
        $this->db->where('is_delete !=' . ISDELETENO);
        $recs = $this->db->get('student_master');
        return $recs->result_array();
    }

    function get_all_student($search_data) {
        $this->db->select('student_master.*, count(e.enrollment_id) AS total_enrollment, sum(e.due_amounts) AS due_amounts');
        if ($search_data['address'] != '') {
            $this->db->like('student_address', $search_data['address']);
        }
        if ($search_data['reference'] != '') {
            $this->db->where('student_reference', $search_data['reference']);
        }
        if ($search_data['gender'] != '') {
            $this->db->where('student_gender', $search_data['gender']);
        }
        if ($search_data['group_tag'] != '') {
            $this->db->like('student_group_tag', $search_data['group_tag']);
        }
        $this->db->where('student_master.is_delete', ISDELETEYES);
        $this->db->join('enrollment as e', 'student_master.student_id=e.student_id', 'left');
        $this->db->group_by('student_master.student_id');
        $this->db->order_by('student_id', 'desc');
        $resc = $this->db->get('student_master');
        return $resc->result_array();
    }

    function get_by_student_id($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->from('student_master');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function update_student($student_id, $student) {
        $student['student_updated_date'] = date('Y-m-d h:i:s');
        $this->db->where('student_id', $student_id);
        $this->db->update('student_master', $student);
    }

    function update_image($student_id, $image_name) {
        $this->db->where('student_id', $student_id);
        $this->db->set('student_photo', $image_name);
        $this->db->update('student_master');
    }

    function delete_image($student_id) {
        $this->db->where('student_id', $student_id);
        $this->db->set('student_photo', '');
        $this->db->update('student_master');
    }

    function get_by_student_id_for_email_and_sms($student_id) {
        $this->db->select('sm.*,ec.enrollment_course_name,s.schedule_date,s.schedule_from_time,s.schedule_to_time');
        $this->db->from('student_master as sm');
        $this->db->join('enrollment as e', 'sm.student_id=e.student_id');
        $this->db->join('enrollment_course as ec', 'e.enrollment_id=ec.enrollment_id');
        $this->db->join('schedule as s', 'ec.course_id=s.schedule_course_id');
        $this->db->where('sm.student_id', $student_id);
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function discontinue_student_from_attendance($student_id, $student_data) {
        $this->db->where('student_id', $student_id);
        $this->db->update('student_master', $student_data);
    }

    function delete_student($studentId, $student_data) {
        $this->db->where('student_id', $studentId);
        $this->db->update('student_master', $student_data);
    }

    function get_student_distinct_group_tags(){
        $this->db->select('DISTINCT(student_group_tag)');
        $this->db->where("student_group_tag != ''");
        $resc = $this->db->get('student_master');
        return $resc->result_array();
    }
}

/**
 * EOF: ./application/models/Courses_model.php
 */
