<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Courses_model extends CI_Model {

    function create($courses) {
        $courses['course_created_date'] = date('Y-m-d h:i:s');
        $this->db->insert('course', $courses);
        return $this->db->insert_id();
    }

    function get_all_type() {
//        $this->db->order_by('course_id');
        $this->db->order_by('course_title', 'asc');
        return $this->db->get('course')->result_array();
    }

    function is_course_exist() {
        $this->db->where('course_is_selling', YES);
        $this->db->where('course_is_active', YES);
        $this->db->order_by('course_title', 'asc');
        return $this->db->get('course')->result_array();
    }

    function get_by_courses_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->from('course');
        $resc = $this->db->get();
        return $resc->row_array();
    }

    function update_courses($courses_id, $courses) {
        $courses['course_updated_date'] = date('Y-m-d h:i:s');
        $this->db->where('course_id', $courses_id);
        $this->db->update('course', $courses);
    }

    function delete_course_by_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->delete('course');
    }

    function get_exists_course_details($courses_title) {
        $this->db->where('course_title', $courses_title);
        return $this->db->get('course')->row_array();
    }

    function get_enrollment_details($course_id, $from_date, $to_date) {
        $this->db->select(' DATE_FORMAT(e.enrollment_created_date, "%d-%m-%Y") AS enrollment_date,c.course_title,c.course_id,
                    e.student_id,sm.student_first_name,sm.student_middle_name,e.sub_total,e.enrollment_id,
                    sm.student_last_name,ec.enrollment_course_amount,c.course_duration, sm.student_mobile ');
        $this->db->from('course AS c');
        $this->db->join('enrollment_course AS ec', 'c.course_id=ec.course_id');
        $this->db->join('enrollment AS e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master AS sm', 'e.student_id=sm.student_id');
        $this->db->where('c.course_id', $course_id);
        if ($from_date != '' && $to_date != '') {
            $this->db->where('enrollment_created_date >="' . $from_date . ' 00:00:00"');
            $this->db->where('enrollment_created_date <="' . $to_date . ' 23:59:59"');
        }
        return $this->db->get()->result_array();
    }

    function get_enrollment_course_details($student_id) {
        $this->db->select('count(ec.enrollment_id) as no_of_course,e.enrollment_id');
        $this->db->from('enrollment_course as ec');
        $this->db->join(' enrollment as e', 'ec.enrollment_id=e.enrollment_id');
        $this->db->join('student_master as sm', 'e.student_id=sm.student_id');
        $this->db->where('sm.student_id', $student_id);
        $this->db->group_by('ec.enrollment_id');
        return $this->db->get()->row_array();
    }

    function get_enrollment_by_course_id($courses_id) {
        $this->db->where('course_id', $courses_id);
        $this->db->from('enrollment_course');
        $rec = $this->db->get();
        return $rec->result_array();
    }
    
    function get_schedule_by_course_id($courses_id) {
        $this->db->where('schedule_course_id', $courses_id);
        $this->db->from('schedule');
        $rec = $this->db->get();
        return $rec->result_array();
    }
    
    function get_interest_by_course_id($courses_id) {
        $this->db->where('si.course_id', $courses_id);
        $this->db->where('sm.is_delete', ISDELETEYES);
        $this->db->from('student_interest AS si');
        $this->db->join('student_master AS sm', 'si.student_id=sm.student_id');
        $rec = $this->db->get();
        return $rec->result_array();
    }

}

/**
 * EOF: ./application/models/Courses_model.php
 */
